/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

public class CCSSystemctl {
    private static final Logger LOG = Logger.getLogger(CCSSystemctl.class.getName());

    public static void main(String[] args) throws Exception {
        String command;
        String help;
        if (args.length == 1 && ((help = args[0].replace("-", "")).equals("h") || help.equals("help"))) {
            System.out.println("CCS Interface to systemctl. Usage:\n\nccs-systemctl [start|stop|restart] [service_name] [restart_seconds]\n\nwhere restart_seconds is the number of seconds the subsystem is expected to come back on the buses; this argument is accepted only for a restart command and, by default is set to 120.");
        }
        if (args.length < 2 || args.length > 3) {
            throw new IllegalArgumentException("At most three arguments are expected");
        }
        switch (command = args[0]) {
            case "stop": 
            case "start": 
            case "restart": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal systemctl command " + command + ". Only start|stop|restart are accepted.");
            }
        }
        String serviceName = args[1];
        if (command.equals("restart")) {
            File binFile;
            int restart_seconds = 120;
            if (args.length == 3) {
                restart_seconds = Integer.parseInt(args[2]);
            }
            String jarPath = CCSSystemctl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String[] p = jarPath.split("/");
            Object basePath = "/";
            boolean done = false;
            for (String str : p) {
                basePath = (String)basePath + str + "/";
                if (done) break;
                done = str.equals("ccs");
            }
            if (!(binFile = new File((String)(basePath = (String)basePath + "bin"), serviceName)).exists()) {
                throw new RuntimeException("Could not find executable for specified application: " + binFile.getAbsolutePath());
            }
            String subsystemNameOnBuses = null;
            List<CallSite> commandList = List.of("/bin/bash", "-c", binFile.getAbsolutePath() + " --printNameOnBuses");
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            try {
                Process process = processBuilder.start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String s = null;
                ArrayList<String> output = new ArrayList<String>();
                while ((s = stdInput.readLine()) != null) {
                    output.add(s);
                }
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    System.out.println("Failed to fetch the name of the subsystem on the buses " + output + " code " + exitCode);
                }
                subsystemNameOnBuses = (String)output.get(output.size() - 1);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            Subsystem restartSubsystem = null;
            try {
                restartSubsystem = new Subsystem("ccs-systemctl", AgentInfo.AgentType.LISTENER);
                restartSubsystem.startAgent();
                restartSubsystem.getMessagingAccess().getAgentPresenceManager().waitForConnectedAgent(subsystemNameOnBuses, 10L, TimeUnit.SECONDS);
                ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(restartSubsystem.getMessagingAccess());
                CommandRequest shutdownCommand = new CommandRequest(subsystemNameOnBuses, "shutdown --withLock " + String.valueOf(restart_seconds));
                Object object = cmu.sendSynchronousCommand(shutdownCommand);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (restartSubsystem != null) {
                    restartSubsystem.shutdownAgent();
                }
            }
        }
        List<CallSite> commandList = List.of("/bin/bash", "-c", "sudo systemctl " + command + " " + serviceName);
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String message = String.format("Process terminated with non-zero return code %d", exitCode);
                System.out.println(message);
                LOG.log(Level.WARNING, message);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.exit(0);
    }
}

