
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPSNAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKS_NAME;

import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

import java.util.logging.Logger;

/**
 *
 * @author virieux
 */
public interface InterfaceAutochangerGUI extends InterfaceGeneralGUI {
    final Logger FCSLOG = Logger.getLogger(InterfaceAutochangerGUI.class.getName());
    long getTimeoutForTrucksMotion();

    long getTimeoutForOnlineClampMotion();

    long getTimeoutForLatchesMotion();

    long getTimeoutForAlignFollower();

    void setTimeoutForTrucksMotion(long timeout);

    void setTimeoutForOnlineClampMotion(long timeout);

    void setTimeoutForLatchesMotion(long timeout);

    void setTimeoutForAlignFollower(long timeout);

    /**
     ******************************************************************************
     ** Trucks Actions
     * *****************************************************************************
     */
    default void acUpdateTrucksPosition() {
        FCSLOG.info("Autochanger updating Trucks position");
        FCSLOG.info("/timeout=" + READ_CONTROLLER_TIMEOUT);
        sendCommand("updatePosition", READ_CONTROLLER_TIMEOUT, AC_TRUCKS_NAME);
    }

    default void acAlignFollower() {
        FCSLOG.info("Autochanger aligning follower");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("alignFollower", getTimeoutForAlignFollower(), AC_NAME);
    }

    default void acAlignFollowerForLoader() {
        FCSLOG.info("Autochanger aligning follower for loader");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("alignFollowerForLoader", getTimeoutForAlignFollower(), AC_NAME);
    }

    default void acGoToHandOff() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("goToHandOff", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acGoToHandOffForLoader() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position for Loader");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("goToHandOffForLoader", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acGoToStandby() {
        FCSLOG.info("Autochanger Trucks going to Standby Position");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("goToStandby", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acMoveToApproachStandby() {
        FCSLOG.info("Autochanger Trucks going to Approach Standby Position");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("moveToApproachStandby", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acGoToOnline() {
        FCSLOG.info("Autochanger Trucks going to Online Position");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("goToOnline", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acMoveAndClampFilterOnline() {
        FCSLOG.info("Autochanger Trucks moving to Online Position, and clamping");
        FCSLOG.info("/timeout=" + getTimeoutForTrucksMotion());
        sendCommand("moveAndClampFilterOnline", getTimeoutForTrucksMotion(), AC_NAME);
    }

    default void acSlowTrucksProfile() {
        long timeout =2000;
        FCSLOG.info("Setting trucks slow velocity and acceleration profile");
        FCSLOG.info("/timeout=" + timeout);
        sendCommand("slowTrucksProfile", timeout, AC_NAME);
    }

    default void acFastTrucksProfile() {
        long timeout =2000;
        FCSLOG.info("Setting trucks fast velocity and acceleration profile");
        FCSLOG.info("/timeout=" + timeout);
        sendCommand("fastTrucksProfile", timeout, AC_NAME);
    }

    default void acUnclampAndMoveFilterToHandoff() {
        sendCommand("unclampAndMoveFilterToHandoff", getTimeoutForTrucksMotion(), AC_NAME);
    }

    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    default void unlockOnlineClamps() {
        FCSLOG.info("Autochanger unlocking online clamps");
        sendCommand("unlockClamps", getTimeoutForOnlineClampMotion(), AC_NAME);
    }

    default void lockOnlineClamps() {
        FCSLOG.info("Autochanger locking online clamps");
        sendCommand("lockClamps", getTimeoutForOnlineClampMotion(), AC_NAME);
    }

    default void closeOnlineClamps() {
        FCSLOG.info("Autochanger closing online clamps");
        sendCommand("closeClamps", getTimeoutForOnlineClampMotion(), AC_NAME);
    }

    default void homingOnlineClamps() {
        FCSLOG.info("Autochanger online clamps homing");
        sendCommand("homing", getTimeoutForOnlineClampMotion(), AC_CLAMPSNAME);
    }

    default void openOnlineClamps() {
        FCSLOG.info("Autochanger opening online clamps");
        sendCommand("openClamps", getTimeoutForOnlineClampMotion(), AC_NAME);
    }

    default void homingOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger homing online clamp: " + clampName);
        sendCommand("openInCurrentModeAndHoming", getTimeoutForOnlineClampMotion(), clampName);
    }

    default void openOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger opening clamp: " + clampName);
        sendCommand("open", getTimeoutForOnlineClampMotion(), clampName);
    }

    default void closeOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger closing clamp: " + clampName);
        sendCommand("close", getTimeoutForOnlineClampMotion(), clampName);
    }

    default void lockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger clamping clamp: " + clampName);
        sendCommand("lock", getTimeoutForOnlineClampMotion(), clampName);
    }

    default void unlockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger unclamping clamp: " + clampName);
        sendCommand("unlock", getTimeoutForOnlineClampMotion(), clampName);
    }

    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Latches Actions
     * *****************************************************************************
     *
     * @param latchName
     */
    default void closeLatch(String latchName) {
        FCSLOG.info("Autochanger opening latch: " + latchName);
        FCSLOG.info("/timeout=" + getTimeoutForLatchesMotion());
        sendCommand("close", getTimeoutForLatchesMotion(), latchName);
    }

    default void openLatch(String latchName) {
        FCSLOG.info("Autochanger closing latch: " + latchName);
        FCSLOG.info("/timeout=" + getTimeoutForLatchesMotion());
        sendCommand("open", getTimeoutForLatchesMotion(), latchName);
    }

    default void closeLatches() {
        FCSLOG.info("Autochanger closing latches.");
        FCSLOG.info("/timeout=" + getTimeoutForLatchesMotion());
        sendCommand("closeLatches", getTimeoutForLatchesMotion(), AC_NAME);
    }

    default void openLatches() {
        FCSLOG.info("Autochanger opening latches.");
        FCSLOG.info("/timeout=" + getTimeoutForLatchesMotion());
        sendCommand("openLatches", getTimeoutForLatchesMotion(), AC_NAME);
    }

    /**
     ******************************************************************************
     ** end of Latches Actions
     * *****************************************************************************
     */

}
