/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.CostException;
import org.apache.commons.math.optimization.CostFunction;
import org.apache.commons.math.optimization.PointCostPair;
import org.apache.commons.math.random.CorrelatedRandomVectorGenerator;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.random.RandomVectorGenerator;
import org.apache.commons.math.random.UncorrelatedRandomVectorGenerator;
import org.apache.commons.math.random.UniformRandomGenerator;
import org.apache.commons.math.stat.descriptive.moment.VectorialCovariance;
import org.apache.commons.math.stat.descriptive.moment.VectorialMean;

public abstract class DirectSearchOptimizer {
    private static Comparator pointCostPairComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double cost2;
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            double cost1 = ((PointCostPair)o1).getCost();
            return cost1 < (cost2 = ((PointCostPair)o2).getCost()) ? -1 : (o1 == o2 ? 0 : 1);
        }
    };
    protected PointCostPair[] simplex;
    private CostFunction f;
    private int evaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private PointCostPair[] minima;

    protected DirectSearchOptimizer() {
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, double[] vertexA, double[] vertexB) throws CostException, ConvergenceException {
        this.buildSimplex(vertexA, vertexB);
        this.setSingleStart();
        return this.minimize(f, maxEvaluations, checker);
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, double[] vertexA, double[] vertexB, int starts, long seed) throws CostException, ConvergenceException {
        this.buildSimplex(vertexA, vertexB);
        double[] mean = new double[vertexA.length];
        double[] standardDeviation = new double[vertexA.length];
        for (int i = 0; i < vertexA.length; ++i) {
            mean[i] = 0.5 * (vertexA[i] + vertexB[i]);
            standardDeviation[i] = 0.5 * Math.abs(vertexA[i] - vertexB[i]);
        }
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(seed);
        UniformRandomGenerator urg = new UniformRandomGenerator(rg);
        UncorrelatedRandomVectorGenerator rvg = new UncorrelatedRandomVectorGenerator(mean, standardDeviation, urg);
        this.setMultiStart(starts, rvg);
        return this.minimize(f, maxEvaluations, checker);
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, double[][] vertices) throws CostException, ConvergenceException {
        this.buildSimplex(vertices);
        this.setSingleStart();
        return this.minimize(f, maxEvaluations, checker);
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, double[][] vertices, int starts, long seed) throws NotPositiveDefiniteMatrixException, CostException, ConvergenceException {
        try {
            this.buildSimplex(vertices);
            VectorialMean meanStat = new VectorialMean(vertices[0].length);
            VectorialCovariance covStat = new VectorialCovariance(vertices[0].length, true);
            for (int i = 0; i < vertices.length; ++i) {
                meanStat.increment(vertices[i]);
                covStat.increment(vertices[i]);
            }
            double[] mean = meanStat.getResult();
            RealMatrix covariance = covStat.getResult();
            JDKRandomGenerator rg = new JDKRandomGenerator();
            rg.setSeed(seed);
            CorrelatedRandomVectorGenerator rvg = new CorrelatedRandomVectorGenerator(mean, covariance, 1.0E-12 * covariance.getNorm(), new UniformRandomGenerator(rg));
            this.setMultiStart(starts, rvg);
            return this.minimize(f, maxEvaluations, checker);
        }
        catch (DimensionMismatchException dme) {
            throw new RuntimeException("internal error");
        }
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, RandomVectorGenerator generator) throws CostException, ConvergenceException {
        this.buildSimplex(generator);
        this.setSingleStart();
        return this.minimize(f, maxEvaluations, checker);
    }

    public PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker, RandomVectorGenerator generator, int starts) throws CostException, ConvergenceException {
        this.buildSimplex(generator);
        this.setMultiStart(starts, generator);
        return this.minimize(f, maxEvaluations, checker);
    }

    private void buildSimplex(double[] vertexA, double[] vertexB) {
        int n = vertexA.length;
        this.simplex = new PointCostPair[n + 1];
        for (int i = 0; i <= n; ++i) {
            double[] vertex = new double[n];
            if (i > 0) {
                System.arraycopy(vertexB, 0, vertex, 0, i);
            }
            if (i < n) {
                System.arraycopy(vertexA, i, vertex, i, n - i);
            }
            this.simplex[i] = new PointCostPair(vertex, Double.NaN);
        }
    }

    private void buildSimplex(double[][] vertices) {
        int n = vertices.length - 1;
        this.simplex = new PointCostPair[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.simplex[i] = new PointCostPair(vertices[i], Double.NaN);
        }
    }

    private void buildSimplex(RandomVectorGenerator generator) {
        double[] vertex = generator.nextVector();
        int n = vertex.length;
        this.simplex = new PointCostPair[n + 1];
        this.simplex[0] = new PointCostPair(vertex, Double.NaN);
        for (int i = 1; i <= n; ++i) {
            this.simplex[i] = new PointCostPair(generator.nextVector(), Double.NaN);
        }
    }

    private void setSingleStart() {
        this.starts = 1;
        this.generator = null;
        this.minima = null;
    }

    private void setMultiStart(int starts, RandomVectorGenerator generator) {
        if (starts < 2) {
            this.starts = 1;
            this.generator = null;
            this.minima = null;
        } else {
            this.starts = starts;
            this.generator = generator;
            this.minima = null;
        }
    }

    public PointCostPair[] getMinima() {
        return (PointCostPair[])this.minima.clone();
    }

    private PointCostPair minimize(CostFunction f, int maxEvaluations, ConvergenceChecker checker) throws CostException, ConvergenceException {
        this.f = f;
        this.minima = new PointCostPair[this.starts];
        for (int i = 0; i < this.starts; ++i) {
            this.evaluations = 0;
            this.evaluateSimplex();
            boolean loop = true;
            while (loop) {
                if (checker.converged(this.simplex)) {
                    this.minima[i] = this.simplex[0];
                    loop = false;
                    continue;
                }
                if (this.evaluations >= maxEvaluations) {
                    this.minima[i] = null;
                    loop = false;
                    continue;
                }
                this.iterateSimplex();
            }
            if (i >= this.starts - 1) continue;
            this.buildSimplex(this.generator);
        }
        Arrays.sort(this.minima, pointCostPairComparator);
        if (this.minima[0] == null) {
            throw new ConvergenceException("none of the {0} start points lead to convergence", new Object[]{Integer.toString(this.starts)});
        }
        return this.minima[0];
    }

    protected abstract void iterateSimplex() throws CostException;

    protected double evaluateCost(double[] x) throws CostException {
        ++this.evaluations;
        return this.f.cost(x);
    }

    protected void evaluateSimplex() throws CostException {
        for (int i = 0; i < this.simplex.length; ++i) {
            PointCostPair pair = this.simplex[i];
            if (!Double.isNaN(pair.getCost())) continue;
            this.simplex[i] = new PointCostPair(pair.getPoint(), this.evaluateCost(pair.getPoint()));
        }
        Arrays.sort(this.simplex, pointCostPairComparator);
    }

    protected void replaceWorstPoint(PointCostPair pointCostPair) {
        int n = this.simplex.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(this.simplex[i].getCost() > pointCostPair.getCost())) continue;
            PointCostPair tmp = this.simplex[i];
            this.simplex[i] = pointCostPair;
            pointCostPair = tmp;
        }
        this.simplex[n] = pointCostPair;
    }
}

