/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceFcsGUI
extends InterfaceGeneralGUI {
    public static final Logger FCSLOG = Logger.getLogger(InterfaceFcsGUI.class.getName());
    public static final long CONNECT_LOADER_TIMEOUT = 6000L;
    public static final long SET_FILTER_TIMEOUT = 120000L;
    public static final long STORE_FILTER_TIMEOUT = 60000L;
    public static final long LOAD_FILTER_TIMEOUT = 240000L;
    public static final long GRAB_FILTER_TIMEOUT = 25000L;
    public static final long DISENGAGE_FILTER_TIMEOUT = 15000L;
    public static final long TRUCKS_MOTION_TIMEOUT = 50000L;
    public static final long WAKE_FILTER_CHANGER_TIMEOUT = 15000L;

    default public void setFilter(int filterID) {
        FCSLOG.fine(() -> "GUI: Setting filter with a timeout of 120000");
        this.sendCommand("setFilter " + filterID, 120000L);
    }

    default public void setFilterByName(String filterName) {
        FCSLOG.fine(() -> "GUI: Setting filter with a timeout of 120000");
        this.sendCommand("setFilter " + filterName, 120000L);
    }

    default public void setFilterAtHandoffForLoader(int filterID) {
        FCSLOG.fine(() -> "GUI: Setting filter at Handoff for Loader with a timeout of 120000");
        this.sendCommand("setFilterAtHandoffForLoader " + filterID, 120000L);
    }

    default public void setFilterAtHandoffForLoaderByName(String filterName) {
        FCSLOG.fine(() -> "GUI: Setting filter at Handoff for Loader with a timeout of 120000");
        this.sendCommand("setFilterAtHandoffForLoader " + filterName, 120000L);
    }

    default public void storeFilterOnCarousel() {
        FCSLOG.fine(() -> "GUI: Storing filter on Carousel with a timeout of 60000");
        this.sendCommand("storeFilterOnCarousel", 60000L);
    }

    default public void loadFilter() {
        FCSLOG.fine(() -> "GUI: Loading filter in Camera with a timeout of 240000");
        this.sendCommand("loadFilter", 240000L);
    }

    default public void unloadFilter() {
        FCSLOG.fine(() -> "GUI: Unloading filter from the Camera with a timeout of 240000");
        this.sendCommand("unloadFilter", 240000L);
    }

    default public void connectLoader() {
        FCSLOG.fine(() -> "GUI: Connecting loader CANbus with a timeout of 6000");
        this.sendCommand("connectLoaderCANbus", 6000L);
    }

    default public void disconnectLoader() {
        FCSLOG.fine(() -> "GUI: Disconnecting loader CANbus with a timeout of 6000");
        this.sendCommand("disconnectLoaderCANbus", 6000L);
    }

    default public void rotateSocketToStandby(int socketID) {
        FCSLOG.fine(() -> "GUI: Carousel rotating with a timeout of 100000");
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        this.sendCommand("rotateSocketToStandby socket" + socketID, 100000L, "carousel");
    }

    default public void grabFilterAtStandby() {
        FCSLOG.fine(() -> "GUI: Grab filter at Standby with a timeout of 25000");
        this.sendCommand("grabFilterAtStandby", 25000L, "autochanger");
    }

    default public void disengageFilterFromCarousel() {
        FCSLOG.fine(() -> "GUI: Disengage filter from Carousel with a timeout of 15000");
        this.sendCommand("disengageFilterFromCarousel", 15000L);
    }

    default public void moveAndClampFilterOnline() {
        FCSLOG.fine(() -> "GUI: executing Move and clamp filter online with a timeout of 50000");
        this.sendCommand("moveAndClampFilterOnline", 50000L, "autochanger");
    }

    default public void unclampAndMoveFilterToHandoff() {
        FCSLOG.fine(() -> "GUI: executing Unclamp and move filter to handoff with a timeout of 50000");
        this.sendCommand("unclampAndMoveFilterToHandoff", 50000L, "autochanger");
    }

    default public void wakeFilterChanger(int mode) {
        FCSLOG.fine(() -> "GUI: executing wakeFilter a timeout of 15000");
        this.sendCommand("wakeFilterChanger " + mode, 15000L);
    }
}

