/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTruckPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTwoTrucksPanel
extends JPanel {
    private static final long serialVersionUID = 1545510390830387685L;
    private static final Logger FCSLOG = Logger.getLogger(AutochangerTwoTrucksPanel.class.getName());
    private final String trucksName;
    private InterfaceAutochangerGUI subs;
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the controllers:");
    private final JLabel homingLabel = new JLabel();
    private final JPanel deltaPositionPanel = new JPanel();
    private final JLabel driverPositionLabel = new JLabel();
    private final JLabel followerPositionLabel = new JLabel();
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel driverSideLabel = new JLabel();
    private final AutochangerTruckPanel truckXminusPanel;
    private final AutochangerTruckPanel truckXplusPanel;
    private final JLabel standbyPositionjLabel = new JLabel();
    private final JLabel standbyPositionEmptyjLabel = new JLabel();
    private final JLabel approachStandbyPositionjLabel = new JLabel();
    private final JLabel handoffPositionjLabel = new JLabel();
    private final JLabel onlinePositionjLabel = new JLabel();
    private final JLabel slowMotionPositionjLabel = new JLabel();
    private final JLabel approachOnlinePositionjLabel = new JLabel();
    private final JLabel speedMaxjLabel = new JLabel();
    private final JLabel currentMaxjLabel = new JLabel();
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton alignFollowerButton = new JButton("alignFollower");
    private final JButton alignFollowerForLoaderButton = new JButton("alignFollowerForLoader");
    private final JButton moveToApproachStandbyButton = new JButton("moveToApproachStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToHandoffForLoaderButton = new JButton("goToHandOffForLoader");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    private final JPanel velocityControlPanel = new JPanel();
    private final JLabel profileVelocityLabel = new JLabel("0");
    private final JLabel profileAccelerationLabel = new JLabel("0");
    private final JLabel profileDecelerationLabel = new JLabel("0");
    private final JButton slowTrucksProfileButton = new JButton("slowTrucksProfile");
    private final JButton fastTrucksProfileButton = new JButton("fastTrucksProfile");

    public AutochangerTwoTrucksPanel(String trucksName) {
        this.trucksName = trucksName;
        this.truckXminusPanel = new AutochangerTruckPanel("acTruckXminus");
        this.truckXplusPanel = new AutochangerTruckPanel("acTruckXplus");
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }

    public void updateTruck(String truckName, StatusDataPublishedByAutochangerTruck s) {
        if (null == truckName) {
            FCSLOG.severe(truckName + ": Unknown name for autochanger truck. Can't update GUI.");
        } else {
            switch (truckName) {
                case "acTruckXminus": {
                    this.truckXminusPanel.updateTruck(s);
                    break;
                }
                case "acTruckXplus": {
                    this.truckXplusPanel.updateTruck(s);
                    break;
                }
                default: {
                    FCSLOG.severe(truckName + ": Unknown name for autochanger truck. Can't update GUI.");
                }
            }
        }
    }

    public void updateController(String controllerName, StatusDataPublishedByEPOSController s) {
        if ("acTruckXminusController".equals(controllerName)) {
            this.truckXminusPanel.updateController(s);
            this.update(s);
        } else if ("acTruckXplusController".equals(controllerName)) {
            this.truckXplusPanel.updateController(s);
        }
    }

    public void update(StatusDataPublishedByEPOSController s) {
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    private void initComponents() {
        this.setDefaultValues();
        this.updateStateWithSensorsButton.addActionListener(this::updateStateWithSensorsActionPerformed);
        this.updatePositionButton.addActionListener(this::updatePositionActionPerformed);
        this.alignFollowerButton.addActionListener(this::alignFollowerActionPerformed);
        this.alignFollowerForLoaderButton.addActionListener(this::alignFollowerForLoaderActionPerformed);
        this.goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);
        this.goToHandoffForLoaderButton.addActionListener(this::goToHandoffForLoaderActionPerformed);
        this.goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);
        this.moveToApproachStandbyButton.addActionListener(this::moveToApproachStandbyActionPerformed);
        this.quickStopButton.addActionListener(this::quickStopActionPerformed);
        this.abortButton.addActionListener(this::abortActionPerformed);
        this.slowTrucksProfileButton.addActionListener(this::slowTrucksProfilePerformed);
        this.fastTrucksProfileButton.addActionListener(this::fastTrucksProfilePerformed);
        this.homingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Homing"));
        this.homingPanel.setLayout(new GridBagLayout());
        this.homingLabel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_big;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.homingLabel.setFont(Tools.BIG_FONT);
        this.homingPanel.add((Component)this.homLabel, gbc1);
        ++gbc1.gridx;
        this.homingPanel.add((Component)this.homingLabel, gbc1);
        this.deltaPositionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Delta Position"));
        this.deltaPositionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.deltaPositionPanel.setFont(Tools.BIG_FONT);
        this.deltaPositionPanel.add((Component)new JLabel("driver side = "), gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)new JLabel("driver position = "), gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)new JLabel("follower position = "), gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)new JLabel("driver position - follower position = "), gbc2);
        gbc2.gridy = 0;
        ++gbc2.gridx;
        gbc2.anchor = 22;
        this.driverSideLabel.setFont(Tools.BIG_FONT);
        this.deltaPositionPanel.add((Component)this.driverSideLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.driverPositionLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.followerPositionLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.deltaPositionLabel, gbc2);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(Tools.getConfigurationTitle());
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        generalInfoPanel.add((Component)new JLabel("Online Position (in micron): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Approach Online Position (in micron): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Slow Motion Position (in micron): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Hand-Off Position (in micron): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Standby Position (in micron): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Standby Position Empty: "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Approach Standby Position: "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Speed max (in rpm/mn): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Current max (in mA): "), gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        generalInfoPanel.add((Component)this.onlinePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.approachOnlinePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.slowMotionPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.handoffPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.standbyPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.standbyPositionEmptyjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.approachStandbyPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedMaxjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.currentMaxjLabel, gbc3);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.alignFollowerButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.alignFollowerForLoaderButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToOnlineButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffForLoaderButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.moveToApproachStandbyButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.abortButton, gbc4);
        this.velocityControlPanel.setLayout(new GridBagLayout());
        this.velocityControlPanel.setBorder(Tools.getConfigurationTitle());
        gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        this.velocityControlPanel.add((Component)new JLabel("ProfileVelocity: "), gbc4);
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)new JLabel("ProfileAcceleration: "), gbc4);
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)new JLabel("ProfileDeceleration: "), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        gbc4.anchor = 22;
        this.velocityControlPanel.add((Component)this.profileVelocityLabel, gbc4);
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)this.profileAccelerationLabel, gbc4);
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)this.profileDecelerationLabel, gbc4);
        gbc4.gridx = 0;
        gbc4.anchor = 23;
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)this.slowTrucksProfileButton, gbc4);
        ++gbc4.gridy;
        this.velocityControlPanel.add((Component)this.fastTrucksProfileButton, gbc4);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER TRUCKS"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 512;
        this.add((Component)this.homingPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.deltaPositionPanel, gbc);
        gbc.anchor = 11;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.truckXminusPanel, gbc);
        ++gbc.gridy;
        this.add((Component)generalInfoPanel, gbc);
        ++gbc.gridx;
        --gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.truckXplusPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)controlPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.velocityControlPanel, gbc);
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(ActionEvent evt) {
        this.subs.acUpdateTrucksPosition();
    }

    private void alignFollowerActionPerformed(ActionEvent evt) {
        this.subs.acAlignFollower();
    }

    private void alignFollowerForLoaderActionPerformed(ActionEvent evt) {
        this.subs.acAlignFollowerForLoader();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.acGoToHandOff();
    }

    private void goToHandoffForLoaderActionPerformed(ActionEvent evt) {
        this.subs.acGoToHandOffForLoader();
    }

    private void goToOnlineActionPerformed(ActionEvent evt) {
        this.subs.acGoToOnline();
    }

    private void moveToApproachStandbyActionPerformed(ActionEvent evt) {
        this.subs.acMoveToApproachStandby();
    }

    private void quickStopActionPerformed(ActionEvent evt) {
        this.subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void slowTrucksProfilePerformed(ActionEvent evt) {
        this.subs.acSlowTrucksProfile();
    }

    private void fastTrucksProfilePerformed(ActionEvent evt) {
        this.subs.acFastTrucksProfile();
    }

    private void setDefaultValues() {
        this.standbyPositionjLabel.setText(Integer.toString(0));
        this.handoffPositionjLabel.setText(Double.toString(0.0));
        this.onlinePositionjLabel.setText(Double.toString(0.0));
        this.approachOnlinePositionjLabel.setText(Double.toString(0.0));
        this.speedMaxjLabel.setText(Integer.toString(0));
        this.currentMaxjLabel.setText(Integer.toString(0));
        this.homingLabel.setText("NOT DONE");
        this.homingLabel.setForeground(Color.red);
        this.deltaPositionLabel.setText(Integer.toString(0));
        this.driverPositionLabel.setText(Integer.toString(0));
        this.followerPositionLabel.setText(Integer.toString(0));
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.truckXminusPanel.resetPanel();
        this.truckXplusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "Trucks";
    }

    public static void main(String[] argv) {
        AutochangerTwoTrucksPanel d = new AutochangerTwoTrucksPanel("autochanger/autochangerTrucks");
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerTwoTrucksPanel.this.trucksName);
            FCSLOG.fine(() -> AutochangerTwoTrucksPanel.this.trucksName + " configForName=" + configForName);
            AutochangerTwoTrucksPanel.this.subs.setTimeoutForTrucksMotion(Long.parseLong((String)configForName.get("timeoutForTrucksMotion")));
            AutochangerTwoTrucksPanel.this.subs.setTimeoutForAlignFollower(Long.parseLong((String)configForName.get("timeoutForAlignFollower")));
            int standbyPosition = Integer.parseInt((String)configForName.get("standbyPosition"));
            int standbyPositionEmpty = Integer.parseInt((String)configForName.get("standbyPositionEmpty"));
            int approachStandbyPosition = Integer.parseInt((String)configForName.get("approachStandbyPosition"));
            int handoffPosition = Integer.parseInt((String)configForName.get("handoffPosition"));
            int onlinePosition = Integer.parseInt((String)configForName.get("onlinePosition"));
            int slowMotionPosition = Integer.parseInt((String)configForName.get("slowMotionPosition"));
            int approachOnlinePosition = Integer.parseInt((String)configForName.get("approachOnlinePosition"));
            AutochangerTwoTrucksPanel.this.standbyPositionjLabel.setText(Integer.toString(standbyPosition));
            AutochangerTwoTrucksPanel.this.standbyPositionEmptyjLabel.setText(Integer.toString(standbyPositionEmpty));
            AutochangerTwoTrucksPanel.this.approachStandbyPositionjLabel.setText(Integer.toString(approachStandbyPosition));
            AutochangerTwoTrucksPanel.this.handoffPositionjLabel.setText(Integer.toString(handoffPosition));
            AutochangerTwoTrucksPanel.this.onlinePositionjLabel.setText(Integer.toString(onlinePosition));
            AutochangerTwoTrucksPanel.this.slowMotionPositionjLabel.setText(Integer.toString(slowMotionPosition));
            AutochangerTwoTrucksPanel.this.approachOnlinePositionjLabel.setText(Integer.toString(approachOnlinePosition));
            AutochangerTwoTrucksPanel.this.speedMaxjLabel.setText((String)configForName.get("maxSpeed"));
            AutochangerTwoTrucksPanel.this.currentMaxjLabel.setText((String)configForName.get("maxCurrent"));
            AutochangerTwoTrucksPanel.this.driverSideLabel.setText((String)configForName.get("driverSide"));
            AutochangerTwoTrucksPanel.this.truckXminusPanel.initializeGui(standbyPosition, onlinePosition);
            AutochangerTwoTrucksPanel.this.truckXplusPanel.initializeGui(standbyPosition, onlinePosition);
        }
    }

    class UpdateTrucks
    implements Runnable {
        private final StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                AutochangerTwoTrucksPanel.this.homingLabel.setText("DONE");
                AutochangerTwoTrucksPanel.this.homingLabel.setForeground(Color.green);
            } else {
                AutochangerTwoTrucksPanel.this.homingLabel.setText("NOT DONE");
                AutochangerTwoTrucksPanel.this.homingLabel.setForeground(Color.red);
            }
            AutochangerTwoTrucksPanel.this.driverPositionLabel.setText(Integer.toString(this.s.getDriverPosition()));
            AutochangerTwoTrucksPanel.this.followerPositionLabel.setText(Integer.toString(this.s.getFollowerPosition()));
            AutochangerTwoTrucksPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getDriverPosition() - this.s.getFollowerPosition()));
        }
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                AutochangerTwoTrucksPanel.this.profileVelocityLabel.setText(Long.toString(this.s.getProfileVelocity()));
                AutochangerTwoTrucksPanel.this.profileAccelerationLabel.setText(Long.toString(this.s.getProfileAcceleration()));
                AutochangerTwoTrucksPanel.this.profileDecelerationLabel.setText(Long.toString(this.s.getProfileDeceleration()));
            }
        }
    }
}

