/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class Versions
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Special/Versions";
    private final Pattern pat = Pattern.compile("([^/]+)/static/version\\.([^/]+)");

    @Create(category="AgentChannelsFilter", name="Versions", path="Built-In/Special/Versions", description="Channels filter that selects software versions channels.")
    public Versions() {
    }

    @Override
    public String getDisplayPath(String originPath) {
        Matcher m = this.pat.matcher(originPath);
        if (m.matches()) {
            return m.group(1) + "/" + m.group(2);
        }
        return null;
    }

    @Override
    public String getOriginPath(String displayPath) {
        String[] ss = displayPath.split("/");
        return ss.length == 2 ? ss[0] + "/static/version." + ss[1] : null;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("[^/]+/static/version\\.[^/]+");
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? Collections.singletonList("value") : Arrays.asList("value", "HOST");
    }

    @Override
    public String getName() {
        return "Versions";
    }
}

