/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.FcsCameraProtectionPanel;
import org.lsst.ccs.subsystems.fcs.ui.InterfaceFcsGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

public class FcsGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger FCSLOG = Logger.getLogger(FcsGeneralViewPanel.class.getName());
    private static final String NONE = "NONE";
    private InterfaceFcsGUI subs;
    private final String title = "FCS Overview";
    private JPanel autochangerPanel;
    private JPanel carouselPanel;
    private JPanel loaderPanel;
    private JPanel loaderControlPanel;
    private JPanel controlPanel;
    private JPanel subCommandsPanel;
    private JPanel rotatePanel;
    private JPanel setFilterPanel;
    private final JLabel filterONLINELabel = new JLabel("NONE");
    private final JLabel filterOnTrucksLabel = new JLabel("NONE");
    private final JLabel onlineClampsStateLabel = new JLabel("UNKNOWN");
    private final JLabel latchesStateLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionNameLabel = new JLabel("UNKNOWN");
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel ioModuleStatusLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final JLabel caClampsStateLabel = new JLabel();
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel loaderClampHomingLabel = new JLabel();
    private final JLabel filterOnLoaderLabel = new JLabel();
    private final JLabel loaderClampStateLabel = new JLabel();
    private final JLabel loaderClampPositionLabel = new JLabel();
    private final JLabel loaderCarrierPositionLabel = new JLabel();
    private final JLabel loaderCarrierPositionNameLabel = new JLabel();
    private final FcsCameraProtectionPanel cameraStatusPanel = new FcsCameraProtectionPanel();
    private final JButton setFilterButton = new JButton("Set Filter");
    private final JButton setNoFilterButton = new JButton("Set No Filter");
    private final JButton loadFilterButton = new JButton("Load filter into camera");
    private final JButton unloadFilterButton = new JButton("Unload filter from camera");
    private final JButton connectLoaderButton = new JButton("Connect loader");
    private final JButton disconnectLoaderButton = new JButton("Disconnect loader");
    private final JTextField filterField = new JTextField(2);
    private final JButton setFilterAtHandoffForLoaderButton = new JButton("Set Filter for loader");
    private final JButton setNoFilterAtHandoffForLoaderButton = new JButton("Set No Filter for loader");
    private final JButton storeFilterOnCarouselButton = new JButton("Store filter on Carousel");
    private final JButton grabFilterAtStandbyButton = new JButton("Grab filter at Standby");
    private final JButton disengageFilterFromCarouselButton = new JButton("Disengage filter from carousel");
    private final JButton moveAndClampFilterOnlineButton = new JButton("Move and clamp filter Online");
    private final JButton rotateSocketToStandbyButton = new JButton("Rotate socket to standby");
    private final String[] socketList = new String[]{"        ", "Socket 1", "Socket 2", "Socket 3", "Socket 4", "Socket 5"};
    private final JComboBox<String> socketMenu = new JComboBox<String>(this.socketList);
    private final JLabel socketLabel = new JLabel("Choose destination socket: ");
    private final JLabel filterLabel = new JLabel("Selected filter ID:");
    private int socketID;
    private int filterID;

    public FcsGeneralViewPanel() {
        this.initComponents();
    }

    public void setSubs(InterfaceFcsGUI subs) {
        this.subs = subs;
    }

    void updateFromStatusData(KeyValueData data) {
        if (data.getValue() instanceof StatusDataPublishedByAutochangerThreeClamps) {
            this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTwoLatches) {
            this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChangerTrucks) {
            this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarousel) {
            this.updateCarousel((StatusDataPublishedByCarousel)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderClamp) {
            this.updateLoaderClamp((StatusDataPublishedByLoaderClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderCarrier) {
            this.updateLoaderCarrier((StatusDataPublishedByLoaderCarrier)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus1/loaderPlutoGateway".equals(data.getKey())) {
            this.cameraStatusPanel.updateLoaderFromSensorList((KeyValueDataList)data.getValue());
            this.updateFromSensorList((KeyValueDataList)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus0/acSensorsGateway".equals(data.getKey())) {
            this.cameraStatusPanel.updateAutochangerFromSensorList((KeyValueDataList)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus0/hyttc580/plc".equals(data.getKey())) {
            this.cameraStatusPanel.updateCarouselFromSensorList((KeyValueDataList)data.getValue());
        }
    }

    void updateCarousel(StatusDataPublishedByCarousel s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel data:");
        SwingUtilities.invokeLater(new UpdateCarousel(s));
    }

    void updateController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel controller data:");
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    void updateCarrierController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(() -> this.getName() + " updating from loader carrier controller data:");
        SwingUtilities.invokeLater(new UpdateCarrierController(s));
    }

    void updateClampController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(this.getName() + " updating from loader clamp controller data:");
        SwingUtilities.invokeLater(new UpdateClampController(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateOnlineClamps(s));
    }

    void updateLoaderClamp(StatusDataPublishedByLoaderClamp s) {
        SwingUtilities.invokeLater(new UpdateLoaderClamp(s));
    }

    void updateLoaderCarrier(StatusDataPublishedByLoaderCarrier s) {
        SwingUtilities.invokeLater(new UpdateLoaderCarrier(s));
    }

    void updateFromSensorList(KeyValueDataList kvdl) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(kvdl));
    }

    private void initComponents() {
        this.filterField.setToolTipText("Filter IDs can be found in FCS>Carousel>Filter list");
        this.setFilterButton.setToolTipText("command: setFilter");
        this.setNoFilterButton.setToolTipText("command: setNoFilter");
        this.setFilterAtHandoffForLoaderButton.setToolTipText("command: setFilterAtHandoffForLoader");
        this.setNoFilterAtHandoffForLoaderButton.setToolTipText("command: setNoFilterAtHandoffForLoader");
        this.storeFilterOnCarouselButton.setToolTipText("command: storeFilterOnCarousel");
        this.rotateSocketToStandbyButton.setToolTipText("command: rotateSocketToStandby");
        this.grabFilterAtStandbyButton.setToolTipText("command: grabFilterAtStandby");
        this.disengageFilterFromCarouselButton.setToolTipText("command: disengageFilterFromCarousel");
        this.moveAndClampFilterOnlineButton.setToolTipText("command: moveAndClampFilterOnline");
        this.connectLoaderButton.setToolTipText("command: connectLoaderCANbus");
        this.loadFilterButton.setToolTipText("command: loadFilter");
        this.unloadFilterButton.setToolTipText("command: unloadFilter");
        this.disconnectLoaderButton.setToolTipText("command: disconnectLoaderCANbus");
        this.setFilterButton.addActionListener(evt -> this.setFilterButtonActionPerformed(evt));
        this.setFilterAtHandoffForLoaderButton.addActionListener(evt -> this.setFilterAtHandoffForLoaderButtonActionPerformed(evt));
        this.setNoFilterButton.addActionListener(evt -> this.setNoFilterButtonActionPerformed(evt));
        this.setNoFilterAtHandoffForLoaderButton.addActionListener(evt -> this.setNoFilterAtHandoffForLoaderButtonActionPerformed(evt));
        this.loadFilterButton.addActionListener(evt -> this.loadFilterButtonActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterButtonActionPerformed(evt));
        this.connectLoaderButton.addActionListener(evt -> this.connectLoaderButtonActionPerformed(evt));
        this.disconnectLoaderButton.addActionListener(evt -> this.disconnectLoaderButtonActionPerformed(evt));
        this.storeFilterOnCarouselButton.addActionListener(evt -> this.storeFilterOnCarouselActionPerformed(evt));
        this.rotateSocketToStandbyButton.addActionListener(evt -> this.rotateSocketToStandbyActionPerformed(evt));
        this.grabFilterAtStandbyButton.addActionListener(evt -> this.grabFilterAtStandbyActionPerformed(evt));
        this.disengageFilterFromCarouselButton.addActionListener(evt -> this.disengageFilterFromCarouselActionPerformed(evt));
        this.moveAndClampFilterOnlineButton.addActionListener(evt -> this.moveAndClampFilterOnlineActionPerformed(evt));
        this.loaderControlPanel = new JPanel();
        this.loaderControlPanel.setBorder(BorderFactory.createTitledBorder("Loader commands"));
        this.loaderControlPanel.setLayout(new GridBagLayout());
        JPanel loaderLoadPanel = new JPanel();
        loaderLoadPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        loaderLoadPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        loaderLoadPanel.add((Component)this.loadFilterButton, gbc1);
        ++gbc1.gridy;
        loaderLoadPanel.add((Component)this.unloadFilterButton, gbc1);
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.loaderControlPanel.add((Component)this.connectLoaderButton, gbc1);
        ++gbc1.gridy;
        this.loaderControlPanel.add((Component)loaderLoadPanel, gbc1);
        ++gbc1.gridy;
        this.loaderControlPanel.add((Component)this.disconnectLoaderButton, gbc1);
        this.setFilterPanel = new JPanel();
        this.setFilterPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setFilterPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        gbc1.gridwidth = 2;
        this.setFilterPanel.add((Component)this.setFilterButton, gbc1);
        ++gbc1.gridy;
        this.setFilterPanel.add((Component)this.setFilterAtHandoffForLoaderButton, gbc1);
        ++gbc1.gridy;
        gbc1.gridwidth = 1;
        gbc1.fill = 0;
        this.setFilterPanel.add((Component)this.filterLabel, gbc1);
        ++gbc1.gridx;
        this.setFilterPanel.add((Component)this.filterField, gbc1);
        this.controlPanel = new JPanel();
        this.controlPanel.setBorder(BorderFactory.createTitledBorder("Filter commands"));
        this.controlPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        gbc1.gridwidth = 2;
        this.controlPanel.add((Component)this.setFilterPanel, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.setNoFilterButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.setNoFilterAtHandoffForLoaderButton, gbc1);
        this.rotatePanel = new JPanel();
        this.rotatePanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.rotatePanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        gbc1.gridwidth = 2;
        this.rotatePanel.add((Component)this.rotateSocketToStandbyButton, gbc1);
        ++gbc1.gridy;
        gbc1.gridwidth = 1;
        gbc1.fill = 0;
        this.rotatePanel.add((Component)this.socketLabel, gbc1);
        ++gbc1.gridx;
        this.rotatePanel.add(this.socketMenu, gbc1);
        this.subCommandsPanel = new JPanel();
        this.subCommandsPanel.setBorder(BorderFactory.createTitledBorder("Filter subcommands"));
        this.subCommandsPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        gbc1.gridwidth = 3;
        this.subCommandsPanel.add((Component)this.storeFilterOnCarouselButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.rotatePanel, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.grabFilterAtStandbyButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.disengageFilterFromCarouselButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.moveAndClampFilterOnlineButton, gbc1);
        this.setBorder(Tools.getGeneralPanelTitle("FCS Overview"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 512;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.cameraStatusPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 3;
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createEmptyBorder());
        statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints statusGbc = new GridBagConstraints();
        statusGbc.anchor = 512;
        statusGbc.gridx = 0;
        statusGbc.gridy = 0;
        statusGbc.insets = Tools.insets_std;
        statusPanel.add((Component)this.createCarouselPanel(), statusGbc);
        ++statusGbc.gridx;
        statusPanel.add((Component)this.createAutochangerPanel(), statusGbc);
        ++statusGbc.gridx;
        statusPanel.add((Component)this.createLoaderPanel(), statusGbc);
        this.add((Component)statusPanel, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.subCommandsPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.loaderControlPanel, gbc);
        this.setDefaultValues();
    }

    private JPanel createCarouselPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Carousel"), 2), ""));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        contentPane.add((Component)new JLabel("Position: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Delta position: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Speed: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Average Current: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel((Component)this.standbyLabel, Tools.getPlaceHolder("carousel"), false), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Socket at STANDBY: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Filter at STANDBY: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("IO status: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Clamps status: "), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        contentPane.add((Component)this.actualPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.deltaPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.actualSpeedLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.actualCurrentLabel, gbc);
        ++gbc.gridy;
        this.standbySwitch.setColor(Color.gray);
        contentPane.add((Component)this.standbySwitch, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.socketAtStandbyLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.filterAtStandbyLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.ioModuleStatusLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.caClampsStateLabel, gbc);
        this.carouselPanel = new JPanel();
        this.carouselPanel.setLayout(new BoxLayout(this.carouselPanel, 0));
        this.carouselPanel.add(new VerticalTextComponent("Carousel"));
        this.carouselPanel.add(contentPane);
        JPanel fixedCarouselPanel = new JPanel();
        fixedCarouselPanel.setLayout(new CardLayout());
        fixedCarouselPanel.add(this.carouselPanel);
        fixedCarouselPanel.add(Tools.getPanelPlaceHolder("carousel_pane"));
        return fixedCarouselPanel;
    }

    private JPanel createLoaderPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), ""));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        contentPane.add((Component)new JLabel("Clamp homing: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Filter on loader: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Clamp state: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Clamp position: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Carrier state: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Carrier position: "), gbc);
        for (int i = 0; i < 2; ++i) {
            ++gbc.gridy;
            contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("loader")), gbc);
        }
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        contentPane.add((Component)this.loaderClampHomingLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.filterOnLoaderLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.loaderClampStateLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.loaderClampPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.loaderCarrierPositionNameLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.loaderCarrierPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("loader")), gbc);
        this.loaderPanel = new JPanel();
        this.loaderPanel.setLayout(new BoxLayout(this.loaderPanel, 0));
        this.loaderPanel.add((Component)new VerticalTextComponent("Loader"), "Before");
        this.loaderPanel.add((Component)contentPane, "Center");
        return this.loaderPanel;
    }

    private JPanel createAutochangerPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Autochanger"), 2), ""));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        contentPane.add((Component)new JLabel("Filter online: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Filter on trucks: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Online clamps state: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Latches state: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Trucks state: "), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Trucks position: "), gbc);
        for (int i = 0; i < 2; ++i) {
            ++gbc.gridy;
            contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("autochanger")), gbc);
        }
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        contentPane.add((Component)this.filterONLINELabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.filterOnTrucksLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.onlineClampsStateLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.latchesStateLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.trucksPositionNameLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.trucksPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("autochanger_status")), gbc);
        this.autochangerPanel = new JPanel();
        this.autochangerPanel.setLayout(new BoxLayout(this.autochangerPanel, 0));
        this.autochangerPanel.add(new VerticalTextComponent("Autochanger"));
        this.autochangerPanel.add(contentPane);
        JPanel fixedAutochangerPanel = new JPanel();
        fixedAutochangerPanel.setLayout(new CardLayout());
        fixedAutochangerPanel.add(this.autochangerPanel);
        fixedAutochangerPanel.add(Tools.getPanelPlaceHolder("autochanger_pane"));
        return fixedAutochangerPanel;
    }

    private void setDefaultValues() {
        this.actualPositionLabel.setText("0.0");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText(NONE);
        this.filterAtStandbyLabel.setText("NO FILTER");
        this.caClampsStateLabel.setText("UNKNOWN STATE");
        this.ioModuleStatusLabel.setText("UNKNOWN STATE");
        this.trucksPositionLabel.setText("0.0");
        this.trucksPositionNameLabel.setText("UNKNOWN STATE");
        this.onlineClampsStateLabel.setText("UNKNOWN STATE");
        this.latchesStateLabel.setText("UNKNOWN STATE");
        this.loaderClampHomingLabel.setText("UNKNOWN");
        this.filterOnLoaderLabel.setText("UNKNOWN");
        this.loaderClampStateLabel.setText("UNKNOWN");
        this.loaderClampPositionLabel.setText("0.0");
        this.loaderCarrierPositionNameLabel.setText("UNKNOWN");
        this.loaderCarrierPositionLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.cameraStatusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "FCS Overview";
    }

    private void setFilterButtonActionPerformed(ActionEvent evt) {
        this.filterID = Integer.parseInt(this.filterField.getText());
        this.subs.setFilter(this.filterID);
    }

    private void setFilterAtHandoffForLoaderButtonActionPerformed(ActionEvent evt) {
        this.filterID = Integer.parseInt(this.filterField.getText());
        this.subs.setFilterAtHandoffForLoader(this.filterID);
    }

    private void setNoFilterButtonActionPerformed(ActionEvent evt) {
        this.subs.setFilter(0);
    }

    private void setNoFilterAtHandoffForLoaderButtonActionPerformed(ActionEvent evt) {
        this.subs.setFilterAtHandoffForLoader(0);
    }

    private void loadFilterButtonActionPerformed(ActionEvent evt) {
        this.subs.loadFilter();
    }

    private void unloadFilterButtonActionPerformed(ActionEvent evt) {
        this.subs.unloadFilter();
    }

    private void connectLoaderButtonActionPerformed(ActionEvent evt) {
        this.subs.connectLoader();
        this.loadFilterButton.setEnabled(true);
        this.unloadFilterButton.setEnabled(true);
    }

    private void disconnectLoaderButtonActionPerformed(ActionEvent evt) {
        this.subs.disconnectLoader();
        this.loadFilterButton.setEnabled(false);
        this.unloadFilterButton.setEnabled(false);
    }

    private void storeFilterOnCarouselActionPerformed(ActionEvent evt) {
        this.subs.storeFilterOnCarousel();
    }

    private void rotateSocketToStandbyActionPerformed(ActionEvent evt) {
        int selectedSocketNb = this.socketMenu.getSelectedIndex();
        if (selectedSocketNb != 0) {
            this.socketID = selectedSocketNb;
            this.subs.rotateSocketToStandby(this.socketID);
            this.socketMenu.setSelectedIndex(0);
        }
    }

    private void grabFilterAtStandbyActionPerformed(ActionEvent evt) {
        this.subs.grabFilterAtStandby();
    }

    private void disengageFilterFromCarouselActionPerformed(ActionEvent evt) {
        this.subs.disengageFilterFromCarousel();
    }

    private void moveAndClampFilterOnlineActionPerformed(ActionEvent evt) {
        this.subs.moveAndClampFilterOnline();
    }

    public static void main(String[] args) {
        FcsGeneralViewPanel d = new FcsGeneralViewPanel();
        JFrame frame = new JFrame("FCS General View Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateCarousel
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            if (this.s.isAtStandby() && !this.s.isMoving()) {
                FcsGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                if (this.s.isEmptyAtStandby()) {
                    FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                } else {
                    FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName() + "/" + this.s.getFilterAtStandbyId());
                }
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
                FcsGeneralViewPanel.this.caClampsStateLabel.setText(this.s.getClampsStateAtStandby().toString());
                FcsGeneralViewPanel.this.caClampsStateLabel.setForeground(this.s.getClampsStateAtStandby().getColor());
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setText(this.s.getIOStatusAtStandby().toString());
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setForeground(this.s.getIOStatusAtStandby().getColor());
                FcsGeneralViewPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getDeltaPositionAtStandby()));
            } else {
                FcsGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                if (this.s.isMoving()) {
                    FcsGeneralViewPanel.this.socketAtStandbyLabel.setText("--");
                } else {
                    FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                }
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setText("--");
                FcsGeneralViewPanel.this.caClampsStateLabel.setText("--");
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setText("--");
            }
        }
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
                FcsGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getAverageCurrent()));
            }
        }
    }

    public class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.loaderCarrierPositionLabel.setText(Integer.toString(this.s.getPosition()));
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setForeground(Tools.greenColor);
            }
        }
    }

    public class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.loaderClampPositionLabel.setText(Integer.toString(this.s.getPosition()));
            }
        }
    }

    private class UpdateTrucks
    implements Runnable {
        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.trucksPositionLabel.setText(String.valueOf(this.s.getDriverPosition()));
            FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Tools.greenColor);
            if (this.s.isAtHandoff()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("HANDOFF");
            } else if (this.s.isAtOnline()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("ONLINE");
                FcsGeneralViewPanel.this.filterONLINELabel.setText(FcsGeneralViewPanel.this.filterOnTrucksLabel.getText());
            } else if (this.s.isAtStandby()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("STANDBY");
            } else {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("IN_TRAVEL");
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Color.YELLOW);
                FcsGeneralViewPanel.this.filterONLINELabel.setText(FcsGeneralViewPanel.NONE);
            }
        }
    }

    class UpdateLatches
    implements Runnable {
        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.latchesStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.latchesStateLabel.setForeground(this.s.getLockStatus().getColor());
            FcsGeneralViewPanel.this.filterOnTrucksLabel.setFont(Tools.BIG_FONT);
            if (this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED)) {
                FcsGeneralViewPanel.this.filterOnTrucksLabel.setText(this.s.getFilterName() + "/" + this.s.getFilterId());
            } else {
                FcsGeneralViewPanel.this.filterOnTrucksLabel.setText("No Filter");
            }
        }
    }

    class UpdateOnlineClamps
    implements Runnable {
        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateOnlineClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setForeground(this.s.getLockStatus().getColor());
        }
    }

    public class UpdateLoaderClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateLoaderClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setText("DONE");
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setForeground(Tools.greenColor);
            } else {
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setText("--");
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setForeground(Tools.greenColor);
            }
            FcsGeneralViewPanel.this.loaderClampStateLabel.setText(this.s.getClampState().name());
            FcsGeneralViewPanel.this.loaderClampStateLabel.setForeground(this.s.getClampState().getColor());
        }
    }

    public class UpdateLoaderCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateLoaderCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStorage()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("STORAGE");
            } else if (this.s.isAtHandoff()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("HANDOFF");
            } else if (this.s.isAtEngaged()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("ENGAGED");
            } else {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("IN_TRAVEL");
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setForeground(Color.YELLOW);
            }
        }
    }

    public class UpdateFromSensorList
    implements Runnable {
        private final KeyValueDataList kvdl;

        public UpdateFromSensorList(KeyValueDataList kvdl) {
            this.kvdl = kvdl;
        }

        @Override
        public void run() {
            Map<String, Serializable> sMap = this.kvdl.getListOfKeyValueData().stream().collect(Collectors.toMap(KeyValueData::getKey, KeyValueData::getValue));
            if (1 == (Integer)sMap.get("loaderFilterPresenceSensor0") && 1 == (Integer)sMap.get("loaderFilterPresenceSensor1")) {
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setText("YES");
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setForeground(Tools.greenColor);
            } else {
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setText(FcsGeneralViewPanel.NONE);
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setForeground(Color.gray);
            }
        }
    }
}

