/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class HYTTC580Panel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger FCSLOG = Logger.getLogger(HYTTC580Panel.class.getName());
    private final String deviceName;
    private final String publishedDataKey;
    private final CanOpenDevicePanel generalInfoPanel;
    private final JLabel pdo1Label = new JLabel();
    private final JLabel pdo1HexLabel = new JLabel();
    private final JLabel pdo1BinLabel = new JLabel();
    private final JLabel pdo2Label = new JLabel();
    private final JLabel pdo2HexLabel = new JLabel();
    private final JLabel pdo2BinLabel = new JLabel();
    private final JLabel pdo4Label = new JLabel();
    private final JLabel pdo4HexLabel = new JLabel();
    private final JLabel pdo4BinLabel = new JLabel();

    public HYTTC580Panel(String hyttc580Name) {
        this.deviceName = hyttc580Name;
        this.generalInfoPanel = new CanOpenDevicePanel(hyttc580Name);
        int ind = this.deviceName.lastIndexOf("/");
        this.publishedDataKey = ind >= 0 ? this.deviceName.substring(ind + 1) : this.deviceName;
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateDevice(String name, StatusDataPublishedByHYTTC580 status) {
        if (this.publishedDataKey.equals(name)) {
            SwingUtilities.invokeLater(new UpdateDevice(status));
        }
    }

    private void initComponents() {
        this.setDefaultValues();
        JPanel pdoPanel = new JPanel();
        pdoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), "PDO"));
        pdoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        pdoPanel.add((Component)new JLabel("pdo1:"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo1 (hexa):"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo1 (binaire):"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo2:"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo2 (hexa):"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo2 (binaire):"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo4:"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo4 (hexa):"), gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)new JLabel("pdo4 (binaire):"), gbc3);
        gbc3.anchor = 22;
        ++gbc3.gridx;
        gbc3.gridy = 0;
        pdoPanel.add((Component)this.pdo1Label, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo1HexLabel, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo1BinLabel, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo2Label, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo2HexLabel, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo2BinLabel, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo4Label, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo4HexLabel, gbc3);
        ++gbc3.gridy;
        pdoPanel.add((Component)this.pdo4BinLabel, gbc3);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridy;
        this.add((Component)pdoPanel, gbc);
    }

    private void setDefaultValues() {
        this.pdo1Label.setText("0");
        this.pdo1HexLabel.setText("0x0");
        this.pdo1BinLabel.setText("0");
        this.pdo2Label.setText("0");
        this.pdo2HexLabel.setText("0x0");
        this.pdo2BinLabel.setText("0");
        this.pdo4Label.setText("0");
        this.pdo4HexLabel.setText("0x0");
        this.pdo4BinLabel.setText("0");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.generalInfoPanel.resetPanel();
    }

    @Override
    public String toString() {
        int ind = this.deviceName.lastIndexOf("/");
        return ind >= 0 ? this.deviceName.substring(ind + 1) : this.deviceName;
    }

    public static void main(String[] argv) {
        HYTTC580Panel p = new HYTTC580Panel("hyttc580");
        JFrame frame = new JFrame("HYTTC580");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            HYTTC580Panel.this.generalInfoPanel.initializeGui(this.configInfo);
        }
    }

    private class UpdateDevice
    implements Runnable {
        private StatusDataPublishedByHYTTC580 s;

        public UpdateDevice(StatusDataPublishedByHYTTC580 status) {
            this.s = status;
        }

        @Override
        public void run() {
            FCSLOG.fine(() -> "Updating HYTTC580Panel from StatusDataPublishedByHYTTC580 for deviceName = " + HYTTC580Panel.this.deviceName);
            HYTTC580Panel.this.generalInfoPanel.updateCanOpenDevice(HYTTC580Panel.this.publishedDataKey, this.s);
            HYTTC580Panel.this.pdo1Label.setText(Long.toString(this.s.getPdo1()));
            HYTTC580Panel.this.pdo1HexLabel.setText("0x" + Long.toHexString(this.s.getPdo1()));
            HYTTC580Panel.this.pdo1BinLabel.setText(Long.toBinaryString(this.s.getPdo1()));
            HYTTC580Panel.this.pdo2Label.setText(Long.toString(this.s.getPdo2()));
            HYTTC580Panel.this.pdo2HexLabel.setText("0x" + Long.toHexString(this.s.getPdo2()));
            HYTTC580Panel.this.pdo2BinLabel.setText(Long.toBinaryString(this.s.getPdo2()));
            HYTTC580Panel.this.pdo4Label.setText(Long.toString(this.s.getPdo4()));
            HYTTC580Panel.this.pdo4HexLabel.setText("0x" + Long.toHexString(this.s.getPdo4()));
            HYTTC580Panel.this.pdo4BinLabel.setText(Long.toBinaryString(this.s.getPdo4()));
        }
    }
}

