
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class FilterPresenceSensorPanel extends AnalogicSensorPanel {

    private static final long serialVersionUID = 1L;

    private JLabel offset2Label;
    private JLabel minNoFilterLabel;

    public FilterPresenceSensorPanel(String clampName, String sensorName, int orientation) {
        super(clampName, sensorName, orientation);
    }

    /**
     * Initialize the GUI with the configuration data.
     *
     * @param configInfo
     */
    @Override
    public void initializeGui(ConfigurationInfo configInfo) {
        Map<String, String> config = configInfo.getCurrentValuesFor(clampName);
        String[] words = sensorName.split("X");
        minLimitLabel.setText("0");
        offset2Label.setText("0");
        maxLimitLabel.setText(config.get(words[0] + "MaxValue"));
        Map<String, String> configCa = configInfo.getCurrentValuesFor("carousel");
        minNoFilterLabel.setText(configCa.get("filterPresenceMinNoFilter"));
    }

    @Override
    protected void updateOffset1(int value) {
        minLimitLabel.setText(Integer.toString(value));
    }

    protected void updateOffset2(int value) {
        offset2Label.setText(Integer.toString(value));
    }

    @Override
    protected void initParamsPanel() {
        offset2Label = new JLabel();
        minNoFilterLabel = new JLabel();
        /**
         ******************************************************************************
         ** FilterPresence Sensor Parameters Panels
         * *****************************************************************************
         */
        paramsPanel = new JPanel();
        paramsPanel.setBorder(Tools.getConfigurationTitle());
        paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        /*first column*/
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramsPanel.add(new JLabel("minLimit:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("offset2:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("minNoFilter:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("maxLimit:"), gbcp);

        /*second column*/
        gbcp.gridx++;
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramsPanel.add(minLimitLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(offset2Label, gbcp);
        gbcp.gridy++;
        paramsPanel.add(minNoFilterLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(maxLimitLabel, gbcp);
        /**
         ******************************************************************************
         ** end of General Parameters Panels
         * *****************************************************************************
         */
    }

    /**
     * Just to test the Panel.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        AnalogicSensorPanel d = new FilterPresenceSensorPanel("clampToto", "leBoCapteur", 1);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
