/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class StatusStateChangeNotification
extends StatusMessage<StateBundle, Object> {
    private static final long serialVersionUID = 7295728245721L;
    private final CCSTimeStamp stateTransitionTimestamp;
    private final String cause;

    public StatusStateChangeNotification(CCSTimeStamp stateTransitionTimestamp, StateBundle oldState, String cause) {
        this(stateTransitionTimestamp, oldState, cause, false);
    }

    public StatusStateChangeNotification(CCSTimeStamp stateTransitionTimestamp, StateBundle oldState, String cause, boolean skipSerialization) {
        super(oldState, skipSerialization);
        this.stateTransitionTimestamp = stateTransitionTimestamp;
        this.cause = cause;
    }

    public StateBundle getNewState() {
        return this.getState();
    }

    public StateBundle getOldState() {
        return (StateBundle)this.getObject();
    }

    @Override
    protected Object encodeObject(StateBundle obj) {
        return null;
    }

    public CCSTimeStamp getStateTransitionTimestamp() {
        return this.stateTransitionTimestamp != null ? this.stateTransitionTimestamp : this.getCCSTimeStamp();
    }

    public String getCause() {
        return this.cause;
    }
}

