
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.UNKNOWN;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.ColoredObject;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A Panel to represent an analogic sensor like those are used for Carousel clamps.
 * @author virieux
 */
public class AnalogicSensorPanel extends JPanel {
    private static final long serialVersionUID = -1531790094506697510L;

    String clampName = "clampName";
    String sensorName = "sensorName";
    private final int orientation;
    private JLabel nameLabel;
    private JLabel stateLabel;
    private JLabel valueLabel;
    private JProgressBar progressBar;
    private DigitalSwitch sensorSwitch;
    protected JPanel paramsPanel;

    final JLabel offset1Label = new JLabel(ZERO_VALUE);
    final JLabel minLockedLabel = new JLabel(ZERO_VALUE);
    final JLabel minLimitLabel = new JLabel(ZERO_VALUE);
    final JLabel maxLimitLabel = new JLabel(ZERO_VALUE);

    public AnalogicSensorPanel(String clampName, String sensorName, int orientation) {
        this.clampName = clampName;
        this.sensorName = sensorName;
        this.orientation = orientation;
        initComponents();
    }

    /**
     * Initialize the GUI with the configuration data.
     *
     * @param configInfo
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        Map<String, String> config = configInfo.getCurrentValuesFor("carousel");
        if (sensorName.contains("Xminus")) {
            minLimitLabel.setText(config.get("lockSensorMinLimitXminus"));
            maxLimitLabel.setText(config.get("lockSensorMaxLimitXminus"));
        } else {
            minLimitLabel.setText(config.get("lockSensorMinLimitXplus"));
            maxLimitLabel.setText(config.get("lockSensorMaxLimitXplus"));
        }
    }

    protected void updateOffset1(int value) {
        offset1Label.setText(Integer.toString(value));
    }

    protected void updateMinLocked(long value) {
        minLockedLabel.setText(Long.toString(value));
    }

    /**
     * Update this panel from a value and a sensorStatus.
     * @param value
     * @param sensorStatus
     */
    protected void update(int value, ColoredObject sensorStatus) {
        progressBar.setValue(value);
        valueLabel.setText(Integer.toString(value));
        Color lockSensorColor = sensorStatus.getColor();
        //progressBar.setValueAndColor(value, lockSensorColor);
        sensorSwitch.setColor(lockSensorColor);
        stateLabel.setText(sensorStatus.toString());
        stateLabel.setForeground(lockSensorColor);
    }


    protected void initParamsPanel() {
        /**
         ******************************************************************************
         ** Lock Sensor Parameters Panels
         * *****************************************************************************
         */
        paramsPanel = new JPanel();
        paramsPanel.setBorder(Tools.getConfigurationTitle());
        paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        /*first columm*/
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramsPanel.add(new JLabel("minLimit:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("offset1:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("minLocked:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("maxLimit:"), gbcp);

        /*second columm*/
        gbcp.gridx++;
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramsPanel.add(minLimitLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(offset1Label, gbcp);
        gbcp.gridy++;
        paramsPanel.add(minLockedLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(maxLimitLabel, gbcp);
        /**
         ******************************************************************************
         ** end of General Parameters Panels
         * *****************************************************************************
         */
    }

    // <editor-fold defaultstate="collapsed" desc="Form description">
    private void initComponents() {
        progressBar = new JProgressBar(orientation);
        sensorSwitch = new DigitalSwitch();
        sensorSwitch.setColor(Color.gray);
        stateLabel = new JLabel(UNKNOWN);
        nameLabel = new JLabel(sensorName);
        valueLabel = new JLabel(ZERO_VALUE);

        initParamsPanel();

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx=0;
        gbc.gridy=0;
        add(valueLabel, gbc);
        gbc.gridy++;
        add(progressBar,gbc);
        gbc.gridy++;
        add(sensorSwitch,gbc);
        gbc.gridy++;
        add(stateLabel,gbc);
        gbc.gridy++;
        add(nameLabel,gbc);
        gbc.gridy++;
        add(paramsPanel,gbc);
        /**
         ******************************************************************************
         ** end Whole Panel
         * *****************************************************************************
         */
    }

    /**
     * Reset panel to default values when subsystem is shutdown for example.
     */
    public void resetPanel() {
        progressBar.setValue(0);
        valueLabel.setText(ZERO_VALUE);
        sensorSwitch.setColor(Color.gray);
        stateLabel.setText(UNKNOWN_STATE);
        stateLabel.setForeground(Color.gray);
        minLockedLabel.setText(ZERO_VALUE);
        maxLimitLabel.setText(ZERO_VALUE);
        minLimitLabel.setText(ZERO_VALUE);
        offset1Label.setText(ZERO_VALUE);
    }

    /**
     * Just to test the Panel.
     * @param argv
     */
    public static void main(String[] argv) {

        AnalogicSensorPanel d = new AnalogicSensorPanel("clampToto", "leBoCapteur", 0);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
