
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import static org.lsst.ccs.subsystems.fcs.loader.ui.PLCLoaderPanel.DOCKED;
import static org.lsst.ccs.subsystems.fcs.loader.ui.PLCLoaderPanel.DOCKEDB;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

/**
 * A panel to display loader status LPS and LRH, and on Camera sensor
 *
 * @author virieux
 */
public class LoaderStatusPanel extends JPanel {

    private static final long serialVersionUID = 1L;

    private static final String title = "loader status";
    public static final String LPS = "LPS_0";
    public static final String LPSB = "LPS_1";
    public static final String LRH = "LRH_0";
    public static final String LRHB = "LRH_1";
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch(DOCKED, DOCKEDB);
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch(LPS, LPSB);
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch(LRH, LRHB);

    public LoaderStatusPanel() {
        initComponents();
    }


    /**
     * A Runnable to initialize this Panel from status data published on the
     * STATUS bus by the loader
     */
    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            /* Loader_LPS and Loader_LRH are complementary sensors*/
            /*Loader_LPS (=1 if loader is at Storage, loader connected) */
            loader_LPS_Switch.updateColorComplementary(sensorMap);

            /*Loader_LRH (=1 if loader is holding filter at HANDOFF) */
            loader_LRH_Switch.updateColorComplementary(sensorMap);

            /* loaderOnCameraSensors are redondant sensors */
            /* loader presence status */
            loaderPresenceSwitch.updateColorRedondantSensor(sensorMap);
        }
    }

    void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        JPanel statusPane = new JPanel();
        statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), "PlutoGateway"));
        statusPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        statusPane.add(new JLabel("Docked"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("LPS (at storage)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("LRH (holds filter)"), gbc);
        gbc.gridy++;
        statusPane.add(new FixedSizePanel(Tools.getPlaceHolder("loader")), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.anchor = GridBagConstraints.EAST;
        statusPane.add(this.loaderPresenceSwitch, gbc);
        gbc.gridy++;
        statusPane.add(loader_LPS_Switch, gbc);
        gbc.gridy++;
        statusPane.add(loader_LRH_Switch, gbc);
        for (int i = 0; i < 3; i++) {
            gbc.gridy++;
            statusPane.add(new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        }

        JPanel loaderStatusPane = new JPanel();
        loaderStatusPane.setLayout(new BoxLayout(loaderStatusPane, BoxLayout.X_AXIS));
        loaderStatusPane.add(new VerticalTextComponent("Loader"));
        loaderStatusPane.add(statusPane);

        setLayout(new CardLayout());
        add(loaderStatusPane);
        add(Tools.getPanelPlaceHolder("loader_pane"));
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    public void setDefaultValues() {
        loader_LPS_Switch.setColor(Color.GRAY);
        loader_LRH_Switch.setColor(Color.GRAY);
        loaderPresenceSwitch.setColor(Color.GRAY);
    }

    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    /**
     * This main launches an GUI for the whole subsystem "fcs". It's used only
     * for tests.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        LoaderStatusPanel d = new LoaderStatusPanel();
        JFrame frame = new JFrame("LoaderStatus Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
