package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_NAME;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI.carouselName;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI.timeoutForRotation;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

import java.util.logging.Logger;


/**
 *
 * @author virieux
 */
public interface InterfaceFcsGUI extends InterfaceGeneralGUI {
    static final Logger FCSLOG = Logger.getLogger(InterfaceFcsGUI.class.getName());
    static long CONNECT_LOADER_TIMEOUT = 6000;

    static long SET_FILTER_TIMEOUT = 120000;

    static long STORE_FILTER_TIMEOUT = 60000;

    static long LOAD_FILTER_TIMEOUT = 240000;

    static long GRAB_FILTER_TIMEOUT = 25000;

    static long DISENGAGE_FILTER_TIMEOUT = 15000;

    static long TRUCKS_MOTION_TIMEOUT = 50000;


    default void setFilter(int filterID) {
        FCSLOG.fine(() -> "GUI: Setting filter with a timeout of " + SET_FILTER_TIMEOUT);
        sendCommand("setFilter " + filterID, SET_FILTER_TIMEOUT);
    }

    default void setFilterByName(String filterName) {
        FCSLOG.fine(() -> "GUI: Setting filter with a timeout of " + SET_FILTER_TIMEOUT);
        sendCommand("setFilter " + filterName, SET_FILTER_TIMEOUT);
    }

    default void setFilterAtHandoffForLoader(int filterID) {
        FCSLOG.fine(() -> "GUI: Setting filter at Handoff for Loader with a timeout of " + SET_FILTER_TIMEOUT);
        sendCommand("setFilterAtHandoffForLoader " + filterID, SET_FILTER_TIMEOUT);
    }

    default void setFilterAtHandoffForLoaderByName(String filterName) {
        FCSLOG.fine(() -> "GUI: Setting filter at Handoff for Loader with a timeout of " + SET_FILTER_TIMEOUT);
        sendCommand("setFilterAtHandoffForLoader " + filterName, SET_FILTER_TIMEOUT);
    }

    default void storeFilterOnCarousel() {
        FCSLOG.fine(() -> "GUI: Storing filter on Carousel with a timeout of " + STORE_FILTER_TIMEOUT);
        sendCommand("storeFilterOnCarousel", STORE_FILTER_TIMEOUT);
    }

    default void loadFilter() {
        FCSLOG.fine(() -> "GUI: Loading filter in Camera with a timeout of " + LOAD_FILTER_TIMEOUT);
        sendCommand("loadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void unloadFilter() {
        FCSLOG.fine(() -> "GUI: Unloading filter from the Camera with a timeout of " + LOAD_FILTER_TIMEOUT);
        sendCommand("unloadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void connectLoader() {
        FCSLOG.fine(() -> "GUI: Connecting loader CANbus with a timeout of " + CONNECT_LOADER_TIMEOUT);
        sendCommand("connectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

    default void disconnectLoader() {
        FCSLOG.fine(() -> "GUI: Disconnecting loader CANbus with a timeout of " + CONNECT_LOADER_TIMEOUT);
        sendCommand("disconnectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

    default void rotateSocketToStandby(int socketID) {
        FCSLOG.fine(() -> "GUI: Carousel rotating with a timeout of " + timeoutForRotation);
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        sendCommand("rotateSocketToStandby socket" + socketID, timeoutForRotation, carouselName);
    }

    default void grabFilterAtStandby() {
        FCSLOG.fine(() -> "GUI: Grab filter at Standby with a timeout of " + GRAB_FILTER_TIMEOUT);
        sendCommand("grabFilterAtStandby", GRAB_FILTER_TIMEOUT, AC_NAME);
    }

    default void disengageFilterFromCarousel() {
        FCSLOG.fine(() -> "GUI: Disengage filter from Carousel with a timeout of " + DISENGAGE_FILTER_TIMEOUT);
        sendCommand("disengageFilterFromCarousel", DISENGAGE_FILTER_TIMEOUT);
    }

    default void moveAndClampFilterOnline() {
        FCSLOG.fine(() -> "GUI: executing Move and clamp filter online with a timeout of " + TRUCKS_MOTION_TIMEOUT);
        sendCommand("moveAndClampFilterOnline", TRUCKS_MOTION_TIMEOUT, AC_NAME);
    }

}
