package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 *
 * @author virieux
 */
public class VerticalLine extends JComponent {

    private int length = 60;

    int startingX = 10;
    int startingY = 0;

    /**
     * Creates new VerticalLine
     */
    public VerticalLine() {
        super.setPreferredSize(new Dimension(2 * startingX, length));
    }

    public VerticalLine(int length) {
        this.length = length;
        super.setPreferredSize(new Dimension(2 * startingX, length));
    }

    /**
     * create a VerticalLine with a height at a starting Y point.
     *
     * @param height
     * @param startingY
     */
    public VerticalLine(int height, int startingY) {
        this.length = height;
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(2 * startingX, height));
    }

    /**
     * Change the length of the SimpleLine
     * @param size
     */
    public void setLength(int size) {
        this.length = size;
        super.setPreferredSize(new Dimension(2 * startingX, length));
        repaint();
    }

    public void setStartingY(int startingY) {
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(2 * startingX, length));
        repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g.create();
        Path2D linePath = new Path2D.Double();
        linePath.moveTo(startingX, startingY);
        linePath.lineTo(startingX, length);
        g2d.setColor(Color.BLACK);
        g2d.draw(linePath);
        g2d.dispose();
    }

    /**
     * for tests
     *
     * @param argv
     */
    public static void main(String[] argv) {

        VerticalLine d = new VerticalLine();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
