
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.math.BigDecimal;
import javax.swing.JComponent;

/**
 *
 * @author turri
 */
public final class Switch extends JComponent {
    private static final long serialVersionUID = -2501461067648883102L;

    private String name;

    public Switch() {
        this("");
    }

    public Switch(String name) {
        this.name = name;
        setSize(new Dimension(30, 30));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        float width = 30;
        float height = 30;
        float actualWidth = Math.min(width, height);

        double border = 1;

        // Draw the outline
        Shape circle = new Arc2D.Double(border, border, actualWidth - 2 * border,
                actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(Color.red);
        g2.fill(circle);
        g2.setColor(Color.black);
        g2.draw(circle);
        BigDecimal treeQuarterOfActualWidth =
                BigDecimal.valueOf(actualWidth).multiply(BigDecimal.valueOf((double)3 / (double)4));
        BigDecimal demiActualWidth =
                BigDecimal.valueOf(actualWidth).divide(BigDecimal.valueOf(2));
        //g2.drawString(name, actualWidth * 3 / 4, actualWidth / 2);
        g2.drawString(name, treeQuarterOfActualWidth.floatValue(), demiActualWidth.floatValue());
    }
}
