/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.subsystems.fcs.ui.ControllersViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

public class BottomPanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = -447188631236670592L;
    public GatherPanel gatherPanel;
    protected final String title;
    protected JTree tree;
    protected JPanel rightPanel;
    protected final JSplitPane splitPane = new JSplitPane(1);
    protected JPanel helpPanel;

    public BottomPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public BottomPanel(GatherPanel gatherPanel, String title) {
        this.gatherPanel = gatherPanel;
        this.title = title;
        this.initComponents();
    }

    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
        this.gatherPanel.setHardwareNames(hardwareList);
    }

    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithLoaderConfigInfo(configInfo, hardwareList);
        this.gatherPanel.setHardwareNames(hardwareList);
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        this.gatherPanel.initializeGUIWithControllersMap(controllersMap);
    }

    void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        this.gatherPanel.initializeGuiWithAutochangerSensorsList(configInfo, sensorsList);
    }

    void initializeGuiWithLoaderSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        this.gatherPanel.initializeGuiWithLoaderSensorsList(configInfo, sensorsList);
    }

    void resetPanel() {
        this.gatherPanel.resetPanel();
    }

    public void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getCanOpenHardwareListPanel()));
        top.add(devicesNode);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), this.title));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.title);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.rightPanel = new JPanel();
        this.rightPanel.setBackground(new Color(238, 238, 238));
        this.add((Component)this.tree, "West");
        this.add((Component)this.rightPanel, "Center");
        this.helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        this.helpPanel.add(helpLabel);
    }

    public void onStatusMessage(StatusMessage msg) {
        this.gatherPanel.onStatusMessage(msg);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo == null) {
            return;
        }
        if (nodeInfo instanceof ControllersViewPanel) {
            this.gatherPanel.getSubs().sendCommandQuietly("checkFaultForAllControllers", 1000L);
        }
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            this.displayPanel(panel);
        }
    }

    protected void displayPanel(JPanel panel) {
        if (panel != null) {
            this.rightPanel.removeAll();
            this.rightPanel.add((Component)panel, "Center");
        } else {
            this.rightPanel.removeAll();
            this.rightPanel.add((Component)this.helpPanel, "Center");
        }
        this.revalidate();
        this.repaint();
    }
}

