package org.lsst.ccs.subsystems.fcs.ui.commons;

import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;

/**
 * Panel with a card layout. Used only for alignment issues.
 * - one card is visible : can be empty of with a component (for correct height dimension)
 * - the second or third card contains the element representing the space that should be "reserved" (it will never be seen)
 */
public class FixedSizePanel extends JPanel {

    public FixedSizePanel(Component invisibleComp) {
        this.setLayout(new CardLayout());
        this.add(new JLabel(""));
        this.add(invisibleComp);
    }
    public FixedSizePanel(Component comp, Component invisibleComp, boolean isHidden) {
        this.setLayout(new CardLayout());
        if (isHidden) {
            this.add(new JLabel(""));
        }
        this.add(comp);
        this.add(invisibleComp);
    }

    public FixedSizePanel(Component visibleComp, Component invisibleComp1 , Component invisibleComp2) {
        this.setLayout(new CardLayout());
        JPanel rightAlignedPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        rightAlignedPanel.add(visibleComp);
        this.add(rightAlignedPanel);
        this.add(invisibleComp1);
        this.add(invisibleComp2);
    }
}
