/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ccs;

import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;

public class CCSLog
implements Log {
    private final Log log;
    private final Protocol protocol;
    private volatile String bus;

    public CCSLog(Protocol protocol) {
        this.protocol = protocol;
        this.log = LogFactory.getLog(protocol.getClass());
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void fatal(String msg) {
        this.log.fatal("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.fatal("[%s] " + format, aa);
        }
    }

    @Override
    public void fatal(String msg, Throwable throwable) {
        this.log.fatal("[" + this.getBusName() + "] " + msg, throwable);
    }

    @Override
    public void error(String msg) {
        this.log.error("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.error("[%s] " + format, aa);
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.log.error("[" + this.getBusName() + "] " + msg, throwable);
    }

    @Override
    public void warn(String msg) {
        this.log.warn("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.warn("[%s] " + format, aa);
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.log.warn("[" + this.getBusName() + "] " + msg, throwable);
    }

    @Override
    public void info(String msg) {
        this.log.info("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.info("[%s] " + format, aa);
        }
    }

    @Override
    public void debug(String msg) {
        this.log.debug("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.debug("[%s] " + format, aa);
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.log.debug("[" + this.getBusName() + "] " + msg, throwable);
    }

    @Override
    public void trace(Object obj) {
        this.trace(obj == null ? "null" : obj.toString());
    }

    @Override
    public void trace(String msg) {
        this.log.trace("[" + this.getBusName() + "] " + msg);
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            Object[] aa = new Object[args.length + 1];
            System.arraycopy(args, 0, aa, 1, args.length);
            aa[0] = this.getBusName();
            this.log.trace("[%s] " + format, aa);
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        this.log.trace("[" + this.getBusName() + "] " + msg, throwable);
    }

    @Override
    public void setLevel(String level) {
        this.log.setLevel(level);
    }

    @Override
    public String getLevel() {
        return this.log.getLevel();
    }

    private String getBusName() {
        if (this.bus == null) {
            try {
                String s = this.protocol.getProtocolStack().getChannel().clusterName();
                if (s != null) {
                    this.bus = s;
                }
            }
            catch (RuntimeException s) {
                // empty catch block
            }
            if (this.bus == null) {
                String channelName = null;
                try {
                    channelName = this.protocol.getProtocolStack().getChannel().getName();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (channelName == null) {
                    try {
                        channelName = NameCache.get(this.protocol.getAddress());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                try {
                    if (channelName.charAt(1) == '-') {
                        switch (channelName.charAt(0)) {
                            case 's': {
                                this.bus = "STATUS";
                                break;
                            }
                            case 'c': {
                                this.bus = "COMMAND";
                                break;
                            }
                            case 'l': {
                                this.bus = "LOG";
                            }
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (this.bus == null) {
                return "CCS";
            }
        }
        return this.bus;
    }
}

