/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovyjarjarasm.asm.Type;
import groovyjarjarasm.asm.signature.SignatureReader;
import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.decompiled.AnnotationStub;
import org.codehaus.groovy.ast.decompiled.Annotations;
import org.codehaus.groovy.ast.decompiled.AsmDecompiler;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.DecompiledClassNode;
import org.codehaus.groovy.ast.decompiled.FieldStub;
import org.codehaus.groovy.ast.decompiled.FormalParameterParser;
import org.codehaus.groovy.ast.decompiled.MethodStub;
import org.codehaus.groovy.ast.decompiled.TypeSignatureParser;
import org.codehaus.groovy.ast.decompiled.TypeWrapper;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;

class MemberSignatureParser {
    MemberSignatureParser() {
    }

    static MethodNode createMethodNode(final AsmReferenceResolver resolver, MethodStub method) {
        MethodNode result;
        GenericsType[] typeParameters = null;
        Type[] argumentTypes = Type.getArgumentTypes(method.desc);
        final ClassNode[] parameterTypes = new ClassNode[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            parameterTypes[i] = resolver.resolveType(argumentTypes[i]);
        }
        final ClassNode[] exceptions = new ClassNode[method.exceptions.length];
        for (int i = 0; i < method.exceptions.length; ++i) {
            exceptions[i] = resolver.resolveClass(AsmDecompiler.fromInternalName(method.exceptions[i]));
        }
        final ClassNode[] returnType = new ClassNode[]{resolver.resolveType(Type.getReturnType(method.desc))};
        if (method.signature != null) {
            FormalParameterParser v = new FormalParameterParser(resolver){
                int paramIndex;
                int exceptionIndex;
                {
                    super(resolver2);
                    this.paramIndex = 0;
                    this.exceptionIndex = 0;
                }

                @Override
                public SignatureVisitor visitParameterType() {
                    return new TypeSignatureParser(resolver){

                        @Override
                        void finished(ClassNode result) {
                            parameterTypes[paramIndex] = MemberSignatureParser.applyErasure(result, parameterTypes[paramIndex]);
                            ++paramIndex;
                        }
                    };
                }

                @Override
                public SignatureVisitor visitReturnType() {
                    return new TypeSignatureParser(resolver){

                        @Override
                        void finished(ClassNode result) {
                            returnType[0] = MemberSignatureParser.applyErasure(result, returnType[0]);
                        }
                    };
                }

                @Override
                public SignatureVisitor visitExceptionType() {
                    return new TypeSignatureParser(resolver){

                        @Override
                        void finished(ClassNode result) {
                            exceptions[exceptionIndex] = MemberSignatureParser.applyErasure(result, exceptions[exceptionIndex]);
                            ++exceptionIndex;
                        }
                    };
                }
            };
            new SignatureReader(method.signature).accept(v);
            typeParameters = v.getTypeParameters();
        } else {
            returnType[0] = GenericsUtils.nonGeneric(returnType[0]);
            int n = parameterTypes.length;
            for (int i = 0; i < n; ++i) {
                parameterTypes[i] = GenericsUtils.nonGeneric(parameterTypes[i]);
            }
        }
        Parameter[] parameters = new Parameter[parameterTypes.length];
        List<String> parameterNames = method.parameterNames;
        for (int i = 0; i < parameterTypes.length; ++i) {
            String decompiledName;
            String parameterName = "param" + i;
            if (parameterNames != null && i < parameterNames.size() && (decompiledName = parameterNames.get(i)) != null) {
                parameterName = decompiledName;
            }
            parameters[i] = new Parameter(parameterTypes[i], parameterName);
        }
        if (method.parameterAnnotations != null) {
            for (Map.Entry<Integer, List<AnnotationStub>> entry : method.parameterAnnotations.entrySet()) {
                for (AnnotationStub stub : entry.getValue()) {
                    AnnotationNode annotationNode = Annotations.createAnnotationNode(stub, resolver);
                    if (annotationNode == null) continue;
                    parameters[entry.getKey()].addAnnotation(annotationNode);
                }
            }
        }
        if ("<init>".equals(method.methodName)) {
            result = new ConstructorNode(method.accessModifiers, parameters, exceptions, null);
        } else {
            result = new MethodNode(method.methodName, method.accessModifiers, returnType[0], parameters, exceptions, null);
            Object annDefault = method.annotationDefault;
            if (annDefault != null) {
                if (annDefault instanceof TypeWrapper) {
                    annDefault = resolver.resolveType(Type.getType(((TypeWrapper)annDefault).desc));
                }
                result.setCode(new ReturnStatement(new ConstantExpression(annDefault)));
                result.setAnnotationDefault(true);
            } else {
                result.setCode(new ReturnStatement(GeneralUtils.nullX()));
            }
        }
        if (typeParameters != null && typeParameters.length > 0) {
            result.setGenericsTypes(typeParameters);
        }
        return result;
    }

    private static ClassNode applyErasure(ClassNode genericType, ClassNode erasure) {
        if (genericType.isArray() && erasure.isArray() && genericType.getComponentType().isGenericsPlaceHolder()) {
            genericType.setRedirect(erasure);
            genericType.getComponentType().setRedirect(erasure.getComponentType());
        } else if (genericType.isGenericsPlaceHolder()) {
            genericType.setRedirect(erasure);
        }
        return genericType;
    }

    static FieldNode createFieldNode(FieldStub field, AsmReferenceResolver resolver, DecompiledClassNode owner) {
        final ClassNode[] type = new ClassNode[]{resolver.resolveType(Type.getType(field.desc))};
        if (field.signature != null) {
            new SignatureReader(field.signature).accept(new TypeSignatureParser(resolver){

                @Override
                void finished(ClassNode result) {
                    type[0] = MemberSignatureParser.applyErasure(result, type[0]);
                }
            });
        } else {
            type[0] = GenericsUtils.nonGeneric(type[0]);
        }
        ConstantExpression value = field.value == null ? null : new ConstantExpression(field.value);
        return new FieldNode(field.fieldName, field.accessModifiers, type[0], owner, value);
    }
}

