/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceCarouselGUI
extends InterfaceGeneralGUI {
    public static final Logger FCSLOG = Logger.getLogger(InterfaceCarouselGUI.class.getName());
    public static final long timeoutForOpeningClamps = 10000L;
    public static final long timeoutForRotation = 100000L;
    public static final long timeoutForCheckingFilterLocation = 2000L;
    public static final long timeoutForCANbus = 500L;
    public static final String carouselName = "carousel";

    default public void checkFiltersLocation() {
        this.sendCommand("checkFiltersLocation", 2000L);
    }

    default public void rotate(int socketID) {
        FCSLOG.info("Carousel rotating");
        FCSLOG.info("/timeout=100000");
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        this.sendCommand("rotateSocketToStandby socket" + socketID, 100000L, carouselName);
    }

    default public void updatePosition() {
        FCSLOG.info("Carousel updating position");
        FCSLOG.info("/timeout=1000");
        this.sendCommand("updatePosition", 1000L, carouselName);
    }

    default public void setSlowMode() {
        FCSLOG.info("Carousel entering slow mode");
        this.sendCommand("setSlowMode", 1000L, carouselName);
    }

    default public void setFastMode() {
        FCSLOG.info("Carousel entering fast mode");
        this.sendCommand("setFastMode", 1000L, carouselName);
    }

    default public void homing() {
        FCSLOG.info("Carousel setPositionSensorTypeEncoderSSI");
        this.sendCommand("setControllerPositionSensorTypeEncoderSSI", 500L, carouselName);
    }

    default public void unlockClamps() {
        FCSLOG.info("Carousel unlocking clamps");
        FCSLOG.info("/timeout=10000");
        this.sendCommand("unlockClamps", 10000L);
    }
}

