/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.jms.TopicContextFactory;
import org.lsst.ccs.utilities.logging.Logger;

public class JMSBusMessagingLayer
implements BusMessagingLayer {
    private static Logger logger = Logger.getLogger((String)"org.lsst.ccs.bus.jms.JMSBusMessagingLayer");
    private Map<String, LocalAgent> mapLocalAgent = new ConcurrentHashMap<String, LocalAgent>();

    @Override
    public void connect(MessagingAccessLayer layer) throws DuplicateAgentNameException {
        String agentName = layer.getName();
        ArrayList<MessagingAccessLayer.BusAccess> busAccesses = new ArrayList<MessagingAccessLayer.BusAccess>(layer.getBusAccesses());
        StringBuilder allBuses = new StringBuilder();
        for (MessagingAccessLayer.BusAccess busAccess : busAccesses) {
            allBuses.append(busAccess.getBus().toString()).append(" ");
        }
        logger.fine((Object)("### Registering " + agentName + " for buses " + allBuses));
        LocalAgent localAgent = this.mapLocalAgent.get(agentName);
        if (localAgent == null) {
            localAgent = new LocalAgent();
            localAgent.agentName = agentName;
            this.mapLocalAgent.put(agentName, localAgent);
            logger.debug((Object)"context created");
            try {
                localAgent.session = TopicContextFactory.getTopicContextFactory().createSession(agentName);
            }
            catch (JMSException ex) {
                if (ex instanceof InvalidClientIDException) {
                    throw new DuplicateAgentNameException(agentName, "Channel with same name already exists");
                }
                throw new RuntimeException(ex);
            }
        }
        for (MessagingAccessLayer.BusAccess busAccess : busAccesses) {
            int index = busAccess.getBus().ordinal();
            localAgent.subscribers[index] = TopicContextFactory.getTopicContextFactory().getSubscriber(localAgent.session, agentName, busAccess, null);
            try {
                localAgent.receivers[index] = new BusReceiver(agentName, busAccess, localAgent.subscribers[index]);
            }
            catch (JMSException ex) {
                logger.error((Object)JMSBusMessagingLayer.class.getName());
            }
        }
    }

    @Override
    public void disconnect(MessagingAccessLayer layer) {
        try {
            this.close();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public void close() throws IOException {
        for (String key : this.mapLocalAgent.keySet()) {
            logger.fine((Object)("******** removing " + key));
            LocalAgent localAgent = this.mapLocalAgent.get(key);
            for (MessageConsumer mc : localAgent.subscribers) {
                if (mc == null) continue;
                try {
                    mc.close();
                }
                catch (JMSException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        for (Bus bus : buses) {
            BusReceiver receiver = this.mapLocalAgent.get((Object)agentName).receivers[bus.ordinal()];
            if (receiver != null) continue;
            throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
        }
    }

    @Override
    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        HashSet<String> result = new HashSet<String>();
        for (String agent : this.mapLocalAgent.keySet()) {
            LocalAgent localAgent = this.mapLocalAgent.get(agent);
            for (Bus bus : buses) {
                int index = bus.ordinal();
                if (localAgent.subscribers[index] == null || result.contains(agent)) continue;
                result.add(agent);
            }
        }
        return result;
    }

    @Override
    public void closeFor(String agentName, Bus ... buses) {
        LocalAgent localAgent;
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) != null) {
            for (Bus b : buses) {
                int index = b.ordinal();
                try {
                    localAgent.subscribers[index].close();
                    localAgent.session.unsubscribe(agentName);
                }
                catch (JMSException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @Override
    public synchronized <T extends BusMessage> void sendMessage(String senderAgent, Bus bus, T message) {
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        int index = bus.ordinal();
        Session s = this.mapLocalAgent.get((Object)senderAgent).session;
        MessageProducer send = null;
        try {
            send = s.createProducer((Destination)TopicContextFactory.getTopicContextFactory().getTopic(bus.toString()));
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
        this.sendMessageToDestination(s, message, "", send, bus);
    }

    public <T extends BusMessage> void sendMessageToDestination(Session s, T message, String dest, MessageProducer send, Bus bus) {
        ObjectMessage m;
        try {
            m = s.createObjectMessage();
            m.setObject(message);
            if (!dest.isEmpty()) {
                m.setStringProperty("destination", dest);
            }
        }
        catch (JMSException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        try {
            m.setJMSMessageID("0");
            m.setJMSPriority(4);
            m.setJMSReplyTo((Destination)TopicContextFactory.getTopicContextFactory().getCommandTopic());
            m.setJMSTimestamp(System.currentTimeMillis());
            String busName = bus.toString();
            logger.debug((Object)("sending message " + m.getObject()));
            send.send((Message)m);
        }
        catch (JMSException e) {
            logger.error((Object)"Error sending message", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgent localAgent;
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) == null) {
            return;
        }
        for (Bus bus : buses) {
            BusReceiver receiver = localAgent.receivers[bus.ordinal()];
            if (receiver != null) continue;
        }
    }

    @Override
    public void register(String agentName, Bus ... buses) throws IOException {
    }

    class LocalAgent {
        String agentName;
        Session session;
        MessageConsumer[] subscribers = new MessageConsumer[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgent() {
        }
    }

    class BusReceiver
    implements MessageListener {
        MessagingAccessLayer.BusAccess busAccess;
        MessageConsumer curConsumer;
        String agentName;

        BusReceiver(String agentName, MessagingAccessLayer.BusAccess busAccess, MessageConsumer curConsumer) throws JMSException {
            this.agentName = agentName;
            this.busAccess = busAccess;
            this.curConsumer = curConsumer;
            curConsumer.setMessageListener((MessageListener)this);
        }

        public void onMessage(Message message) {
            BusMessage busMessInit = null;
            try {
                busMessInit = (BusMessage)((ObjectMessage)message).getObject();
            }
            catch (JMSException ex) {
                logger.error((Object)JMSBusMessagingLayer.class.getName());
            }
            BusMessage busMess = busMessInit;
            this.busAccess.processBusMessage(busMess);
        }
    }
}

