/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;
import org.apache.commons.math.special.Erf;

public class GaussianCoreNorm
extends FunctionCore {
    protected boolean providesNormalization;
    protected final double r2 = Math.sqrt(2.0);

    public GaussianCoreNorm(String str) {
        super(1, 2, new double[]{0.0, 1.0});
        this.setTitle("GaussianCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"mean", "sigma"};
        this.setParameterNames(names);
    }

    public GaussianCoreNorm(String str, double[] pVal) {
        super(1, 2, pVal);
        this.setTitle("GaussianCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"mean", "sigma"};
        this.setParameterNames(names);
    }

    @Override
    public double functionValue(double[] var) {
        return Math.exp(-Math.pow(var[0] - this.p[0], 2.0) / (2.0 * Math.pow(this.p[1], 2.0)));
    }

    @Override
    public boolean providesGradient() {
        return true;
    }

    @Override
    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * -2.0 * (var[0] - this.p[0]) / (2.0 * Math.pow(this.p[1], 2.0))};
    }

    @Override
    public boolean providesParameterGradient() {
        return true;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        double y = this.functionValue(var);
        return new double[]{y * 2.0 * (var[0] - this.p[0]) / (2.0 * Math.pow(this.p[1], 2.0)), y * 2.0 * Math.pow(var[0] - this.p[0], 2.0) / (2.0 * Math.pow(Math.abs(this.p[1]), 3.0))};
    }

    @Override
    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        try {
            double ue = Erf.erf((double)((xMax[0] - this.p[0]) / (this.r2 * this.p[1])));
            double le = Erf.erf((double)((xMin[0] - this.p[0]) / (this.r2 * this.p[1])));
            return Math.sqrt(1.5707963267948966) * this.p[1] * (ue - le);
        }
        catch (Exception e) {
            System.out.println("Problem evaluating normalization between " + xMin[0] + " and " + xMax[0]);
            return Double.NaN;
        }
    }
}

