
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NICE_PINK;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.resetTable;

/**
 *
 * @author virieux
 */
public class CarouselSocketTablePanel extends JPanel {

    private JTable socketTable;
    private JScrollPane jScrollPane;

    private static final String[] SOCKET_NAMES = {"socket1", "socket2", "socket3", "socket4", "socket5"};

    public CarouselSocketTablePanel() {
        initComponents();
    }

    /**
     * Initialization of the GUI from data stored in Configuration.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            DefaultTableModel socketTableModel = (DefaultTableModel) socketTable.getModel();
            for (String socketName : SOCKET_NAMES) {
                Map<String, String> config = configInfo.getCurrentValuesFor("carousel/" + socketName);
                Object[] tab = {socketName,
                    Integer.parseInt(config.get("standbyPosition")),
                    "",
                    ""};
                socketTableModel.addRow(tab);
            }
            socketTableModel.fireTableDataChanged();
        }
    }

    /**
     * A Runnable to updateSocket this panel from a
     * StatusDataPublishedByCarouselSocket.
     */
    public class UpdateSocket implements Runnable {

        private StatusDataPublishedByCarouselSocket s;

        public UpdateSocket(StatusDataPublishedByCarouselSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            //filterPanel.setIsFilterInHouse(!s.isEmpty(), s.getFilterName(), s.getFilterID());
            DefaultTableModel socketTableModel = (DefaultTableModel) socketTable.getModel();
            int rowNB = socketTableModel.getRowCount();
            for (int i = 0; i < rowNB; i++) {
                String socketName = "socket" + s.getSocketID();
                if ((socketTableModel.getValueAt(i, 0)).equals(socketName)) {
                    if (s.isEmpty()) {
                        socketTableModel.setValueAt("", i, 3);
                        socketTableModel.setValueAt("", i, 2);
                    } else {
                        socketTableModel.setValueAt(s.getFilterName(), i, 3);
                        socketTableModel.setValueAt(s.getFilterID(), i, 2);
                    }
                }
            }
            socketTableModel.fireTableDataChanged();
        }
    }

    /**
     * Initialize Panel with socket list name.
     *
     * @param configInfo
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateSocket(StatusDataPublishedByCarouselSocket s) {
        SwingUtilities.invokeLater(new UpdateSocket(s));
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">
    private void initComponents() {

        /**
         ******************************************************************************
         ** Socket Table
         * *****************************************************************************
         */
        jScrollPane = new JScrollPane();
        socketTable = new JTable();
        socketTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "NAME", "STANDBY POSITION", "FILTER ID", "FILTER NAME"}
        ) {
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types = new Class[]{
                String.class, Integer.class, Integer.class, String.class};
            private final boolean[] canEdit = new boolean[]{
                false, false, false, false};

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        socketTable.setName("socketTable");
        /* size */
        TableColumn column;
        int rowNB = socketTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; i++) {
            column = socketTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(30); //first column is smaller to display socket name.
            }
        }
        jScrollPane.setPreferredSize(new java.awt.Dimension(500, 113));
        jScrollPane.setViewportView(socketTable);
        /**
         ******************************************************************************
         ** end of Socket Table
         * *****************************************************************************
         */

        //Whole Panel
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(NICE_PINK), "Carousel Sockets"));

        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(jScrollPane, gbc);
    }

    /**
     * Remove data on panel.
     * To be used when subsystem is disconnecting.
     */
    public void resetPanel() {
        resetTable(socketTable);
    }

    /**
     * Just for tests.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        CarouselSocketTablePanel p = new CarouselSocketTablePanel();

        JFrame frame = new JFrame("Sockets Panel");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
