/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class StaticChannel
implements AgentChannel {
    private final String path;
    private final AgentInfo agent;
    private final Object value;
    protected HashMap<String, Object> data;

    public StaticChannel(AgentInfo agent, String path, Object value) {
        this.agent = agent;
        this.path = path;
        this.value = value;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAgentName() {
        return this.agent.getName();
    }

    @Override
    public AgentInfo getAgent() {
        return this.agent;
    }

    @Override
    public String getLocalPath() {
        return this.path.substring(this.path.indexOf("/") + 1);
    }

    @Override
    public <T> T get(Object key) {
        String out;
        if (key == null) {
            return this.get();
        }
        String sKey = key.toString();
        if ("value".equals(sKey)) {
            return this.get();
        }
        try {
            out = this.agent.getAgentProperty(sKey);
        }
        catch (ClassCastException x) {
            out = null;
        }
        return (T)out;
    }

    @Override
    public <T> T get() {
        return (T)this.value;
    }

    @Override
    public List<String> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean set(Object key, Object value) {
        return false;
    }

    @Override
    public boolean set(Object value) {
        return false;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        return this.path.equals(obj) || obj instanceof AgentChannel && this.path.equals(((AgentChannel)obj).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

