/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.ButtonRecord;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.io.Action;

public class DefineButton
extends DefinitionTag {
    private int character;
    private Vector<ButtonRecord> buttons;
    private Vector<Action> actions;

    public DefineButton(int id, Vector<ButtonRecord> buttons, Vector<Action> actions) {
        this();
        this.character = id;
        this.buttons = buttons;
        this.actions = actions;
    }

    public DefineButton() {
        super(7, 1);
    }

    @Override
    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineButton tag = new DefineButton();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.buttons = new Vector();
        ButtonRecord record = new ButtonRecord(swf, false);
        while (!record.isEndRecord()) {
            tag.buttons.add(record);
            record = new ButtonRecord(swf, false);
        }
        tag.actions = new Vector();
        Action action = swf.readAction();
        while (action != null) {
            tag.actions.add(action);
            action = swf.readAction();
        }
        return tag;
    }

    @Override
    public void write(int tagID, SWFOutputStream swf) throws IOException {
        int i;
        swf.writeUnsignedShort(this.character);
        for (i = 0; i < this.buttons.size(); ++i) {
            ButtonRecord b = this.buttons.get(i);
            b.write(swf);
        }
        swf.writeUnsignedByte(0);
        for (i = 0; i < this.actions.size(); ++i) {
            Action a = this.actions.get(i);
            swf.writeAction(a);
        }
        swf.writeAction(null);
    }

    @Override
    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        for (i = 0; i < this.buttons.size(); ++i) {
            s.append("  ");
            s.append(this.buttons.get(i));
            s.append("\n");
        }
        for (i = 0; i < this.actions.size(); ++i) {
            s.append("  ");
            s.append(this.actions.get(i));
            s.append("\n");
        }
        return s.toString();
    }
}

