/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.carousel.ui.AnalogicSensorPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FilterPresenceSensorPanel
extends AnalogicSensorPanel {
    private static final long serialVersionUID = 1L;
    private JLabel offset2Label;
    private JLabel minNoFilterLabel;

    public FilterPresenceSensorPanel(String clampName, String sensorName, int orientation) {
        super(clampName, sensorName, orientation);
    }

    @Override
    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.clampName);
        String[] words = this.sensorName.split("X");
        this.minLimitLabel.setText("0");
        this.offset2Label.setText("0");
        this.maxLimitLabel.setText((String)config.get(words[0] + "MaxValue"));
        Map configCa = configInfo.getCurrentValuesFor("carousel");
        this.minNoFilterLabel.setText((String)configCa.get("filterPresenceMinNoFilter"));
    }

    @Override
    protected void updateOffset1(int value) {
        this.minLimitLabel.setText(Integer.toString(value));
    }

    protected void updateOffset2(int value) {
        this.offset2Label.setText(Integer.toString(value));
    }

    @Override
    protected void initParamsPanel() {
        this.offset2Label = new JLabel();
        this.minNoFilterLabel = new JLabel();
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(Tools.getConfigurationTitle());
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("minLimit:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("offset2:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("minNoFilter:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("maxLimit:"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.minLimitLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.offset2Label, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.minNoFilterLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.maxLimitLabel, gbcp);
    }

    public static void main(String[] argv) {
        FilterPresenceSensorPanel d = new FilterPresenceSensorPanel("clampToto", "leBoCapteur", 1);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

