/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class PlutoGatewayPanel
extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;
    private static final Logger FCSLOG = Logger.getLogger(PlutoGatewayPanel.class.getName());
    private static final Dimension PREFERED_SIZE = new Dimension(400, 300);
    private final String myName;
    private final String fullPathGatewayName;
    private final String gatewayName;
    private final CanOpenDevicePanel generalInfoPanel;
    private final JPanel valuesPanel;
    JScrollPane jScrollPane = new JScrollPane();
    JTable valuesTable = new JTable();
    private final JPanel sensorsPanel;
    private final JTable sensorsTable = new JTable();
    private final JScrollPane sensorsJScrollPane = new JScrollPane();
    protected List<String> sensorNames;

    public PlutoGatewayPanel(String fullPathGatewayName) {
        this.fullPathGatewayName = fullPathGatewayName;
        this.generalInfoPanel = new CanOpenDevicePanel(fullPathGatewayName);
        this.gatewayName = Tools.getShortComponentName(fullPathGatewayName);
        this.myName = this.gatewayName + "Panel";
        this.valuesPanel = new JPanel();
        this.sensorsPanel = new JPanel();
        this.initComponents();
    }

    public void setSensorNames(List<String> sensorNamesList) {
        this.sensorNames = new ArrayList<String>();
        for (String fullPathSensorName : sensorNamesList) {
            this.sensorNames.add(Tools.getShortComponentName(fullPathSensorName));
        }
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        this.generalInfoPanel.initializeGui(configInfo);
        DefaultTableModel valuesTableModel = (DefaultTableModel)this.valuesTable.getModel();
        for (int i = 0; i < 17; ++i) {
            Object[] tab = new Object[]{i, 0, 0};
            valuesTableModel.addRow(tab);
        }
        valuesTableModel.fireTableDataChanged();
    }

    public void initializeGuiWithSensorsList(ConfigurationInfo configInfo, List<String> sensorList) {
        this.setSensorNames(sensorList);
        DefaultTableModel sensorsTableModel = (DefaultTableModel)this.sensorsTable.getModel();
        for (String fullPathSensorName : sensorList) {
            Object[] tab;
            FCSLOG.info("retrieving configInfo for " + fullPathSensorName);
            Map sensorConfig = configInfo.getCurrentValuesFor(fullPathSensorName);
            String sensorName = Tools.getShortComponentName(fullPathSensorName);
            int byteNumero = Integer.parseInt((String)sensorConfig.get("byteNumero"));
            String inputNumeroS = (String)sensorConfig.get("inputNumero");
            if (inputNumeroS == null) {
                tab = new Object[]{sensorName, byteNumero};
                sensorsTableModel.addRow(tab);
                continue;
            }
            tab = new Object[]{sensorName, byteNumero, Integer.parseInt(inputNumeroS)};
            sensorsTableModel.addRow(tab);
        }
        sensorsTableModel.fireTableDataChanged();
    }

    public void updatePlutoGateway(String deviceToUpdateName, StatusDataPublishedByPlutoGateway status) {
        if (this.gatewayName.equals(deviceToUpdateName)) {
            this.generalInfoPanel.updateCanOpenDevice(deviceToUpdateName, (StatusDataPublishedByHardware)status);
            SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
        }
    }

    public void updateSensor(KeyValueDataList kvdl) {
        SwingUtilities.invokeLater(new UpdateSensor(kvdl));
    }

    private void initComponents() {
        this.initValuesPanel();
        this.initSensorsPanel();
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.valuesPanel, gbc);
        ++gbc.gridy;
        boolean b = false;
        this.add((Component)this.sensorsPanel, gbc);
    }

    public void initValuesPanel() {
        this.valuesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Byte", "Decimal Value", "Binaire Value"}){
            private static final long serialVersionUID = 1L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.valuesTable.setName("valuesTable_" + this.gatewayName);
        for (int i = 0; i < 3; ++i) {
            TableColumn column = this.valuesTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(25);
            }
            if (i != 2) continue;
            column.setPreferredWidth(150);
        }
        this.jScrollPane.setViewportView(this.valuesTable);
        this.jScrollPane.setPreferredSize(PREFERED_SIZE);
        this.valuesPanel.setBorder(BorderFactory.createLineBorder(Tools.NICE_PINK));
        this.valuesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 18;
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.valuesPanel.add((Component)this.jScrollPane, gbc0);
    }

    public void initSensorsPanel() {
        DefaultTableModel sensorDefaultModel = new DefaultTableModel(new Object[0][], new String[]{"Sensor Name", "Byte", "Bit", "Value"}){
            private static final long serialVersionUID = 1L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.sensorsTable.setName("sensorsTable_" + this.gatewayName);
        this.sensorsTable.setModel(sensorDefaultModel);
        this.sensorsTable.setRowSorter(new TableRowSorter<2>(sensorDefaultModel));
        for (int i = 0; i < 2; ++i) {
            TableColumn column = this.sensorsTable.getColumnModel().getColumn(i);
            if (i != 0) continue;
            column.setPreferredWidth(PlutoGatewayPanel.PREFERED_SIZE.width * 2 / 3);
        }
        this.sensorsJScrollPane.setViewportView(this.sensorsTable);
        this.sensorsJScrollPane.setPreferredSize(PREFERED_SIZE);
        this.sensorsPanel.setBorder(BorderFactory.createTitledBorder("Table of sensors plugged on " + this.gatewayName));
        this.sensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel jl = new JLabel("Click on the top of a column to sort this table.");
        this.sensorsPanel.add((Component)jl, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.sensorsJScrollPane, gbc);
    }

    public void resetPanel() {
        FCSLOG.info(this.myName + " resetting panels");
        this.generalInfoPanel.resetPanel();
        Tools.resetTable(this.valuesTable);
        Tools.resetTable(this.sensorsTable);
    }

    @Override
    public String toString() {
        if (this.fullPathGatewayName == null) {
            return "plutoGateway";
        }
        return Tools.getShortComponentName(this.fullPathGatewayName);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel("my_plutoGateway");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateSensor
    implements Runnable {
        private KeyValueDataList kvdl;

        public UpdateSensor(KeyValueDataList kvdl) {
            this.kvdl = kvdl;
        }

        @Override
        public void run() {
            for (KeyValueData data : this.kvdl) {
                String sensorName = data.getKey();
                DefaultTableModel sensorsTableModel = (DefaultTableModel)PlutoGatewayPanel.this.sensorsTable.getModel();
                int rowNB = sensorsTableModel.getRowCount();
                for (int i = 0; i < rowNB; ++i) {
                    if (sensorsTableModel.getValueAt(i, 0).equals(sensorName) && !sensorName.contains("inclinometer")) {
                        sensorsTableModel.setValueAt((int)((Integer)data.getValue()), i, 3);
                        continue;
                    }
                    if (!sensorsTableModel.getValueAt(i, 0).equals(sensorName) || !sensorName.contains("inclinometer")) continue;
                    sensorsTableModel.setValueAt((double)((Double)data.getValue()), i, 3);
                }
                sensorsTableModel.fireTableDataChanged();
            }
        }
    }

    class UpdatePlutoGateway
    implements Runnable {
        private StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            FCSLOG.fine(() -> " UpdatePlutoGateway for gateway=" + PlutoGatewayPanel.this.fullPathGatewayName);
            PlutoGatewayPanel.this.generalInfoPanel.updateCanOpenDevice(PlutoGatewayPanel.this.fullPathGatewayName, (StatusDataPublishedByHardware)this.s);
            DefaultTableModel valuesTableModel = (DefaultTableModel)PlutoGatewayPanel.this.valuesTable.getModel();
            int rowNB = this.s.getIntValues().length;
            for (int i = 0; i < rowNB; ++i) {
                int value = this.s.getIntValues()[i];
                String bin = String.format("%016d", Long.parseLong(Integer.toBinaryString(value)));
                valuesTableModel.setValueAt(value, i, 1);
                valuesTableModel.setValueAt("  0b" + bin, i, 2);
            }
            valuesTableModel.fireTableDataChanged();
        }
    }
}

