/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsbase.util.Value;
import org.freehep.graphicsbase.xml.util.XMLWriter;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.svg.SVGFontTable;
import org.freehep.util.io.Base64OutputStream;
import org.freehep.util.io.WriterOutputStream;

public class SVGGraphics2D
extends AbstractVectorGraphicsIO {
    public static final String VERSION_1_1 = "Version 1.1 (REC-SVG11-20030114)";
    private static final String rootKey = SVGGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String VERSION = rootKey + ".Version";
    public static final String COMPRESS = rootKey + ".Binary";
    public static final String STYLABLE = rootKey + ".Stylable";
    public static final String IMAGE_SIZE = rootKey + "." + "ImageSize";
    public static final String EXPORT_IMAGES = rootKey + ".ExportImages";
    public static final String EXPORT_SUFFIX = rootKey + ".ExportSuffix";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    private BasicStroke defaultStroke = new BasicStroke();
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    private SVGFontTable fontTable;
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision$";
    private String filename;
    private int bbx;
    private int bby;
    private int bbw;
    private int bbh;
    private OutputStream ros;
    private PrintWriter os;
    Hashtable<GradientPaint, String> gradients = new Hashtable();
    Hashtable<?, ?> textures = new Hashtable();
    private Stack<String> closeTags = new Stack();
    private int imageNumber = 0;
    private Value clipNumber;
    private int width;
    private int height;
    private static DecimalFormat scientific;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public SVGGraphics2D(File file, Dimension size) throws IOException {
        this((OutputStream)new FileOutputStream(file), size);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(File file, Component component) throws IOException {
        this((OutputStream)new FileOutputStream(file), component);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
        this.width = size.width;
        this.height = size.height;
    }

    public SVGGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
        this.width = this.getSize().width;
        this.height = this.getSize().height;
    }

    private void init(OutputStream os) {
        this.ros = os;
        this.initProperties(SVGGraphics2D.getDefaultProperties());
        this.filename = null;
        this.clipNumber = new Value().set(0);
    }

    protected SVGGraphics2D(SVGGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.filename = graphics.filename;
        this.os = graphics.os;
        this.bbx = graphics.bbx;
        this.bby = graphics.bby;
        this.bbw = graphics.bbw;
        this.bbh = graphics.bbh;
        this.gradients = graphics.gradients;
        this.textures = graphics.textures;
        this.clipNumber = graphics.clipNumber;
        this.fontTable = graphics.fontTable;
    }

    public void setBoundingBox() {
        this.bbx = 0;
        this.bby = 0;
        Dimension size = this.getSize();
        this.bbw = size.width;
        this.bbh = size.height;
    }

    public void writeHeader() throws IOException {
        int h;
        this.ros = new BufferedOutputStream(this.ros);
        if (this.isProperty(COMPRESS)) {
            this.ros = new GZIPOutputStream(this.ros);
        }
        this.os = new PrintWriter(this.ros, true);
        this.fontTable = new SVGFontTable();
        this.setBoundingBox();
        this.imageNumber = 0;
        this.os.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        if (this.getProperty(VERSION).equals(VERSION_1_1)) {
            // empty if block
        }
        this.os.println();
        int x = 0;
        int y = 0;
        Dimension size = this.getPropertyDimension(IMAGE_SIZE);
        int w = size.width;
        if (w <= 0) {
            w = this.width;
        }
        if ((h = size.height) <= 0) {
            h = this.height;
        }
        this.os.println("<svg ");
        if (this.getProperty(VERSION).equals(VERSION_1_1)) {
            this.os.println("     version=\"1.1\"");
            this.os.println("     baseProfile=\"full\"");
            this.os.println("     xmlns=\"http://www.w3.org/2000/svg\"");
            this.os.println("     xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
            this.os.println("     xmlns:ev=\"http://www.w3.org/2001/xml-events\"");
        }
        this.os.println("     x=\"" + x + "px\"");
        this.os.println("     y=\"" + y + "px\"");
        this.os.println("     width=\"" + w + "px\"");
        this.os.println("     height=\"" + h + "px\"");
        this.os.println("     viewBox=\"" + this.bbx + " " + this.bby + " " + this.bbw + " " + this.bbh + "\"");
        this.os.println("     >");
        this.closeTags.push("</svg> <!-- bounding box -->");
        this.os.print("<title>");
        this.os.print(XMLWriter.normalizeText((String)this.getProperty(TITLE)));
        this.os.println("</title>");
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.print("<desc>");
        this.os.print("Creator: " + XMLWriter.normalizeText((String)this.getCreator()));
        this.os.print(" Producer: " + XMLWriter.normalizeText((String)producer));
        this.os.print(" Source: " + XMLWriter.normalizeText((String)this.getProperty(FOR)));
        if (!this.isDeviceIndependent()) {
            this.os.print(" Date: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("</desc>");
        this.os.print("<g ");
        Properties style = this.getStrokeProperties(this.defaultStroke, true);
        this.os.print(this.style(style));
        this.os.println(">");
        this.closeTags.push("</g> <!-- default stroke -->");
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (this.isProperty(EMBED_FONTS)) {
            this.os.println("<defs>");
            this.os.println(this.fontTable.toString());
            this.os.println("</defs> <!-- font definitions -->");
        }
        this.writeGraphicsRestore();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new SVGGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        SVGGraphics2D graphics = new SVGGraphics2D(this, true);
        this.os.println("<svg x=\"" + SVGGraphics2D.fixedPrecision(x) + "\" y=\"" + SVGGraphics2D.fixedPrecision(y) + "\" width=\"" + SVGGraphics2D.fixedPrecision(width) + "\" height=\"" + SVGGraphics2D.fixedPrecision(height) + "\" >");
        graphics.closeTags.push("</svg> <!-- graphics context -->");
        this.os.print("<g ");
        Properties style = this.getStrokeProperties(this.defaultStroke, true);
        this.os.print(this.style(style));
        this.os.println(">");
        graphics.closeTags.push("</g> <!-- default stroke -->");
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        while (!this.closeTags.empty()) {
            this.os.println(this.closeTags.pop());
        }
    }

    public void draw(Shape shape) {
        if (this.getStroke() instanceof BasicStroke) {
            PathIterator path = shape.getPathIterator(null);
            Properties style = new Properties();
            if (this.getPaint() != null) {
                style.put("stroke", this.hexColor(this.getPaint()));
                style.put("stroke-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
            }
            style.put("fill", "none");
            style.putAll((Map<?, ?>)this.getStrokeProperties(this.getStroke(), false));
            this.writePathIterator(path, style);
        } else if (this.getStroke() != null) {
            this.fill(this.getStroke().createStrokedShape(shape));
        } else {
            this.fill(this.defaultStroke.createStrokedShape(shape));
        }
    }

    public void fill(Shape shape) {
        if (!(this.getPaint() instanceof Color) && !(this.getPaint() instanceof GradientPaint)) {
            this.fill(shape, this.getPaint());
        } else {
            PathIterator path = shape.getPathIterator(null);
            Properties style = new Properties();
            if (path.getWindingRule() == 0) {
                style.put("fill-rule", "evenodd");
            } else {
                style.put("fill-rule", "nonzero");
            }
            if (this.getPaint() != null) {
                style.put("fill", this.hexColor(this.getPaint()));
                style.put("fill-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
            }
            style.put("stroke", "none");
            this.writePathIterator(path, style);
        }
    }

    private void writePathIterator(PathIterator pi, Properties style) {
        StringBuffer result = new StringBuffer();
        result.append("<g ");
        result.append(this.style(style));
        result.append(">\n  ");
        result.append(this.getPath(pi));
        result.append("\n</g> <!-- drawing style -->");
        boolean drawClipped = false;
        if (this.getClip() != null) {
            GeneralPath gp = new GeneralPath();
            gp.append(pi, true);
            Stroke stroke = this.getStroke() == null ? this.defaultStroke : this.getStroke();
            Rectangle bounds = stroke.createStrokedShape(gp).getBounds();
            boolean bl = drawClipped = this.getClip().intersects(bounds) && !this.getClip().contains(bounds);
        }
        if (drawClipped) {
            this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(result.toString())));
        } else {
            this.os.println(this.getTransformedString(this.getTransform(), result.toString()));
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        boolean isTransparent;
        StringBuffer result = new StringBuffer();
        result.append("<image x=\"0\" y=\"0\" width=\"");
        result.append(image.getWidth());
        result.append("\" height=\"");
        result.append(image.getHeight());
        result.append("\" xlink:href=\"");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        boolean bl = isTransparent = image.getColorModel().hasAlpha() && bkg == null;
        if ("PNG".equalsIgnoreCase(writeAs) || isTransparent) {
            encode = "PNG";
            imageBytes = ImageGraphics2D.toByteArray((RenderedImage)image, (String)"PNG", null, null);
        } else if ("JPG".equalsIgnoreCase(writeAs)) {
            encode = "JPG";
            imageBytes = ImageGraphics2D.toByteArray((RenderedImage)image, (String)"JPG", null, null);
        } else {
            byte[] pngBytes = ImageGraphics2D.toByteArray((RenderedImage)image, (String)"PNG", null, null);
            byte[] jpgBytes = ImageGraphics2D.toByteArray((RenderedImage)image, (String)"JPG", null, null);
            if ((double)jpgBytes.length < 0.5 * (double)pngBytes.length) {
                encode = "JPG";
                imageBytes = jpgBytes;
            } else {
                encode = "PNG";
                imageBytes = pngBytes;
            }
        }
        if (this.isProperty(EXPORT_IMAGES)) {
            ++this.imageNumber;
            if (this.filename == null) {
                this.writeWarning("SVG: cannot write embedded images, since SVGGraphics2D");
                this.writeWarning("     was created from an OutputStream rather than a File.");
                return;
            }
            int pos = this.filename.lastIndexOf(File.separatorChar);
            String dirName = pos < 0 ? "" : this.filename.substring(0, pos + 1);
            String imageName = pos < 0 ? this.filename : this.filename.substring(pos + 1);
            imageName = imageName + "." + this.getProperty(EXPORT_SUFFIX) + "-" + this.imageNumber + "." + encode;
            result.append(imageName);
            FileOutputStream imageStream = new FileOutputStream(dirName + imageName);
            imageStream.write(imageBytes);
            imageStream.close();
        } else {
            result.append("data:image/");
            result.append(encode);
            result.append(";base64,");
            StringWriter writer = new StringWriter();
            Base64OutputStream b64 = new Base64OutputStream((OutputStream)new WriterOutputStream((Writer)writer));
            b64.write(imageBytes);
            b64.finish();
            result.append(writer.toString());
        }
        result.append("\"/>");
        this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(this.getTransformedString(xform, result.toString()))));
    }

    protected void writeString(String str, double x, double y) throws IOException {
        if (this.isProperty(EMBED_FONTS)) {
            this.fontTable.addGlyphs(str, this.getFont());
        }
        Properties style = this.getFontProperties(this.getFont());
        if (this.getPaint() != null) {
            style.put("fill", this.hexColor(this.getPaint()));
            style.put("fill-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
        } else {
            style.put("fill", "none");
        }
        style.put("stroke", "none");
        str = XMLWriter.normalizeText((String)str);
        if (str.startsWith(" ")) {
            str = "&#x00a0;" + str.substring(1);
        }
        this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(this.getTransformedString(new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y), this.getTransformedString(this.getFont().getTransform(), "<text " + this.style(style) + " x=\"0\" y=\"0\">" + str + "</text>")))));
    }

    private Properties getFontProperties(Font font) {
        Properties result = new Properties();
        Hashtable attributes = FontUtilities.getAttributes((Font)font);
        SVGFontTable.normalize(attributes);
        result.put("font-family", attributes.get(TextAttribute.FAMILY));
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            result.put("font-weight", "bold");
        } else {
            result.put("font-weight", "normal");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            result.put("font-style", "italic");
        } else {
            result.put("font-style", "normal");
        }
        Object ul = attributes.get(TextAttribute.UNDERLINE);
        if (ul != null) {
            if (TextAttribute.UNDERLINE_LOW_DOTTED.equals(ul)) {
                result.put("text-underline-style", "dotted");
            } else if (TextAttribute.UNDERLINE_LOW_DASHED.equals(ul)) {
                result.put("text-underline-style", "dashed");
            } else if (TextAttribute.UNDERLINE_ON.equals(ul)) {
                result.put("text-underline-style", "solid");
            }
            result.put("text-decoration", "underline");
        }
        if (attributes.get(TextAttribute.STRIKETHROUGH) != null) {
            if (ul == null) {
                result.put("text-decoration", "underline, line-through");
            } else {
                result.put("text-decoration", "line-through");
            }
        }
        Float size = (Float)attributes.get(TextAttribute.SIZE);
        result.put("font-size", SVGGraphics2D.fixedPrecision(size.floatValue()));
        return result;
    }

    protected void writeTransform(AffineTransform transform) throws IOException {
    }

    protected void writeSetTransform(AffineTransform transform) throws IOException {
    }

    protected void writeClip(Shape s) throws IOException {
    }

    protected void writeSetClip(Shape s) throws IOException {
    }

    protected void writeWidth(float width) throws IOException {
    }

    protected void writeCap(int cap) throws IOException {
    }

    protected void writeJoin(int join) throws IOException {
    }

    protected void writeMiterLimit(float limit) throws IOException {
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
    }

    private Properties getStrokeProperties(Stroke s, boolean all) {
        Properties result = new Properties();
        if (!(s instanceof BasicStroke)) {
            return result;
        }
        BasicStroke stroke = (BasicStroke)s;
        if (all || stroke.getEndCap() != this.defaultStroke.getEndCap()) {
            switch (stroke.getEndCap()) {
                default: {
                    result.put("stroke-linecap", "butt");
                    break;
                }
                case 1: {
                    result.put("stroke-linecap", "round");
                    break;
                }
                case 2: {
                    result.put("stroke-linecap", "square");
                }
            }
        }
        if (all || !Arrays.equals(stroke.getDashArray(), this.defaultStroke.getDashArray())) {
            if (stroke.getDashArray() != null && stroke.getDashArray().length > 0) {
                StringBuffer array = new StringBuffer();
                for (int i = 0; i < stroke.getDashArray().length; ++i) {
                    float dash;
                    if (i > 0) {
                        array.append(",");
                    }
                    array.append(SVGGraphics2D.fixedPrecision((dash = stroke.getDashArray()[i]) > 0.0f ? (double)dash : 0.1));
                }
                result.put("stroke-dasharray", array.toString());
            } else {
                result.put("stroke-dasharray", "none");
            }
        }
        if (all || stroke.getDashPhase() != this.defaultStroke.getDashPhase()) {
            result.put("stroke-dashoffset", SVGGraphics2D.fixedPrecision(stroke.getDashPhase()));
        }
        if (all || stroke.getMiterLimit() != this.defaultStroke.getMiterLimit()) {
            result.put("stroke-miterlimit", SVGGraphics2D.fixedPrecision(stroke.getMiterLimit()));
        }
        if (all || stroke.getLineJoin() != this.defaultStroke.getLineJoin()) {
            switch (stroke.getLineJoin()) {
                default: {
                    result.put("stroke-linejoin", "miter");
                    break;
                }
                case 1: {
                    result.put("stroke-linejoin", "round");
                    break;
                }
                case 2: {
                    result.put("stroke-linejoin", "bevel");
                }
            }
        }
        if (all || stroke.getLineWidth() != this.defaultStroke.getLineWidth()) {
            if (stroke.getLineWidth() == 0.0f) {
                result.put("stroke-width", SVGGraphics2D.fixedPrecision(1.0E-6f));
            } else {
                result.put("stroke-width", SVGGraphics2D.fixedPrecision(stroke.getLineWidth()));
            }
        }
        return result;
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.gradients.get(paint) == null) {
            String name = "gradient-" + this.gradients.size();
            this.gradients.put(paint, name);
            Point2D p1 = paint.getPoint1();
            Point2D p2 = paint.getPoint2();
            this.os.println("<defs>");
            this.os.print("  <linearGradient id=\"" + name + "\" ");
            this.os.print("x1=\"" + SVGGraphics2D.fixedPrecision(p1.getX()) + "\" ");
            this.os.print("y1=\"" + SVGGraphics2D.fixedPrecision(p1.getY()) + "\" ");
            this.os.print("x2=\"" + SVGGraphics2D.fixedPrecision(p2.getX()) + "\" ");
            this.os.print("y2=\"" + SVGGraphics2D.fixedPrecision(p2.getY()) + "\" ");
            this.os.print("gradientUnits=\"userSpaceOnUse\" ");
            this.os.print("spreadMethod=\"" + (paint.isCyclic() ? "reflect" : "pad") + "\" ");
            this.os.println(">");
            this.os.println("    <stop offset=\"0\" stop-color=\"" + this.hexColor(paint.getColor1()) + "\" opacity-stop=\"" + this.alphaColor(paint.getColor1()) + "\" />");
            this.os.println("    <stop offset=\"1\" stop-color=\"" + this.hexColor(paint.getColor2()) + "\" opacity-stop=\"" + this.alphaColor(paint.getColor2()) + "\" />");
            this.os.println("  </linearGradient>");
            this.os.println("</defs>");
        }
        Properties style = new Properties();
        style.put("stroke", this.hexColor(this.getPaint()));
        this.os.print("<g ");
        this.os.print(this.style(style));
        this.os.println(">");
        this.closeTags.push("</g> <!-- color -->");
    }

    protected void writePaint(TexturePaint paint) throws IOException {
    }

    protected void writePaint(Paint p) throws IOException {
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String s) throws IOException {
        this.os.println("<!-- " + s + " -->");
    }

    public String toString() {
        return "SVGGraphics2D";
    }

    private String getTransformedString(AffineTransform t, String s) {
        StringBuffer result = new StringBuffer();
        if (t != null && !t.isIdentity()) {
            result.append("<g transform=\"matrix(");
            result.append(SVGGraphics2D.fixedPrecision(t.getScaleX()));
            result.append(", ");
            result.append(SVGGraphics2D.fixedPrecision(t.getShearY()));
            result.append(", ");
            result.append(SVGGraphics2D.fixedPrecision(t.getShearX()));
            result.append(", ");
            result.append(SVGGraphics2D.fixedPrecision(t.getScaleY()));
            result.append(", ");
            result.append(SVGGraphics2D.fixedPrecision(t.getTranslateX()));
            result.append(", ");
            result.append(SVGGraphics2D.fixedPrecision(t.getTranslateY()));
            result.append(")\">\n");
        }
        result.append(s);
        if (t != null && !t.isIdentity()) {
            result.append("\n</g> <!-- transform -->");
        }
        return result.toString();
    }

    private String getClippedString(String s) {
        StringBuffer result = new StringBuffer();
        if (this.isProperty(CLIP) && this.getClip() != null) {
            this.clipNumber.set(this.clipNumber.getInt() + 1);
            result.append("<clipPath id=\"clip");
            result.append(this.clipNumber.getInt());
            result.append("\">\n  ");
            result.append(this.getPath(this.getClip().getPathIterator(null)));
            result.append("\n</clipPath>\n");
            result.append("<g clip-path=\"url(#clip");
            result.append(this.clipNumber.getInt());
            result.append(")\">\n");
        }
        result.append(s);
        if (this.isProperty(CLIP) && this.getClip() != null) {
            result.append("\n</g> <!-- clip");
            result.append(this.clipNumber.getInt());
            result.append(" -->");
        }
        return result.toString();
    }

    private float alphaColor(Paint p) {
        if (p instanceof Color) {
            return (float)((double)this.getPrintColor((Color)p).getAlpha() / 255.0);
        }
        if (p instanceof GradientPaint) {
            return 1.0f;
        }
        if (p instanceof TexturePaint) {
            return 1.0f;
        }
        this.writeWarning(((Object)((Object)this)).getClass() + ": alphaColor() not implemented for " + p.getClass() + ".");
        return 1.0f;
    }

    private String hexColor(Paint p) {
        if (p instanceof Color) {
            return this.hexColor(this.getPrintColor((Color)p));
        }
        if (p instanceof GradientPaint) {
            return this.hexColor((GradientPaint)p);
        }
        if (p instanceof TexturePaint) {
            return this.hexColor((TexturePaint)p);
        }
        this.writeWarning(((Object)((Object)this)).getClass() + ": hexColor() not implemented for " + p.getClass() + ".");
        return "#000000";
    }

    private String hexColor(Color c) {
        String s1 = Integer.toHexString(c.getRed());
        s1 = s1.length() != 2 ? "0" + s1 : s1;
        String s2 = Integer.toHexString(c.getGreen());
        s2 = s2.length() != 2 ? "0" + s2 : s2;
        String s3 = Integer.toHexString(c.getBlue());
        s3 = s3.length() != 2 ? "0" + s3 : s3;
        return "#" + s1 + s2 + s3;
    }

    private String hexColor(GradientPaint p) {
        return "url(#" + this.gradients.get(p) + ")";
    }

    private String hexColor(TexturePaint p) {
        return "url(#" + this.textures.get(p) + ")";
    }

    protected static String getPathContent(PathIterator path) {
        StringBuffer result = new StringBuffer();
        double[] coords = new double[6];
        result.append("d=\"");
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    result.append("M ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[0]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[1]));
                    break;
                }
                case 1: {
                    result.append("L ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[0]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[1]));
                    break;
                }
                case 3: {
                    result.append("C ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[0]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[1]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[2]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[3]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[4]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[5]));
                    break;
                }
                case 2: {
                    result.append("Q ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[0]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[1]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[2]));
                    result.append(" ");
                    result.append(SVGGraphics2D.fixedPrecision(coords[3]));
                    break;
                }
                case 4: {
                    result.append("z");
                }
            }
            path.next();
            if (path.isDone()) continue;
            result.append(" ");
        }
        result.append("\"");
        return result.toString();
    }

    protected String getPath(PathIterator path) {
        StringBuffer result = new StringBuffer();
        result.append("<path ");
        result.append(SVGGraphics2D.getPathContent(path));
        result.append("/>");
        return result.toString();
    }

    private String style(Properties style) {
        if (style == null || style.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean styleable = this.isProperty(STYLABLE);
        if (styleable) {
            result.append("style=\"");
        }
        Enumeration<Object> keys = style.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = style.getProperty(key);
            result.append(key);
            if (styleable) {
                result.append(":");
                result.append(value);
                result.append(";");
                continue;
            }
            result.append("=\"");
            result.append(value);
            result.append("\"");
            if (!keys.hasMoreElements()) continue;
            result.append(" ");
        }
        if (styleable) {
            result.append("\"");
        }
        return result.toString();
    }

    public static String fixedPrecision(double d) {
        return scientific.format(d);
    }

    protected PrintWriter getOutputStream() {
        return this.os;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION_1_1);
        defaultProperties.setProperty(COMPRESS, false);
        defaultProperties.setProperty(STYLABLE, false);
        defaultProperties.setProperty(IMAGE_SIZE, new Dimension(0, 0));
        defaultProperties.setProperty(EXPORT_IMAGES, false);
        defaultProperties.setProperty(EXPORT_SUFFIX, "image");
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        scientific = new DecimalFormat("#.####################", new DecimalFormatSymbols(Locale.US));
    }
}

