/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.ControllerStatePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerLatchPanel
extends JPanel {
    private static final long serialVersionUID = -3564360054429278810L;
    private static final Logger FCSLOG = Logger.getLogger(AutochangerLatchPanel.class.getName());
    private InterfaceAutochangerGUI subs;
    private DigitalSwitch openSensorDS;
    private DigitalSwitch closeSensorDS;
    private DigitalSwitch filterEngagedSensorDS;
    private DigitalSwitch errorDS;
    private JPanel sensorsPanel;
    private String latchName;
    private JLabel latchNameLabel;
    private JLabel openLabel;
    private JLabel closeLabel;
    private JLabel errorLabel;
    private JLabel filterEngagedLabel;
    private JLabel lockStatus;
    private JPanel paramPanel;
    private final JLabel motionTimeoutLabel = new JLabel();
    private final JLabel currentToOpenLabel = new JLabel();
    private final JLabel currentToCloseLabel = new JLabel();
    private final ControllerStatePanel controllerPanel;
    private JPanel controlPanel;
    private JButton abortButton;
    private JButton closeButton;
    private JButton openButton;

    public AutochangerLatchPanel(String latchName) {
        this.latchName = latchName;
        String controllerName = latchName.contains("Xminus") ? "latchXminusController" : "latchXplusController";
        this.controllerPanel = new ControllerStatePanel(controllerName, false);
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    void setLatchName(String name) {
        this.latchNameLabel.setText(name);
    }

    public void initializeGui(ConfigurationInfo configInfo, long timeout) {
        FCSLOG.info(() -> "Initializing panel for " + this.latchNameLabel + " timeout=" + timeout);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo, timeout));
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    public void updateController(StatusDataPublishedByEPOSController s) {
        this.controllerPanel.update(s);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.subs.closeLatch(this.latchName);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.subs.openLatch(this.latchName);
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void initComponents() {
        this.closeButton = new JButton("Close Latch");
        this.openButton = new JButton("Open Latch");
        this.abortButton = new JButton("Abort");
        this.closeButton.addActionListener(evt -> this.closeButtonActionPerformed(evt));
        this.openButton.addActionListener(evt -> this.openButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortButtonActionPerformed(evt));
        this.openSensorDS = new DigitalSwitch();
        this.closeSensorDS = new DigitalSwitch();
        this.filterEngagedSensorDS = new DigitalSwitch();
        this.errorDS = new DigitalSwitch();
        this.latchNameLabel = new JLabel("myLatch");
        this.openLabel = new JLabel("<html><P align=\"center\">OPEN<br>SENSOR</p></html>");
        this.closeLabel = new JLabel("<html><P align=\"center\">CLOSE<br>SENSOR</p></html>");
        this.errorLabel = new JLabel("ERROR");
        this.filterEngagedLabel = new JLabel("<html><P align=\"center\">FILTER<br>ENGAGED</p></html>");
        this.lockStatus = new JLabel();
        this.sensorsPanel = new JPanel();
        this.sensorsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.sensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcs = new GridBagConstraints();
        gbcs.insets = Tools.insets_std;
        gbcs.gridx = 0;
        gbcs.gridy = 0;
        this.sensorsPanel.add((Component)this.latchNameLabel, gbcs);
        ++gbcs.gridy;
        this.sensorsPanel.add((Component)this.lockStatus, gbcs);
        gbcs.gridx = 1;
        gbcs.gridy = 0;
        this.sensorsPanel.add((Component)this.openSensorDS, gbcs);
        ++gbcs.gridy;
        this.sensorsPanel.add((Component)this.openLabel, gbcs);
        gbcs.gridx = 2;
        gbcs.gridy = 0;
        this.sensorsPanel.add((Component)this.closeSensorDS, gbcs);
        ++gbcs.gridy;
        this.sensorsPanel.add((Component)this.closeLabel, gbcs);
        gbcs.gridx = 3;
        gbcs.gridy = 0;
        this.sensorsPanel.add((Component)this.filterEngagedSensorDS, gbcs);
        ++gbcs.gridy;
        this.sensorsPanel.add((Component)this.filterEngagedLabel, gbcs);
        gbcs.gridx = 4;
        gbcs.gridy = 0;
        this.sensorsPanel.add((Component)this.errorDS, gbcs);
        ++gbcs.gridy;
        this.sensorsPanel.add((Component)this.errorLabel, gbcs);
        this.paramPanel = new JPanel();
        this.paramPanel.setBorder(Tools.getConfigurationTitle());
        this.paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramPanel.add((Component)new JLabel("timeout to open/close:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("current to open:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("current to close:"), gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.motionTimeoutLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToOpenLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToCloseLabel, gbcp);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.controlPanel.add((Component)this.closeButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.openButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.abortButton, gbc3);
        this.setDefaultValues();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_big;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.sensorsPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controllerPanel, gbc);
        gbc.anchor = 17;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.paramPanel, gbc);
        ++gbc.gridx;
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        this.add((Component)this.controlPanel, gbc);
    }

    private void setDefaultValues() {
        this.openSensorDS.setColor(Color.gray);
        this.closeSensorDS.setColor(Color.gray);
        this.filterEngagedSensorDS.setColor(Color.gray);
        this.errorDS.setColor(Color.gray);
        this.lockStatus.setText("UNKNOWN STATE");
        this.motionTimeoutLabel.setText("0.0");
        this.currentToOpenLabel.setText("0.0");
        this.currentToCloseLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.controllerPanel.resetPanel();
    }

    @Override
    public String toString() {
        if (this.latchName == null) {
            return "Latch";
        }
        return this.latchName;
    }

    public static void main(String[] argv) {
        AutochangerLatchPanel d = new AutochangerLatchPanel("myLatch");
        JFrame frame = new JFrame("Autochanger Latch Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLatch
    implements Runnable {
        private final StatusDataPublishedByAutochangerLatch s;

        public UpdateLatch(StatusDataPublishedByAutochangerLatch status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerLatchPanel.this.openSensorDS.updateColor(this.s.isUnlockSensorsInError(), this.s.getUnlockSensorOn());
            AutochangerLatchPanel.this.closeSensorDS.updateColor(this.s.isLockSensorsInError(), this.s.getLockSensorOn());
            AutochangerLatchPanel.this.filterEngagedSensorDS.updateColor(this.s.isFilterEngagedSensorsInError(), this.s.getFilterPresenceSensorOn());
            boolean inTravel = this.s.getLockStatus().equals(FcsEnumerations.LockStatus.INTRAVEL);
            boolean unknown = this.s.getLockStatus().equals(FcsEnumerations.LockStatus.UNKNOWN);
            if (this.s.isInError() || inTravel || unknown) {
                AutochangerLatchPanel.this.errorDS.setColor(this.s.getLockStatus().getColor());
                AutochangerLatchPanel.this.errorLabel.setText(this.s.getLockStatus().getText());
            } else {
                AutochangerLatchPanel.this.errorDS.setColor(FcsEnumerations.LockStatus.NOERROR.getColor());
                AutochangerLatchPanel.this.errorLabel.setText(FcsEnumerations.LockStatus.NOERROR.getText());
            }
            AutochangerLatchPanel.this.lockStatus.setText(this.s.getLockStatus().getText());
            AutochangerLatchPanel.this.lockStatus.setForeground(this.s.getLockStatus().getColor());
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;
        private final long timeout;

        public GuiInitialization(ConfigurationInfo configInfo, long timeout) {
            this.configInfo = configInfo;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerLatchPanel.this.latchName);
            FCSLOG.fine(() -> AutochangerLatchPanel.this.latchName + " configForName=" + configForName);
            AutochangerLatchPanel.this.motionTimeoutLabel.setText(Long.toString(this.timeout));
            String currentToOpenL = (String)configForName.get("currentToOpen");
            AutochangerLatchPanel.this.currentToOpenLabel.setText(currentToOpenL);
            AutochangerLatchPanel.this.currentToCloseLabel.setText("-" + currentToOpenL);
        }
    }
}

