/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SingleControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class ControllersViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger FCSLOG = Logger.getLogger(ControllersViewPanel.class.getName());
    private InterfaceGeneralGUI subs;
    private final String title = "Controllers Overview";
    private final List<String> errorList = new CopyOnWriteArrayList<String>();
    private JButton refreshAllButton;
    private JButton checkAllButton;
    private JLabel onlineFCSSubsystem;
    private SingleControllerPanel acTruckXMinusPanel;
    private SingleControllerPanel acTruckXPlusPanel;
    private SingleControllerPanel acLatchXMinusPanel;
    private SingleControllerPanel acLatchXPlusPanel;
    private SingleControllerPanel acOnlineClampXMinusPanel;
    private SingleControllerPanel acOnlineClampXPlusPanel;
    private SingleControllerPanel acOnlineClampYMinusPanel;
    private SingleControllerPanel carouselPanel;
    private SingleControllerPanel carouselClampXMinusPanel;
    private SingleControllerPanel carouselClampXPlusPanel;
    private SingleControllerPanel loaderHooksPanel;
    private SingleControllerPanel loaderCarrierPanel;
    private JTextArea errorInformation;
    private boolean hasAutochanger = false;
    private boolean hasCarousel = false;
    private boolean hasLoader = false;

    public ControllersViewPanel(InterfaceGeneralGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    private void refreshAllActionPerformed() {
        this.subs.sendCommand("publishData", 1000L);
    }

    private void checkAllActionPerformed() {
        this.subs.sendCommand("checkFaultForAllControllers", 1000L);
    }

    @Override
    public String toString() {
        return "Controllers Overview";
    }

    public void enableOnlineSubsystems(boolean hasCarousel, boolean hasAutochanger, boolean hasLoader) {
        this.hasAutochanger = hasAutochanger;
        this.hasCarousel = hasCarousel;
        this.hasLoader = hasLoader;
        this.onlineFCSSubsystem.setText("Online Subsystems seen at startup: " + (hasAutochanger ? "Autochanger " : "") + (hasCarousel ? " Carousel " : "") + (hasLoader ? " Loader" : ""));
        this.enableCarouselControllersPanelState(hasCarousel);
        this.enableAutochangerControllersPanelState(hasAutochanger);
        this.enableLoaderControllersPanelState(hasLoader);
    }

    public void enableCarouselControllersPanelState(boolean b) {
        this.carouselPanel.setEnabled(b);
        this.carouselClampXMinusPanel.setEnabled(b);
        this.carouselClampXPlusPanel.setEnabled(b);
    }

    public void enableAutochangerControllersPanelState(boolean b) {
        this.acTruckXMinusPanel.setEnabled(b);
        this.acTruckXPlusPanel.setEnabled(b);
        this.acLatchXMinusPanel.setEnabled(b);
        this.acLatchXPlusPanel.setEnabled(b);
        this.acOnlineClampXMinusPanel.setEnabled(b);
        this.acOnlineClampXPlusPanel.setEnabled(b);
        this.acOnlineClampYMinusPanel.setEnabled(b);
    }

    public void enableLoaderControllersPanelState(boolean b) {
        this.loaderHooksPanel.setEnabled(b);
        this.loaderCarrierPanel.setEnabled(b);
    }

    private void initComponents() {
        this.acTruckXMinusPanel = new SingleControllerPanel("Truck XMinus", "Autochanger", "canbus0/acTruckXminusController", this.subs, this, true);
        this.acTruckXPlusPanel = new SingleControllerPanel("Truck XPlus", "Autochanger", "canbus0/acTruckXplusController", this.subs, this, true);
        this.acLatchXMinusPanel = new SingleControllerPanel("Latch Xminus", "Autochanger", "canbus0/latchXminusController", this.subs, this, false);
        this.acLatchXPlusPanel = new SingleControllerPanel("Latch Xplus", "Autochanger", "canbus0/latchXplusController", this.subs, this, false);
        this.acOnlineClampXMinusPanel = new SingleControllerPanel("Online Clamp Xminus", "Autochanger", "canbus0/onlineClampXminusController", this.subs, this, true);
        this.acOnlineClampXPlusPanel = new SingleControllerPanel("Online Clamp Xplus", "Autochanger", "canbus0/onlineClampXplusController", this.subs, this, true);
        this.acOnlineClampYMinusPanel = new SingleControllerPanel("Online Clamp Yminus", "Autochanger", "canbus0/onlineClampYminusController", this.subs, this, true);
        this.carouselPanel = new SingleControllerPanel("Carousel", "Carousel", "canbus0/carouselController", this.subs, this, false);
        this.carouselClampXMinusPanel = new SingleControllerPanel("Clamp Xminus", "Carousel", "canbus0/clampXminusController", this.subs, this, false);
        this.carouselClampXPlusPanel = new SingleControllerPanel("Clamp Xplus", "Carousel", "canbus0/clampXplusController", this.subs, this, false);
        this.loaderHooksPanel = new SingleControllerPanel("Hooks", "Loader", "loader/hooksController", this.subs, this, false);
        this.loaderCarrierPanel = new SingleControllerPanel("Carrier", "Loader", "loader/carrierController", this.subs, this, false);
        JPanel contentPane = new JPanel(new GridLayout(3, 4, 5, 5));
        contentPane.add(this.carouselPanel);
        contentPane.add(this.acOnlineClampXMinusPanel);
        contentPane.add(this.acOnlineClampXPlusPanel);
        contentPane.add(this.acOnlineClampYMinusPanel);
        contentPane.add(this.carouselClampXMinusPanel);
        contentPane.add(this.acTruckXMinusPanel);
        contentPane.add(this.acTruckXPlusPanel);
        contentPane.add(this.loaderHooksPanel);
        contentPane.add(this.carouselClampXPlusPanel);
        contentPane.add(this.acLatchXMinusPanel);
        contentPane.add(this.acLatchXPlusPanel);
        contentPane.add(this.loaderCarrierPanel);
        JPanel commandPane = new JPanel();
        this.refreshAllButton = new JButton("Refresh all");
        commandPane.add(this.refreshAllButton);
        this.checkAllButton = new JButton("Check Fault for all");
        commandPane.add(this.checkAllButton);
        this.refreshAllButton.addActionListener(evt -> this.refreshAllActionPerformed());
        this.checkAllButton.addActionListener(evt -> this.checkAllActionPerformed());
        this.refreshAllButton.setToolTipText("Command: publishData");
        this.checkAllButton.setToolTipText("Command: checkFault");
        this.onlineFCSSubsystem = new JLabel("Online Subsystems: " + (this.hasAutochanger ? "Autochanger," : "") + (this.hasCarousel ? " Carousel," : "") + (this.hasLoader ? " Loader" : ""));
        commandPane.add(this.onlineFCSSubsystem);
        commandPane.add(contentPane);
        JPanel errorPane = new JPanel();
        this.errorInformation = new JTextArea(4, 60);
        this.errorInformation.setText("");
        this.errorInformation.setLineWrap(true);
        this.errorInformation.setWrapStyleWord(true);
        this.errorInformation.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.errorInformation, 20, 31);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        errorPane.add((Component)new JLabel("Current errors:"), gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        errorPane.add((Component)scrollPane, gbc);
        this.setBorder(Tools.getGeneralPanelTitle("Controllers Overview"));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)commandPane, gbc);
        ++gbc.gridy;
        this.add((Component)contentPane, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)errorPane, gbc);
    }

    public void updateFromStatusData(KeyValueData data) {
        switch (Tools.getShortComponentName(data.getKey())) {
            case "acTruckXminusController": {
                this.acTruckXMinusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "acTruckXplusController": {
                this.acTruckXPlusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "latchXminusController": {
                this.acLatchXMinusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "latchXplusController": {
                this.acLatchXPlusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampXminusController": {
                this.acOnlineClampXMinusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampXplusController": {
                this.acOnlineClampXPlusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampYminusController": {
                this.acOnlineClampYMinusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "carouselController": {
                this.carouselPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "hooksController": {
                this.loaderHooksPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "clampXminusController": {
                this.carouselClampXMinusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "clampXplusController": {
                this.carouselClampXPlusPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "carrierController": {
                this.loaderCarrierPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning(String.format("\t[ControllerView] %s not recognized!", Tools.getShortComponentName(data.getKey())));
            }
        }
    }

    public void updateErrorListing(String controllerName, int errorCode, String errorName) {
        String message = String.format("%-40s%-10s%s %n", controllerName, "0x" + Integer.toHexString(errorCode), errorName);
        this.errorList.add(message);
        this.errorInformation.append(message);
        FCSLOG.fine("[ControllersView] -- call to updateErrorListing from " + controllerName);
    }

    public void clearErrorListing(String controllerName) {
        if (this.errorList.removeIf(s -> s.startsWith(controllerName))) {
            this.errorInformation.setText("");
            for (String message : this.errorList) {
                this.errorInformation.append(message);
            }
        }
    }
}

