/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class VerticalTextComponent
extends JComponent {
    private static final Color col_loader = new Color(473404);
    private static final Color col_carousel = new Color(0x593959);
    private static final Color col_autochanger = new Color(8231073);
    private final String text;

    public VerticalTextComponent(String text) {
        this.text = text;
        this.setFont(new Font("Arial", 1, 12));
        this.setForeground(VerticalTextComponent.getSubsystemColor(text));
    }

    public static Color getSubsystemColor(String subsystem) {
        switch (subsystem.toLowerCase()) {
            case "carousel": {
                return col_carousel;
            }
            case "autochanger": {
                return col_autochanger;
            }
            case "loader": {
                return col_loader;
            }
        }
        return Color.BLACK;
    }

    private Dimension calculatePreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.getHeight() + 5;
        int height = fm.stringWidth(this.text);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.calculatePreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        int x = this.getWidth() / 2 + 5;
        int y = this.getHeight() - 5;
        Graphics2D g2d = (Graphics2D)g;
        g2d.rotate(-1.5707963267948966, x, y);
        g2d.drawString(this.text, x, y);
    }
}

