/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.config.ConfigurationParameterTaggedValue;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;

public class CategoryDataChain {
    private static final Logger LOG = Logger.getLogger(CategoryDataChain.class.getName());
    private final List<SingleCategoryTag> singleCategoryTagsChain = new CopyOnWriteArrayList<SingleCategoryTag>();
    private final Map<SingleCategoryTag, Map<String, ConfigurationParameterTaggedValue>> tagDataMap = new ConcurrentHashMap<SingleCategoryTag, Map<String, ConfigurationParameterTaggedValue>>();
    private final Map<SingleCategoryTag, SingleCategoryTagData> singleCategoryTagDataMap = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
    private final Map<String, ConfigurationParameterTaggedValue> taggedValues = new ConcurrentHashMap<String, ConfigurationParameterTaggedValue>();
    private final String category;

    public CategoryDataChain(String category) {
        this.category = category;
    }

    public void addSingleCategoryTagData(SingleCategoryTagData tagData, AgentInfo ai) {
        if (!tagData.getSingleCategoryTag().getCategory().equals(this.category)) {
            throw new IllegalArgumentException("Incompatible category \"" + tagData.getSingleCategoryTag().getCategory() + "\" cannot be added to category data chain for \"" + this.category + "\"");
        }
        SingleCategoryTag singleTag = tagData.getSingleCategoryTag();
        ConcurrentHashMap<String, ConfigurationParameterTaggedValue> taggedData = new ConcurrentHashMap<String, ConfigurationParameterTaggedValue>();
        Map<String, String> inputData = tagData.getConfigurationDataForAgent(ai);
        for (Map.Entry<String, String> e : inputData.entrySet()) {
            String path = e.getKey();
            taggedData.put(path, new ConfigurationParameterTaggedValue(path, e.getValue(), singleTag));
        }
        this.singleCategoryTagDataMap.put(singleTag, tagData);
        this.addTaggedDataForSingleCategoryTag(singleTag, taggedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaggedDataForSingleCategoryTag(SingleCategoryTag singleTag, Map<String, ConfigurationParameterTaggedValue> taggedData) {
        Map<String, ConfigurationParameterTaggedValue> map = this.taggedValues;
        synchronized (map) {
            int indexOfExistingData = this.singleCategoryTagsChain.indexOf(singleTag);
            if (indexOfExistingData >= 0) {
                this.singleCategoryTagsChain.remove(indexOfExistingData);
                this.singleCategoryTagsChain.add(indexOfExistingData, singleTag);
            } else {
                this.singleCategoryTagsChain.add(singleTag);
            }
            this.tagDataMap.put(singleTag, taggedData);
            this.taggedValues.clear();
        }
    }

    public String getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ConfigurationParameterTaggedValue> getConfigurationParameterTaggedValues() {
        Map<String, ConfigurationParameterTaggedValue> map = this.taggedValues;
        synchronized (map) {
            if (this.taggedValues.isEmpty()) {
                for (SingleCategoryTag singleTag : this.singleCategoryTagsChain) {
                    this.taggedValues.putAll(this.tagDataMap.get(singleTag));
                }
            }
            return new HashMap<String, ConfigurationParameterTaggedValue>(this.taggedValues);
        }
    }

    public List<String> getConfigurationParameterValueList(String path) {
        ArrayList<String> res = new ArrayList<String>();
        for (SingleCategoryTag singleTag : this.singleCategoryTagsChain) {
            ConfigurationParameterTaggedValue cp = this.tagDataMap.get(singleTag).get(path);
            if (cp == null) continue;
            res.add(cp.getParameterValue());
        }
        return res;
    }

    public List<SingleCategoryTag> getSingleCategoryTagList() {
        return new ArrayList<SingleCategoryTag>(this.singleCategoryTagsChain);
    }

    public SingleCategoryTag getTopMostCategoryTag() {
        return this.singleCategoryTagsChain.get(this.singleCategoryTagsChain.size() - 1);
    }

    public SingleCategoryTagData getSingleCategoryTagData(SingleCategoryTag tag) {
        return this.singleCategoryTagDataMap.get(tag);
    }

    public boolean needsSaving() {
        for (SingleCategoryTag singleTag : this.singleCategoryTagsChain) {
            if (!this.getSingleCategoryTagData(singleTag).needsSaving()) continue;
            return true;
        }
        return false;
    }
}

