/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerLatchPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTwoLatchesPanel
extends JPanel {
    private static final long serialVersionUID = -6970922329469696468L;
    private static final Logger FCSLOG = Logger.getLogger(AutochangerTwoLatchesPanel.class.getName());
    private InterfaceAutochangerGUI subs;
    private final JLabel latchesState = new JLabel();
    private final JLabel latchesStateLabel = new JLabel("LATCHES STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinusLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final AutochangerLatchPanel latchXminusPanel = new AutochangerLatchPanel("autochanger/latches/latchXminus");
    private final AutochangerLatchPanel latchXplusPanel = new AutochangerLatchPanel("autochanger/latches/latchXplus");
    private final FilterPanel filterPanel = new FilterPanel();
    private JButton closeLatchesButton;
    private JButton openLatchesButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;

    public AutochangerTwoLatchesPanel() {
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
        this.latchXminusPanel.setSubsystem(subs);
        this.latchXplusPanel.setSubsystem(subs);
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateLatch(String latchName, StatusDataPublishedByAutochangerLatch s) {
        switch (latchName) {
            case "latchXminus": {
                this.latchXminusPanel.updateLatch(s);
                break;
            }
            case "latchXplus": {
                this.latchXplusPanel.updateLatch(s);
                break;
            }
            default: {
                FCSLOG.severe("Unknown latch name. Can't update acLatchesPanel.");
            }
        }
    }

    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    public void updateController(String controllerName, StatusDataPublishedByEPOSController s) {
        if ("latchXminusController".equals(controllerName)) {
            this.latchXminusPanel.updateController(s);
        } else if ("latchXplusController".equals(controllerName)) {
            this.latchXplusPanel.updateController(s);
        }
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void closeLatchesButtonActionPerformed(ActionEvent evt) {
        this.subs.closeLatches();
    }

    private void openLatchesButtonActionPerformed(ActionEvent evt) {
        this.subs.openLatches();
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void initComponents() {
        this.setDefaultValues();
        Font xFont = new Font("Tahoma", 1, 18);
        this.xMinusLabel.setFont(xFont);
        this.xMinusLabel2.setFont(xFont);
        this.xPlusLabel2.setFont(xFont);
        this.xPlusLabel.setFont(xFont);
        JPanel latchesPanel = new JPanel();
        JPanel latchesStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.filterPanel.setSize(150);
        this.updateStateWithSensorsButton = new JButton("Read sensors and update state");
        this.openLatchesButton = new JButton("Open Latches");
        this.closeLatchesButton = new JButton("Close Latches");
        this.abortButton = new JButton("Abort");
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsButtonActionPerformed(evt));
        this.closeLatchesButton.addActionListener(evt -> this.closeLatchesButtonActionPerformed(evt));
        this.openLatchesButton.addActionListener(evt -> this.openLatchesButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortButtonActionPerformed(evt));
        this.latchesState.setFont(Tools.BIG_FONT);
        this.latchesState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        latchesStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        latchesStatePanel.add((Component)this.latchesStateLabel, gbc2);
        ++gbc2.gridx;
        latchesStatePanel.add((Component)this.latchesState, gbc2);
        latchesPanel.setLayout(new GridBagLayout());
        latchesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "Latches State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.latchXminusPanel.setLatchName("latchXminus");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        latchesPanel.add((Component)this.latchXminusPanel, gbc1);
        this.latchXplusPanel.setLatchName("latchXplus");
        ++gbc1.gridx;
        latchesPanel.add((Component)this.latchXplusPanel, gbc1);
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.openLatchesButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.closeLatchesButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.abortButton, gbc3);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER LATCHES"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.xMinusLabel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        this.add((Component)latchesStatePanel, gbc);
        ++gbc.gridy;
        this.add((Component)latchesPanel, gbc);
        gbc.insets = Tools.insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)controlPanel, gbc);
    }

    private void setDefaultValues() {
        this.filterPanel.setColor(Color.gray);
        this.latchesState.setText("UNKNOWN STATE");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.latchXminusPanel.resetPanel();
        this.latchXplusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "Latches";
    }

    public static void main(String[] argv) {
        AutochangerTwoLatchesPanel d = new AutochangerTwoLatchesPanel();
        JFrame frame = new JFrame("Autochanger Latches Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLatches
    implements Runnable {
        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerTwoLatchesPanel.this.latchesState.setText(this.s.getLockStatus().toString());
            AutochangerTwoLatchesPanel.this.latchesState.setForeground(this.s.getLockStatus().getColor());
            AutochangerTwoLatchesPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.ENGAGED), this.s.getFilterName(), this.s.getFilterId());
            if (this.s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                AutochangerTwoLatchesPanel.this.filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForLatchXminus = this.configInfo.getCurrentValuesFor("autochanger/latches/latchXminus");
            long latchXminusTimeout = Long.parseLong((String)configForLatchXminus.get("timeoutForLatchMotion"));
            Map configForLatchXplus = this.configInfo.getCurrentValuesFor("autochanger/latches/latchXplus");
            long latchXplusTimeout = Long.parseLong((String)configForLatchXplus.get("timeoutForLatchMotion"));
            AutochangerTwoLatchesPanel.this.subs.setTimeoutForLatchesMotion(Math.max(latchXminusTimeout, latchXplusTimeout));
            AutochangerTwoLatchesPanel.this.latchXminusPanel.initializeGui(this.configInfo, latchXminusTimeout);
            AutochangerTwoLatchesPanel.this.latchXplusPanel.initializeGui(this.configInfo, latchXplusTimeout);
        }
    }
}

