/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.Datas;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.messaging.AgentPresenceListener;

@Plugin(name="LSST Rest Service Plugin", id="rest-service", description="Plugin that handles connection to the REST server.")
public class LsstRestService
extends ConsolePlugin {
    public static final String FROM_BUS_PROPERTY = "fromBus";
    public static final String HOST_PROPERTY = "server";
    public static final String PORT_PROPERTY = "port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "connectOnStartup";
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private Client client;
    private WebTarget server;
    private boolean refreshInProgress;
    private boolean refreshRequested;
    private long lastRefresh;
    private AgentPresenceListener agentsListener;

    @Override
    public void initialize() {
        this.getServices().addProperty(FROM_BUS_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${fromBus} Use REST server found on CCS buses.");
        this.getServices().addProperty(HOST_PROPERTY, "localhost");
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Server: ${server#history=5}");
        this.getServices().addProperty(PORT_PROPERTY, 8080);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Port: ${port}");
        this.getServices().addProperty(CONNECT_ON_STARTUP_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${connectOnStartup} Connect on startup.");
        this.getConsole().getLogger().setLevel(Level.FINE);
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(CONNECT_ON_STARTUP_PROPERTY)).booleanValue()) {
            this.refreshConnection(false);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        Set<String> keys = changes.keySet();
        if (keys.contains(HOST_PROPERTY) || keys.contains(PORT_PROPERTY) || keys.contains(FROM_BUS_PROPERTY)) {
            this.refreshConnection(true);
        }
    }

    public synchronized void refreshConnection(boolean queue) {
        if (this.refreshInProgress) {
            if (queue) {
                this.refreshRequested = true;
            }
        } else {
            this.refreshRequested = false;
            this.refreshInProgress = true;
            this.lastRefresh = System.currentTimeMillis();
            Thread t = new Thread(this::connect, "REST Connector");
            t.setDaemon(true);
            t.start();
        }
    }

    private void checkConnection(WebTarget servak) {
        if (servak != null) {
            try {
                servak.request().head();
            }
            catch (RuntimeException x) {
                this.refreshConnection(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        String url = null;
        WebTarget servak = null;
        try {
            url = this.getURL();
            if (url != null) {
                this.getConsole().getLogger().fine((Object)("Connecting to REST server " + url));
                servak = this.client.target(url).path("dataserver");
                servak.request().head();
                this.getConsole().getLogger().fine((Object)"REST server connection successful.");
            }
        }
        catch (RuntimeException e) {
            servak = null;
            this.getConsole().getLogger().warn((Object)("Unable to connect to REST server at " + url), (Throwable)e);
        }
        finally {
            boolean repeat = false;
            LsstRestService lsstRestService = this;
            synchronized (lsstRestService) {
                if (this.refreshRequested) {
                    repeat = true;
                    this.refreshRequested = false;
                } else {
                    this.notifyAll();
                    this.refreshInProgress = false;
                    if (this.server != servak) {
                        this.server = servak;
                        this.fireEvent();
                    }
                }
            }
            if (repeat) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL() {
        AgentPresenceListener oldListener;
        LsstRestService lsstRestService = this;
        synchronized (lsstRestService) {
            oldListener = this.agentsListener;
            if (this.client == null) {
                this.client = ClientBuilder.newClient();
            }
        }
        if (oldListener != null) {
            this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(oldListener);
        }
        String url = null;
        if (((Boolean)this.getServices().getProperty(FROM_BUS_PROPERTY)).booleanValue()) {
            String agentName = null;
            for (AgentInfo agent : this.getConsole().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                String host = agent.getAgentProperty("rest-service-addr");
                String port = agent.getAgentProperty("rest-service-port");
                String entryPoint = agent.getAgentProperty("rest-service-entrypoint");
                url = String.format("http://%s:%d%s", host, Integer.valueOf(port), entryPoint);
                agentName = agent.getName();
                break;
            }
            LsstRestService lsstRestService2 = this;
            synchronized (lsstRestService2) {
                this.agentsListener = agentName == null ? new AgentConnectListener() : new AgentDisconnectListener(agentName);
            }
            this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentsListener);
        } else {
            String host = null;
            try {
                host = this.getServices().getProperty(HOST_PROPERTY).toString();
                int port = (Integer)this.getServices().getProperty(PORT_PROPERTY);
                url = String.format("http://%s:%d/rest/data", host, port);
            }
            catch (RuntimeException x) {
                this.getConsole().getLogger().warn((Object)("Invalid server " + host + " or port " + this.getServices().getProperty(PORT_PROPERTY)));
                throw x;
            }
        }
        return url;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> listener.stateChanged(event));
        });
    }

    public DataChannel.DataChannelList getTrendingList(long begin) {
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("listchannels");
            if (begin > 0L) {
                resource = resource.queryParam("maxIdleSeconds", new Object[]{String.valueOf(begin)});
            }
            return (DataChannel.DataChannelList)resource.request(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public DataChannel.DataChannelList getStateList(long begin) {
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("liststates");
            if (begin > 0L) {
                resource = resource.queryParam("maxIdleSeconds", new Object[]{String.valueOf(begin)});
            }
            return (DataChannel.DataChannelList)resource.request(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public StateInfo.StateInfoList getStateInfo(String agent) {
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("statesinfo").path(agent);
            return (StateInfo.StateInfoList)resource.request(new String[]{"text/xml"}).get(StateInfo.StateInfoList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public TrendingResult[] getTrendingData(long begin, long end, String flavor, int nBins, String ... paths) {
        WebTarget resource = this.getServer(false);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("data/search");
            resource = resource.queryParam("t1", new Object[]{String.valueOf(begin)}).queryParam("t2", new Object[]{String.valueOf(end)});
            if (flavor != null) {
                resource = resource.queryParam("flavor", new Object[]{flavor});
            }
            if (nBins > 0) {
                resource = resource.queryParam("n", new Object[]{Integer.toString(nBins)});
            }
            for (String path : paths) {
                resource = resource.queryParam("path", new Object[]{path});
            }
            Invocation.Builder a = resource.request(new String[]{"text/xml"});
            Datas datas = (Datas)a.get(Datas.class);
            Data[] dd = datas.getDataArray();
            if (dd.length != paths.length) {
                return null;
            }
            TrendingResult[] out = new TrendingResult[dd.length];
            for (int i = 0; i < dd.length; ++i) {
                out[i] = dd[i] == null ? null : dd[i].getTrendingResult();
            }
            return out;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
        catch (RuntimeException x) {
            return null;
        }
    }

    public List<StateChange> getStateTransitions(long begin, long end, String agent, Collection<String> components, Collection<String> states) {
        WebTarget resource = this.getServer(false);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("statechanges/" + agent);
            resource = resource.queryParam("t1", new Object[]{String.valueOf(begin)}).queryParam("t2", new Object[]{String.valueOf(end)});
            if (components != null) {
                for (String c : components) {
                    resource = resource.queryParam("component", new Object[]{c});
                }
            }
            if (states != null) {
                for (String s : states) {
                    resource = resource.queryParam("state", new Object[]{s});
                }
            }
            Invocation.Builder a = resource.request(new String[]{"text/xml"});
            return ((StateChange.StateChangesList)a.get(StateChange.StateChangesList.class)).list;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
        catch (RuntimeException x) {
            return null;
        }
    }

    private synchronized WebTarget getServer(boolean retry) {
        while (this.refreshInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException x) {
                return null;
            }
        }
        if (this.server == null && (retry || System.currentTimeMillis() - this.lastRefresh > 300000L)) {
            this.refreshConnection(true);
            return this.getServer(false);
        }
        return this.server;
    }

    private class AgentDisconnectListener
    implements AgentPresenceListener {
        private final String agent;

        AgentDisconnectListener(String agent) {
            this.agent = agent;
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo agentInfo : agents) {
                if (!agentInfo.getName().equals(this.agent)) continue;
                LsstRestService.this.refreshConnection(true);
                break;
            }
        }
    }

    private class AgentConnectListener
    implements AgentPresenceListener {
        private AgentConnectListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo agent : agents) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                LsstRestService.this.refreshConnection(true);
            }
        }
    }
}

