/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.lock;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;

@Plugin(name="Lock Management Test Plugin", id="lock-test", description="Test for lock management.", loadAtStart=false)
public class LockPlugin
extends ConsolePlugin {
    @Override
    public void initialize() {
        ((AgentLockService)Console.getConsole().getAgentService(AgentLockService.class)).addAgentLockUpdateListener(new AgentLockService.AgentLockUpdateListener(){

            public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
                System.out.println("AgentLockUpdateListener: Held: agent " + agentName + ", lock " + AgentLockInfo.asString((AgentLock)lock));
            }

            public void onAgentLockUpdate(String agentName, String owner, AgentLock lock) {
                System.out.println("AgentLockUpdateListener: Self: agent " + agentName + ", owner " + owner + ", lock " + AgentLockInfo.asString((AgentLock)lock));
            }

            public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
                System.out.println("AgentLockUpdateListener: Global: agent " + AgentLockInfo.asString((AgentLock)lock));
            }

            public void onAgentLevelChange(String agentName, int level) {
                System.out.println("AgentLockUpdateListener: Level: agent " + agentName + ", level " + level);
            }
        });
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo ai : agents) {
                    if (!ai.getName().equals("demo-subsystem")) continue;
                    AbstractAction act = new AbstractAction("Send level 1 command"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                CommandService.getService().sendEncoded("demo-subsystem", "testUserQuery1", new String[0]);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    };
                    LockPlugin.this.getServices().addMenu(act, "CCS Subsystems", ai.getName());
                }
            }

            public void disconnected(AgentInfo ... agents) {
            }
        });
    }
}

