/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FilterListPanel
extends JPanel {
    private static final long serialVersionUID = 2654131875576434801L;
    private InterfaceCarouselGUI subs;
    private JTable filterTable;
    private JScrollPane jScrollPane;

    public FilterListPanel() {
        this.initComponents();
    }

    public void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo, List<String> filterNameList) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo, filterNameList));
    }

    public void updateFilterListPanel(String filterName, String socketName) {
        SwingUtilities.invokeLater(new UpdateFilterListPanel(filterName, socketName));
    }

    public void resetPanel() {
        Tools.resetTable(this.filterTable);
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.filterTable = new JTable();
        this.filterTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Filter ID", "Weight", "Family", "Socket number"}){
            private static final long serialVersionUID = 1L;
            private Class[] types;
            private boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Double.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.filterTable.setName("filterTable");
        for (int i = 0; i < 5; ++i) {
            TableColumn column = this.filterTable.getColumnModel().getColumn(i);
            if (i != 0 && i != 4) continue;
            column.setPreferredWidth(100);
        }
        this.jScrollPane.setViewportView(this.filterTable);
        this.setBorder(BorderFactory.createLineBorder(Color.YELLOW));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jScrollPane, gbc);
    }

    private void checkFiltersLocationActionPerformed(ActionEvent evt) {
        this.subs.checkFiltersLocation();
    }

    @Override
    public String toString() {
        return "Filter list";
    }

    public static void main(String[] argv) {
        FilterListPanel p = new FilterListPanel();
        JFrame frame = new JFrame("FILTERS");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateFilterListPanel
    implements Runnable {
        private final String filterName;
        private final String socketName;

        public UpdateFilterListPanel(String filterName, String socketName) {
            this.filterName = filterName;
            this.socketName = socketName;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel)FilterListPanel.this.filterTable.getModel();
            int rowNB = filterTableModel.getRowCount();
            for (int i = 0; i < rowNB; ++i) {
                if (!filterTableModel.getValueAt(i, 0).equals(this.filterName)) continue;
                filterTableModel.setValueAt(this.socketName, i, 4);
            }
            filterTableModel.fireTableDataChanged();
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;
        private final List<String> filterNamesList;

        public GuiInitialization(ConfigurationInfo configInfo, List<String> filterNamesList) {
            this.configInfo = configInfo;
            this.filterNamesList = new ArrayList<String>();
            this.filterNamesList.addAll(filterNamesList);
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel)FilterListPanel.this.filterTable.getModel();
            for (String filterName : this.filterNamesList) {
                Map config = this.configInfo.getCurrentValuesFor("filterManager/" + filterName);
                Object[] tab = new Object[]{filterName, Integer.parseInt((String)config.get("filterID")), Double.parseDouble((String)config.get("weight")), config.get("family"), "UNKNOWN"};
                filterTableModel.addRow(tab);
            }
            filterTableModel.fireTableDataChanged();
        }
    }
}

