
package org.lsst.ccs.subsystems.fcs.loader.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_CARRIER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_CLAMP_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceLoaderGUI extends InterfaceGeneralGUI {

    long getLoGoToHandoffTimeout();

    long getLoGoToStorageTimeout();

    long getLoGoToEngagedTimeout();

    long getOpenHooksTimeout();

    long getCloseHooksTimeout();

    long getClampHooksTimeout();

    void setLoGoToHandoffTimeout(int aInt);

    void setLoGoToStorageTimeout(int aInt);

    void setLoGoToEngagedTimeout(int toInt);

    void setClampHooksTimeout(long clampHooksTimeout);

    void setCloseHooksTimeout(long closeHooksTimeout);

    void setOpenHooksTimeout(long openHooksTimeout);

    default void loLoadFilter() {
        System.out.println("loadFilter with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("loadFilter", getLoGoToHandoffTimeout());
    }

    default void loUnloadFilter() {
        System.out.println("unloadFilter with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Unloading filter in camera");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("unloadFilter", getLoGoToHandoffTimeout());
    }

    default void loLoadFilterIntoStorageBox() {
        System.out.println("loadFilterIntoStorageBox with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Loading filter in storage box");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("loadFilterIntoStorageBox", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loUnloadFilterFromStorageBox() {
        System.out.println("unloadFilterFromStorageBox with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Unloading filter from storage box");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("unloadFilterFromStorageBox", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loMoveFilterStoH() {
        System.out.println("moveFilterToHandoff with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("moveFilterToHandoff");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("moveFilterToHandoff", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loMoveFilterHtoS() {
        System.out.println("moveFilterToStorage with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("moveFilterToStorage");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("moveFilterToStorage", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loMoveEmptyToHandClose() {
        System.out.println("moveEmptyToHandoffAndClose with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("moveEmptyToHandoffAndClose");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("moveEmptyToHandoffAndClose", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loOpenClampAndMoveEmptyToS() {
        System.out.println("openClampAndMoveEmptyToStorage with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("openClampAndMoveEmptyToStorage");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("openClampAndMoveEmptyToStorage", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loGoToHandOff() {
        FCSLOG.info("Carrier going to Handoff Position");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("goToHandOff", getLoGoToHandoffTimeout(), LOADER_CARRIER_NAME);
    }

    default void loGoToEngaged() {
        FCSLOG.info("Carrier going to Engaged Position");
        FCSLOG.info("/timeout=" + getLoGoToEngagedTimeout());
        sendCommand("goToEngaged", getLoGoToEngagedTimeout(), LOADER_CARRIER_NAME);
    }

    default void loGoToStorage() {
        FCSLOG.info("Carrier going to Storage Position");
        FCSLOG.info("/timeout=" + getLoGoToStorageTimeout());
        sendCommand("goToStorage", getLoGoToStorageTimeout(), LOADER_CARRIER_NAME);
    }

    default void loUpdateCarrierPosition() {
        System.out.println("updateCarrierPosition with UPDATE_POSITION_TIMEOUT=" + READ_CONTROLLER_TIMEOUT);
        FCSLOG.info("Updating carrier position");
        FCSLOG.info("/timeout=" + READ_CONTROLLER_TIMEOUT);
        sendCommand("updatePosition", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }

    /* clamp commands */
    default void loClampHooks() {
        FCSLOG.info("Clamping Hooks");
        FCSLOG.info("/timeout=" + getClampHooksTimeout());
        sendCommand("clamp", getClampHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loCloseHooks() {
        FCSLOG.info("Closing Hooks");
        System.out.println("/timeout=" + getCloseHooksTimeout());
        sendCommand("close", getCloseHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loUnclampHooks() {
        FCSLOG.info("Unclamping Hooks");
        FCSLOG.info("/timeout=" + getClampHooksTimeout());
        sendCommand("unclamp", getClampHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loOpenHooks() {
        FCSLOG.info("Opening Hooks");
        FCSLOG.info("/timeout=" + getOpenHooksTimeout());
        sendCommand("open", getOpenHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loClampHoming() {
        FCSLOG.info("Clamp homing");
        FCSLOG.info("/timeout=" + getOpenHooksTimeout());
        sendCommand("homing", getOpenHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void setLoSlowMode() {
        FCSLOG.info("Loader Carrier entering slow mode");
        sendCommand("setSlowMode", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }

    default void setLoFastMode() {
        FCSLOG.info("Loader Carrier entering fast mode");
        sendCommand("setFastMode", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }




}
