
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterReadinessState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterState;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This panel displays the subsystem state and some information specific to the
 * subsystem.
 *
 * @author virieux
 */
public class SubsystemPanel extends JPanel {
    private static final long serialVersionUID = -5966882812912397723L;
    private static final String UNKNOWN = "UNKNOWN";

    private String title;

    private GeneralGUI subs;

    //state panel
    private final JPanel subsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JLabel controlRealHardwareLabel = new JLabel("unknown hardware type");
    private final JLabel phLabel = new JLabel("PhaseState");
    private final JLabel opLabel = new JLabel("OperationalState");
    private final JLabel coLabel = new JLabel("CommandState");
    private final JLabel alLabel = new JLabel("AlertState");
    private final JLabel phaseStateLabel = new JLabel(PhaseState.OFF_LINE.toString());
    private final JLabel operationalStateLabel = new JLabel(UNKNOWN);
    private final JLabel commandStateLabel = new JLabel(UNKNOWN);
    private final JLabel alarmStateLabel = new JLabel(UNKNOWN);
    
    //FCS specific State
    private final JPanel fcsStatePanel = new JPanel();
    private final JLabel subsystemFcsStateLabel = new JLabel(UNKNOWN);
    private final JLabel hardwareStateLabel = new JLabel(UNKNOWN);

    //control panel    
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton abortButton = new JButton("Abort");
    private final JButton shutdownButton = new JButton("Shutdown FCS");

    /**
     * A Runnable class to initialize the SubsystemPanel from the configuration
     * data.
     */
    @Deprecated
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            /** Initialize the timeouts from data stored in configInfo*/
            
        }
    }
    
    /** 
     * A Runnable to update this panel from data published on the status bus.
     */
    private class UpdateSubsystemPanel implements Runnable {

        private final StateBundle bState;

        public UpdateSubsystemPanel(StateBundle state) {
            this.bState = state;
        }

        @Override
        public void run() {
            //state panel
            phaseStateLabel.setText(bState.getState(PhaseState.class).name());
            operationalStateLabel.setText(bState.getState(OperationalState.class).name());
            commandStateLabel.setText(bState.getState(CommandState.class).name());
            alarmStateLabel.setText(bState.getState(AlertState.class).name());
            if (bState.getState(FilterState.class) == null) {
                subsystemFcsStateLabel.setText(UNKNOWN);
                hardwareStateLabel.setText(UNKNOWN);
            } else {
                subsystemFcsStateLabel.setText(bState.getState(FilterState.class).name());
                hardwareStateLabel.setText(bState.getState(FilterReadinessState.class).name());
            }
            
            
            Color bgColor = Color.gray;
            
            /* BackGroung color for Subsystem State Panel*/
            if (bState.isInState(PhaseState.INITIALIZING)) {
                bgColor = Color.orange;
            } else if (bState.isInState(PhaseState.OFF_LINE) || bState.isInState(PhaseState.CLOSING)) {
                bgColor = Color.GRAY;
            } else if (bState.isInState(OperationalState.ENGINEERING_FAULT)) {
                bgColor = Color.RED;
            } else if (bState.isInState(OperationalState.ENGINEERING_OK)) {
                bgColor = Color.YELLOW;
            } else if (bState.isInState(OperationalState.NORMAL)) {
                bgColor = Color.GREEN;
            }
            subsStatePanel.setBackground(bgColor);
            
            /* color for FilterState Label*/
            if (bState.isInState(FilterState.READY)) {
                subsystemFcsStateLabel.setForeground(greenColor);
            } else if (bState.isInState(FilterState.CAN_DEVICES_BOOTING)) {
                subsystemFcsStateLabel.setForeground(Color.RED);
            } else {
                subsystemFcsStateLabel.setForeground(Color.gray);
            }
            
            /* color for Hardware State Label*/
            if (bState.isInState(FilterReadinessState.READY)) {
                hardwareStateLabel.setForeground(greenColor);
            } else if (bState.isInState(FilterReadinessState.NOT_READY)) {
                hardwareStateLabel.setForeground(Color.RED);
            } else {
                hardwareStateLabel.setForeground(Color.GRAY);
            }
            
        }
    }

    /**
     * Creates a new SystemPanel with a title.
     * @param title 
     */
    public SubsystemPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    /**
     * To initialize the subsytem for this SubsystemPanel.
     * @param newSubs 
     */
    public void setSubsystem(GeneralGUI newSubs) {
        this.subs = newSubs;
        
        /** To display the name of the subsystem on the border of the SubsystemPanel.*/
        this.title = newSubs.destination;
    }
    
    

    public void setcontrolRealHardwareLabelText(String atext) {
        this.controlRealHardwareLabel.setText(atext);
    }

    @Deprecated
    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateState(StateBundle state) {
        SwingUtilities.invokeLater(new UpdateSubsystemPanel(state));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //Subsystem State Panel
        controlRealHardwareLabel.setFont(BIG_FONT); // NOI18N
        phaseStateLabel.setFont(BIG_FONT);
        operationalStateLabel.setFont(BIG_FONT);
        commandStateLabel.setFont(BIG_FONT);
        alarmStateLabel.setFont(BIG_FONT);

        subsStatePanel.setBackground(Color.GRAY);
        subsStatePanel.setPreferredSize(new Dimension(600, 50));
        subsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.anchor = GridBagConstraints.LINE_START;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.CENTER;
        subsStatePanel.add(phLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(opLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(coLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(alLabel, gbc0);
        gbc0.gridx = 0;
        gbc0.gridy = 1;
        subsStatePanel.add(phaseStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(operationalStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(commandStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(alarmStateLabel, gbc0);

        //end Subsystem State Panel
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsActionPerformed(evt);
        });

        abortButton.addActionListener((ActionEvent evt) -> {
            abortActionPerformed(evt);
        });

        shutdownButton.addActionListener((ActionEvent evt) -> {
            shutdownActionPerformed(evt);
        });

        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc1);
        gbc1.gridy++;
        controlPanel.add(abortButton, gbc1);
        gbc1.gridy++;
        controlPanel.add(shutdownButton, gbc1);
        /**
         ******************************************************************************
         ** end of Control Panel
         * *****************************************************************************
         */
        
        /**************************/
        /* FCS State  Panel       */
        /**************************/
        fcsStatePanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        fcsStatePanel.setLayout(new GridBagLayout());
        fcsStatePanel.setFont(BIG_FONT);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0; 
        gbc2.anchor = GridBagConstraints.LINE_START;
        fcsStatePanel.add(new JLabel("FCS State :"), gbc2);
        gbc2.gridy++; 
        fcsStatePanel.add(new JLabel("Hardware State :"), gbc2);        
        gbc2.anchor = GridBagConstraints.LINE_END;
        gbc2.gridx = 1;
        gbc2.gridy = 0;
        subsystemFcsStateLabel.setFont(BIG_FONT);
        fcsStatePanel.add(subsystemFcsStateLabel, gbc2);
        gbc2.gridy++;
        hardwareStateLabel.setFont(BIG_FONT);
        fcsStatePanel.add(hardwareStateLabel, gbc2);
        /*************************/
        /* end of FCS State Panel*/
        /*************************/

        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        add(subsStatePanel, gbc);
        gbc.gridwidth = 1;
        gbc.gridy++;
        add(controlRealHardwareLabel, gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        gbc.fill = GridBagConstraints.BOTH;
        add(fcsStatePanel,gbc);
        gbc.anchor = GridBagConstraints.NORTHWEST;
        
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(controlPanel, gbc);
        //end Whole Panel

    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        subs.updateStateWithSensors();
    }


    private void abortActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    private void shutdownActionPerformed(ActionEvent evt) {
        System.out.println("About to shutdown subs.....");
        subs.shutdownMyDestinationSubsystem();
    }
    

    public static void main(String[] argv) {

        SubsystemPanel d = new SubsystemPanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
