package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;

/**
 *
 * @author virieux
 */
public class RectangleSwitch extends JComponent {
    
    private String sensorName;
    
    private int width = 60;
    private int height = width * 4 / 5;
    
    private Color color = new Color(0, 153, 0);
    
    /**
     * Creates new form RectangleSwitch
     */
    public RectangleSwitch() {
        super.setPreferredSize(new Dimension(width, height));
    }

    public RectangleSwitch(String sensorName) {
        super.setPreferredSize(new Dimension(width, height));
        this.sensorName = sensorName;
    }
    
    
    
    /**
     * Change the size of the RectangleSwitch
     *
     * @param width
     */
    public void setWidth(int width) {
        this.width = width;
        this.height = width * 4 / 5;
        super.setPreferredSize(new Dimension(width, height));
        repaint();
    }
    
    public void setColor(Color c) {
        this.color = c;
        repaint();
    }

    /**
     * updates color of a rectangle switch Uses when a rectangle switch
     * represents a sensors.     * If the sensor is in error, color is set to RED,
     * If sensor is not in error, and its value is 1, color is set to GREEN,
     * if its value is zero it's set to GRAY.
     *
     * @param sensorInError
     * @param sensorValue
     */
    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
                setColor(Color.RED);
        } else {
            setColor(sensorValue ? greenColor : Color.gray);
        }
    }
    
    /**
     * Fetch sensor value by its name in a list of sensors (key, value) and set color GREEN 
     * if value is 1 or set color GRAY if value is 0.
     *
     * @param sMap sMap List of {key, value} where key is a sensor name, value
     * is the value of the sensor.
     */
    public void updateColorGreenGray(Map<String, Serializable> sMap) {
        if (sMap.containsKey(sensorName)) {
            /* set color GREEN if sensor value is equal to 1 */
            setColor(1 == (int) sMap.get(sensorName) ? Color.GREEN : Color.gray);
        }
    }
    
    /**
     * Fetch sensor value by its name in a list of sensors (key, value) and set color GRAY
     * if value is 1 or set color GREEN if value is 0.
     *
     * @param sMap sMap List of {key, value} where key is a sensor name, value
     * is the value of the sensor.
     */
    public void updateColorGrayGreen(Map<String, Serializable> sMap) {
        if (sMap.containsKey(sensorName)) {
            /* set color GRAY if sensor value is equal to 1 */
            setColor(1 == (int) sMap.get(sensorName) ? Color.gray : Color.GREEN);
        }
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g.create();
        Shape r = new Rectangle(0, 0, width, height);
        g2d.setColor(color);
        g2d.fill(r);
        g2d.setColor(Color.BLACK);
        g2d.draw(r);
        g2d.dispose();
    }
    
    public static void main(String[] argv) {

        RectangleSwitch d = new RectangleSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
