package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceFcsGUI extends InterfaceGeneralGUI {

    long CONNECT_LOADER_TIMEOUT = 6000;

    long SET_FILTER_TIMEOUT = 120000;

    long LOAD_FILTER_TIMEOUT = 240000;

    default void setFilter(int filterID) {
        System.out.println("setFilter with timeout=" + SET_FILTER_TIMEOUT);
        FCSLOG.info("Setting filter");
        sendCommand("setFilter " + filterID, SET_FILTER_TIMEOUT);
    }

    default void loadFilter() {
        System.out.println("loadFilter with timeout=" + LOAD_FILTER_TIMEOUT);
        FCSLOG.info("Loading filter in camera");
        sendCommand("loadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void unloadFilter() {
        System.out.println("unloadFilter with timeout=" + LOAD_FILTER_TIMEOUT);
        FCSLOG.info("Unloading filter in camera");
        sendCommand("unloadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void connectLoader() {
        System.out.println("connect loader with timeout=" + CONNECT_LOADER_TIMEOUT);
        FCSLOG.info("connecting loader CANbus");
        sendCommand("connectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

    default void disconnectLoader() {
        System.out.println("disconnect loader with timeout=" + CONNECT_LOADER_TIMEOUT);
        FCSLOG.info("disconnecting loader CANbus");
        sendCommand("disconnectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

}
