package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus.OPENED;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP2_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NO_LOCKOUT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_HEIGHT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_STARTINGY;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.createPanelWithComponent;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCLoaderPanel extends JPanel {

    private static final String LABEL1 = "<HTML>On camera<BR>Filter hold</BR><BR>by Loader</BR></HTML>";
    private static final String LABEL2 = "<HTML>On camera<BR>Filter hold</BR><BR>by AC</BR></HTML>";
    private static final String LABEL3 = "<HTML>Engineering<BR>mode</BR></HTML>";
    private static final String LABEL4 = "<HTML>On camera<BR>Without Filter</BR></HTML>";

    /** Sensors Name **/
    public static final String AF0 = "acAF0s";
    public static final String AF0B = "acAF0b";
    public static final String AF3 = "acAF3s";
    public static final String AF3B = "acAF3b";
    public static final String AP2 = "acAP2s";
    public static final String AP2B = "acAP2b";
    public static final String DEFAULT = "loaderDefaultStatus";
    public static final String DOCKED = "loaderOnCameraSensor0";
    public static final String DOCKEDB = "loaderOnCameraSensor1";
    public static final String FILTERPRESENCE = "loaderFilterPresenceSensor0";
    public static final String FILTERPRESENCEB = "loaderFilterPresenceSensor1";
    public static final String GOODPOS = "loaderFilterGoodPositionStatus";
    public static final String KENG = "keyEng";
    public static final String KENGB = "keyEngb";
    public static final String KLOCK = "keyLock";
    public static final String KLOCKB = "keyLockb";
    public static final String LFD = "loader_LFD";
    public static final String LFS = "loader_LFS";
    public static final String RELAYCARRIER = "loaderCarrierRelayStatus";
    public static final String RELAYHOOKS = "loaderHooksRelayStatus";
    public static final String SAFETYBELT = "loaderChainPresenceSensor";

    /**
     * Labels for displayed components.
     * Can be displayed more than one time.
     */
    /* general status*/
    private final String loaderDocked = "Loader<BR>Docked";
    private final String notDefault = "NO<BR>Default Status";
    private final String LFSStatus = "LFS Status";
    private final String notLFSStatus = "NO<BR>LFS Status";
    private final String LFDStatus = "LFD Status";
    private final String notLFDStatus = "NO<BR>LFD Status";
    private final String engineering = "Loader<BR>Engineering<BR>Mode";
    private final String safetyBelt = "Safety<BR>Belt<BR>Presence";

    /* hooks */
    private final String closed = "Hooks<BR>Closed</BR>";
    private final String clamped = "Hooks<BR>Clamped</BR>";
    private final String unclamped = "Hooks<BR>Unclamped</BR>";
    private final String notClosed = "Hooks NOT<BR>Closed</BR>";
    private final String opened = "Hooks<BR>Opened</BR>";
    private final String notOpened = "Hooks NOT<BR>Opened</BR>";
    private final String notUnderClamped = "Hooks NOT<BR>Under Clamped</BR>";
    private final String notOverClamped = "Hooks NOT<BR>Over Clamped</BR>";

    /* filter */
    private final String filterPresence = "Filter<BR>Presence</BR>";
    private final String notFilterPresence = "<B>NOT</B> Filter<BR>Presence</BR>";
    private final String filterPosition = "Filter<BR>Position</BR>";

    /* carrier */
 /* sensor ENGAGED is on in a zone between ENGAGED and HANDOFF*/
    private final String engaged = "Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>";
    private final String handoff = "Carrier<BR>at HANDOFF</BR>";
    private final String storage = "Carrier<BR>at STORAGE</BR>";
    private final String notHandoff = "Carrier<BR>NOT at HANDOFF</BR>";
    
    /* relays */
    private final String carrierRelay = "Carrier<BR>Relay</BR>";
    private final String hooksRelay = "Hooks<BR>Relay</BR>";
    
    private static final DigitalSwitch DOCKEDSWITCH_LFC = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch DOCKEDSWITCH_LFS = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch DOCKEDSWITCH_LFU = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch DOCKEDSWITCH_LFX = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch DOCKEDSWITCH_LFY = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch DOCKEDSWITCH_LFZ = new DigitalSwitch(DOCKED, DOCKEDB);
    private static final DigitalSwitch AP2SWITCH1 = new DigitalSwitch(AP2, AP2B);
    private static final DigitalSwitch AP2SWITCH2 = new DigitalSwitch(AP2, AP2B);
    private static final DigitalSwitch AP2SWITCH3 = new DigitalSwitch(AP2, AP2B);
    private static final DigitalSwitch AP2SWITCH4 = new DigitalSwitch(AP2, AP2B);

    private static final DigitalSwitch AF0SWITCH1 = new DigitalSwitch(AF0, AF0B);
    private static final DigitalSwitch AF0SWITCH2 = new DigitalSwitch(AF0, AF0B);
    private static final DigitalSwitch AF3SWITCH = new DigitalSwitch(AF3, AF3B);
    private static final DigitalSwitch NOLOCKOUTSWITCH1 = new DigitalSwitch(KLOCKB, KLOCK);
    private static final DigitalSwitch NOLOCKOUTSWITCH2 = new DigitalSwitch(KLOCKB, KLOCK);
    private static final DigitalSwitch ENGINEERINGSWITCHC = new DigitalSwitch(KENG, KENGB);
    private static final DigitalSwitch ENGINEERINGSWITCHH = new DigitalSwitch(KENG, KENGB);

    private static final DigitalSwitch FILTERPRESENCESWITCH_LFC = new DigitalSwitch(FILTERPRESENCE, FILTERPRESENCEB);
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFD = new DigitalSwitch(FILTERPRESENCE, FILTERPRESENCEB);
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFS = new DigitalSwitch(FILTERPRESENCE, FILTERPRESENCEB);
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFX = new DigitalSwitch(FILTERPRESENCE, FILTERPRESENCEB);
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFY = new DigitalSwitch(FILTERPRESENCE, FILTERPRESENCEB);
    private static final DigitalSwitch NOFILTERPRESENCESWITCH_LFD = new DigitalSwitch(FILTERPRESENCEB, FILTERPRESENCE);
    private static final DigitalSwitch NOFILTERPRESENCESWITCH_LFZ = new DigitalSwitch(FILTERPRESENCEB, FILTERPRESENCE);
    private static final DigitalSwitch ENGAGEDSWITCH_LFC = new DigitalSwitch();
    private static final DigitalSwitch ENGAGEDSWITCH_LFX = new DigitalSwitch();
    private static final DigitalSwitch ENGAGEDSWITCH_LFZ = new DigitalSwitch();
    private static final DigitalSwitch HANDOFFSWITCH_LFX = new DigitalSwitch();
    private static final DigitalSwitch HANDOFFSWITCH_LFY = new DigitalSwitch();
    private static final DigitalSwitch NOHANDOFFSWITCH_LFS = new DigitalSwitch();
    private static final DigitalSwitch NOHANDOFFSWITCH_LFD = new DigitalSwitch();
    private static final DigitalSwitch STORAGESWITCH_LFZ = new DigitalSwitch();
    
    private DigitalSwitch[] digitalList;
    private DiamondSwitch[] diamondList;

    /* hooks sensors*/
    private final DiamondSwitch hooksClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notUnderClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOpenedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfz = new DiamondSwitch();
        
    /* status signals */
    private final DiamondSwitch noDefaultStatusDiamond1 = new DiamondSwitch(DEFAULT);
    private final DiamondSwitch noDefaultStatusDiamond2 = new DiamondSwitch(DEFAULT);
    private final DiamondSwitch noLfsStatusDiamond = new DiamondSwitch(LFS);
    private final DiamondSwitch noLfdStatusDiamond = new DiamondSwitch(LFD);
    private final DiamondSwitch lfdStatusDiamond = new DiamondSwitch(LFD);
    private final DiamondSwitch lfsStatusDiamond = new DiamondSwitch(LFS);
    private final DiamondSwitch filterGoodPositionSwitch_lfc = new DiamondSwitch(GOODPOS);
    private final DiamondSwitch filterGoodPositionSwitch_lfs = new DiamondSwitch(GOODPOS);
    private final DiamondSwitch safetyBeltPresenceSwitch1 = new DiamondSwitch(SAFETYBELT);
    private final DiamondSwitch safetyBeltPresenceSwitch2 = new DiamondSwitch(SAFETYBELT);

    /* Relays*/
    private final RectangleSwitch carrierRelayRectangle = new RectangleSwitch(RELAYCARRIER);
    private final RectangleSwitch hooksRelayRectangle = new RectangleSwitch(RELAYHOOKS);
    
    private final DigitalSwitch[] complementarySwitches = new DigitalSwitch[] {AF0SWITCH1, AF0SWITCH2,
            AF3SWITCH, AP2SWITCH1, AP2SWITCH2, AP2SWITCH3, AP2SWITCH4, ENGINEERINGSWITCHC, ENGINEERINGSWITCHH, 
            NOLOCKOUTSWITCH1, NOLOCKOUTSWITCH2};
    
    private final DigitalSwitch[] redondantSwitches = new DigitalSwitch[] {FILTERPRESENCESWITCH_LFC, 
                FILTERPRESENCESWITCH_LFD, FILTERPRESENCESWITCH_LFS, 
                FILTERPRESENCESWITCH_LFX, FILTERPRESENCESWITCH_LFY,
                DOCKEDSWITCH_LFC,DOCKEDSWITCH_LFS, 
                DOCKEDSWITCH_LFU, DOCKEDSWITCH_LFX, 
        DOCKEDSWITCH_LFY, DOCKEDSWITCH_LFZ};
    
    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[] { 
        filterGoodPositionSwitch_lfc, filterGoodPositionSwitch_lfs,
        safetyBeltPresenceSwitch1, safetyBeltPresenceSwitch2};
        

    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            /* redondant sensors : value 0 (GRAY) or 1 (GREEN) but can be in error (RED) */
            for (DigitalSwitch ds : redondantSwitches) {
                ds.updateColorRedondantSensor(sensorMap);
            }
                    
            /* ComplementarySensors*/
            for (DigitalSwitch ds : complementarySwitches) {
                ds.updateColorComplementary(sensorMap);
            }

            /* DigitalSensor for status signals : can only be 0 or 1 */
            for (DiamondSwitch ds : diamondSwitchesGreenGray) {
                ds.updateColorGreenGray(sensorMap);
            }
            
            carrierRelayRectangle.updateColorGreenGray(sensorMap);
            hooksRelayRectangle.updateColorGreenGray(sensorMap);
            lfdStatusDiamond.updateColorDefaultRedGray(sensorMap);
            lfsStatusDiamond.updateColorDefaultRedGray(sensorMap);
            noDefaultStatusDiamond1.updateColorDefaultRedGreen(sensorMap);
            noDefaultStatusDiamond2.updateColorDefaultRedGreen(sensorMap);
            noLfsStatusDiamond.updateColorDefaultRedGreen(sensorMap);
            noLfdStatusDiamond.updateColorDefaultRedGreen(sensorMap);
            NOFILTERPRESENCESWITCH_LFD.updateColorRedondantNoSensor(sensorMap);
            NOFILTERPRESENCESWITCH_LFZ.updateColorRedondantNoSensor(sensorMap);
        }

    }
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Carrier.
     */
    private class UpdateCarrier implements Runnable {

        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            STORAGESWITCH_LFZ.setColor(s.isAtStorage() ? Color.GREEN : Color.gray);
            HANDOFFSWITCH_LFX.setColor(s.isAtHandoff() ? Color.GREEN : Color.gray);
            HANDOFFSWITCH_LFY.setColor(s.isAtHandoff() ? Color.GREEN : Color.gray);
            NOHANDOFFSWITCH_LFS.setColor(s.isAtHandoff() ? Color.gray : Color.GREEN);
            NOHANDOFFSWITCH_LFD.setColor(s.isAtHandoff() ? Color.gray : Color.GREEN);
            ENGAGEDSWITCH_LFC.setColor(s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            ENGAGEDSWITCH_LFX.setColor(s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            ENGAGEDSWITCH_LFZ.setColor(s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
        }
    }
        
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            hooksClosedSwitch_lfc.setColor(s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            hooksClosedSwitch_lfx.setColor(s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            openedSwitch_lfu.setColor(s.getClampState().equals(OPENED) ? Color.GREEN : Color.GRAY);
            openedSwitch_lfz.setColor(s.getClampState().equals(OPENED) ? Color.GREEN : Color.GRAY);
            notOpenedSwitch_lfd.setColor(s.getClampState().equals(OPENED) ? Color.GRAY : Color.GREEN);
            notClosedSwitch_lfd.setColor(s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            notClosedSwitch_lfs.setColor(s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            notClosedSwitch_lfu.setColor(s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);

            hooksClampedStatusSwitch_lfc.setColor(s.isForceClampedStatus() ? Color.GREEN : Color.GRAY);
            hooksUnclampedStatusSwitch_lfc.setColor(s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            hooksUnclampedStatusSwitch_lfy.setColor(s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            
            notOverClampedStatusSwitch_lfc.setColor(s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            notOverClampedStatusSwitch_lfu.setColor(s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            notOverClampedStatusSwitch_lfx.setColor(s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            notOverClampedStatusSwitch_lfy.setColor(s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            notOverClampedStatusSwitch_lfz.setColor(s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);

            notUnderClampedStatusSwitch_lfu.setColor(s.isForceUnderClampedStatus() ? Color.GRAY : Color.GREEN);
        }
    }
        
    public PLCLoaderPanel() {
        initComponents();
    }
    
    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }
    
    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         ********************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        add(create_explanationsPanel(), gbc);
        gbc.gridwidth = 1;
        gbc.gridy++;
        add(create_carrierPanel(), gbc);
        gbc.gridy++;
        add(create_hooksPanel(), gbc);
        
        /* LFS Panel */
        gbc.gridy++;
        gbc.gridx = 0;
        add(create_lfsPanel(), gbc);
        
        /* LFD Panel */
        gbc.gridy++;
        gbc.gridx = 0;
        add(create_lfdPanel(), gbc);
        
        /* set default values for whole panel*/
        setDefaultValues();
        
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.WEST;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(new JLabel("<HTML><b>Signals displayed on this panel are read on loaderPlutoGateway (Loader PLC)</b></HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP2_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF0_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><BR></BR></HTML>"), gbcp);
        
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add(new JLabel("<HTML><b>LFU</b>: Hooks opened</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>LFD</b>: Motion prohibition</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>LFS</b>: Stuck-up issue</HTML>"), gbcp);
        gbcp.gridy++;
        return panel;
    }
    
    private JPanel create_carrierPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Carrier"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        
        /**
         *  CARRIER RELAY First line
         */
        JLabel jlabel1 = new JLabel(LABEL1);
        jlabel1.setFont(BIG_FONT);
        panel.add(jlabel1, gbcp);
        
        gbcp.gridx++;
        panel.add(create_acStatusPanel(AP2SWITCH1, AF0SWITCH1, "AF0"), gbcp);
        
        gbcp.gridx++;
        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFC, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(closed, hooksClosedSwitch_lfc, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, FILTERPRESENCESWITCH_LFC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfc, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("", create_lfcSubpanel(), false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 3;
        panel.add(new VerticalLine(200, 75), gbcp);

        gbcp.gridx++;
        panel.add(createPanelWithComponent(notDefault, noDefaultStatusDiamond1, true, false), gbcp);

        gbcp.gridx++;
        panel.add(createPanelWithComponent(notLFSStatus, noLfsStatusDiamond, true, true), gbcp);
        
        gbcp.gridx++;
        gbcp.gridheight = 4;
        panel.add(new VerticalLine(300, 100), gbcp);
        
        gbcp.gridx++;
        panel.add(createPanelWithComponent(NO_LOCKOUT, NOLOCKOUTSWITCH1, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(safetyBelt, safetyBeltPresenceSwitch1, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(carrierRelay, carrierRelayRectangle, true, false), gbcp);        
        
        /**
         *  CARRIER RELAY Second line
         */
        gbcp.gridy = gbcp.gridy + 2;
        gbcp.gridx = 0;
        JLabel jlabel2 = new JLabel(LABEL2);
        jlabel2.setFont(BIG_FONT);
        panel.add(jlabel2, gbcp);
        gbcp.gridx++;
        JPanel ap2Panel = createPanelWithComponent("AP2", AP2SWITCH3, false, true, 20);
        ap2Panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.add(ap2Panel, gbcp);
        gbcp.gridx++;

        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFU, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(opened, openedSwitch_lfu, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notUnderClamped, notUnderClampedStatusSwitch_lfu, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 2;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfu, false, true, 350), gbcp);
        gbcp.gridwidth = 1;
        
        /**
         * CARRIER RELAY third line
         */
        gbcp.gridy = gbcp.gridy + 2;
        gbcp.gridx = 0;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(BIG_FONT);
        panel.add(jlabel3, gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 10;
        panel.add(createPanelWithComponent(engineering, ENGINEERINGSWITCHC, false, true, 1000), gbcp);
        return panel;
    }
        
    private JPanel create_lfcSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx++;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(filterPosition, filterGoodPositionSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(clamped, hooksClampedStatusSwitch_lfc, true, false), gbcp);

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(engaged, ENGAGEDSWITCH_LFC, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(unclamped, hooksUnclampedStatusSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }
    
    private JPanel create_hooksPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Hooks"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.WEST;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridwidth = 3;
        panel.add(create_hooksPanelNonEngineering(), gbcp);
        
        //2nd Vertical Line
        gbcp.gridx = 3;
        gbcp.gridheight = 2;
        gbcp.gridwidth = 1;
        panel.add(new VerticalLine(400, 150), gbcp);
        //Hooks Relay
        gbcp.gridx++;
        panel.add(createPanelWithComponent(NO_LOCKOUT, NOLOCKOUTSWITCH2, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(safetyBelt, safetyBeltPresenceSwitch2, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(hooksRelay, hooksRelayRectangle, true, false), gbcp);
        
        //Hooks Relay fourth line  Engineering Mode
        gbcp.gridy = 2;
        gbcp.gridx = 0;
        gbcp.gridwidth = 1;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(BIG_FONT);
        panel.add(jlabel3, gbcp);
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx++;
        panel.add(createPanelWithComponent(engineering, ENGINEERINGSWITCHH, false, true, 800), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notLFDStatus, noLfdStatusDiamond, false, true, 50), gbcp);
        return panel;
    }
      
   private JPanel create_hooksPanelNonEngineering() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        
        //Hooks Relay first line
        JLabel jlabel1_2 = new JLabel(LABEL1);
        jlabel1_2.setFont(BIG_FONT);
        panel.add(jlabel1_2, gbcp);
        gbcp.gridx++;
        panel.add(create_acStatusPanel(AP2SWITCH2, AF0SWITCH2, "AF0"), gbcp);
        gbcp.gridx++;
        panel.add(create_lfxPanel(), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 4;
        //first vertical line
        panel.add(new VerticalLine(300, 75), gbcp);
        gbcp.gridx++;
        //Hooks Relay No default Status
        panel.add(createPanelWithComponent(notDefault, noDefaultStatusDiamond2, true, true), gbcp);

        //Hooks Relay second line
        gbcp.gridy = gbcp.gridy + 2;
        gbcp.gridx = 0;
        JLabel jlabel2_2 = new JLabel(LABEL2);
        jlabel2_2.setFont(BIG_FONT);
        panel.add(jlabel2_2, gbcp);
        gbcp.gridx++;
        panel.add(create_acStatusPanel(AP2SWITCH4, AF3SWITCH, "AF3"), gbcp);
        gbcp.gridx++;
        panel.add(create_lfyPanel(), gbcp);
        
        //Hooks Relay third line
        gbcp.gridy = gbcp.gridy + 2;
        gbcp.gridx = 0;
        JLabel jlabel4 = new JLabel(LABEL4);
        jlabel4.setFont(BIG_FONT);
        panel.add(jlabel4, gbcp);
        gbcp.gridx = gbcp.gridx + 2;
        panel.add(create_lfzPanel(), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        
        return panel;
   }
   
   
    
    private JPanel create_lfxPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFX, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfx, true, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfxSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfxSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(handoff, HANDOFFSWITCH_LFX, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, FILTERPRESENCESWITCH_LFX, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(closed, hooksClosedSwitch_lfx, true, true), gbcp);

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        panel.add(createPanelWithComponent(engaged, ENGAGEDSWITCH_LFX, true, true, 100), gbcp);
        gbcp.gridx++;

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        gbcp.gridx = gbcp.gridx + 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        
        return panel;
    }
    
    public JPanel create_lfyPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFY, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfy, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(handoff, HANDOFFSWITCH_LFY, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, FILTERPRESENCESWITCH_LFY, false, true), gbcp);      
        gbcp.gridx++;
        panel.add(createPanelWithComponent(unclamped, hooksUnclampedStatusSwitch_lfy, false, true, 80), gbcp); 
        return panel;
    }
    
    public JPanel create_lfzPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfzSubpanel(), gbcp);
        return panel;
    }
    
    public JPanel create_lfzSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFZ, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(engaged, ENGAGEDSWITCH_LFZ, false, true), gbcp);
        gbcp.gridx++;
        
        panel.add(createPanelWithComponent(notFilterPresence, NOFILTERPRESENCESWITCH_LFZ, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(opened, openedSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        gbcp.gridwidth = 4;
        panel.add(createPanelWithComponent(storage, STORAGESWITCH_LFZ, true, true, 190), gbcp);

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        return panel;
    }
    
       private JPanel create_lfdPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFD"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridx++;
           panel.add(createPanelWithComponent(notFilterPresence, NOFILTERPRESENCESWITCH_LFD, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOpened, notOpenedSwitch_lfd, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notHandoff, NOHANDOFFSWITCH_LFD, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(LFDStatus, lfdStatusDiamond, false, false), gbcp);
        return panel;
    }
   
    private JPanel create_lfsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFS"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, DOCKEDSWITCH_LFS, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfsSubpanel(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notHandoff, NOHANDOFFSWITCH_LFS, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notClosed, notClosedSwitch_lfs, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(LFSStatus, lfsStatusDiamond, true, false), gbcp);
    
        return panel;
    }
    
    private JPanel create_lfsSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx++;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(filterPosition, filterGoodPositionSwitch_lfs, true, true), gbcp);

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(filterPresence, FILTERPRESENCESWITCH_LFS, true, true), gbcp);
        
        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }
    
    /*
     * 
     * AC Status Panels
     */
    private static JPanel create_acStatusPanel(DigitalSwitch ap2s, DigitalSwitch af0s, String afName) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.NORTH;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP2", ap2s, false, true, 20), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(afName, af0s, false, true, 20), gbcp);

        return panel;
    }
    
    /**
     * Initialization to be done when Loader subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        digitalList = new DigitalSwitch[]{DOCKEDSWITCH_LFC,
            DOCKEDSWITCH_LFS, DOCKEDSWITCH_LFU,
            DOCKEDSWITCH_LFX, DOCKEDSWITCH_LFY, DOCKEDSWITCH_LFZ,
            AP2SWITCH1, AP2SWITCH2, AP2SWITCH3, AP2SWITCH4, AF0SWITCH1, AF0SWITCH2, AF3SWITCH,
            NOLOCKOUTSWITCH1, NOLOCKOUTSWITCH2, ENGINEERINGSWITCHC, ENGINEERINGSWITCHH,
            FILTERPRESENCESWITCH_LFC, FILTERPRESENCESWITCH_LFD, FILTERPRESENCESWITCH_LFS, FILTERPRESENCESWITCH_LFX,
            FILTERPRESENCESWITCH_LFY,
            NOFILTERPRESENCESWITCH_LFZ, NOFILTERPRESENCESWITCH_LFD,
            ENGAGEDSWITCH_LFC, ENGAGEDSWITCH_LFX, ENGAGEDSWITCH_LFZ,
            HANDOFFSWITCH_LFX, HANDOFFSWITCH_LFY, NOHANDOFFSWITCH_LFD, NOHANDOFFSWITCH_LFS, STORAGESWITCH_LFZ,};
        diamondList = new DiamondSwitch[]{hooksClampedStatusSwitch_lfc, hooksUnclampedStatusSwitch_lfc,
            hooksUnclampedStatusSwitch_lfy,
            notUnderClampedStatusSwitch_lfu, notOverClampedStatusSwitch_lfc, notOverClampedStatusSwitch_lfu,
            notOverClampedStatusSwitch_lfx, notOverClampedStatusSwitch_lfy, notOverClampedStatusSwitch_lfz,
            hooksClosedSwitch_lfc, hooksClosedSwitch_lfx, notClosedSwitch_lfd, notClosedSwitch_lfs, notClosedSwitch_lfu,
            openedSwitch_lfu, openedSwitch_lfz, notOpenedSwitch_lfd,
            noDefaultStatusDiamond1, noDefaultStatusDiamond2, noLfsStatusDiamond, noLfdStatusDiamond, lfdStatusDiamond, lfsStatusDiamond,
            filterGoodPositionSwitch_lfc, filterGoodPositionSwitch_lfs,
            safetyBeltPresenceSwitch1, safetyBeltPresenceSwitch2
        };
        for (DigitalSwitch c : digitalList) {
            c.setColor(Color.gray);
        }
        for (DiamondSwitch c : diamondList) {
            c.setColor(Color.gray);
        }
        carrierRelayRectangle.setColor(Color.gray);
        hooksRelayRectangle.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    
    @Override
    public String toString() {
        return "PLC Loader Panel";
    }
}
