/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCAutochangerPanel
extends JPanel {
    private final String engineering = "<BR>Autochanger<BR>Engineering<BR>Mode";
    private final String LOCKOUT_SHUNT = "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay";
    private final String enable_clamps = "enable_clamps";
    private final String enable_latches = "enable_latches";
    private final String enable_rails = "enable_linear_rails";
    public static final String AF0 = "OUT_AF0";
    public static final String AF0B = "OUT_AF0_C";
    public static final String AF1 = "OUT_AF1";
    public static final String AF1B = "OUT_AF1_C";
    public static final String AF3 = "OUT_AF3";
    public static final String AF3B = "OUT_AF3_C";
    public static final String AP1 = "OUT_AP1";
    public static final String AP1B = "OUT_AP1_C";
    public static final String AP2 = "OUT_AP2";
    public static final String AP2B = "OUT_AP2_C";
    public static final String AP3 = "OUT_AP3";
    public static final String AP3B = "OUT_AP3_C";
    public static final String ALM = "presenceLoader";
    public static final String ALMB = "presenceLoader_C";
    public static final String CFC = "carouselHoldingFilterSensor0";
    public static final String CFCB = "carouselHoldingFilterSensor1";
    public static final String CF0 = "carousel_CF0";
    public static final String CF0B = "carousel_CF0_C";
    public static final String CF1 = "carousel_CF1";
    public static final String CF1B = "carousel_CF1_C";
    public static final String CS = "carouselStoppedAtStandby";
    public static final String CSB = "carouselStoppedAtStandbyC";
    public static final String LPS = "loaderConnectedSensor";
    public static final String LPSB = "loaderConnectedSensorC";
    public static final String LRH = "loaderHoldingFilterSensor0";
    public static final String LRHB = "loaderHoldingFilterSensor1";
    public static final String ENG = "engineeringKey";
    public static final String ENGB = "engineeringKey_C";
    public static final String LOCK = "lockOut";
    public static final String LOCKB = "lockOut_C";
    public static final String RELAYCLAMPS = "lpmOnlineClampsStatus";
    public static final String RELAYLATCHES = "lpmLatchesStatus";
    public static final String RELAYRAIL1 = "lpmLinearRail1Status";
    public static final String RELAYRAIL2 = "lpmLinearRail2Status";
    public static final String AIN = "OUT_AIN";
    public static final String AOL = "OUT_AOL";
    public static final String LOCKSHUNT = "lockOutShunt";
    private final DigitalSwitch af0Switch = new DigitalSwitch("OUT_AF0", "OUT_AF0_C");
    private final DigitalSwitch af1SwitchL1 = new DigitalSwitch("OUT_AF1", "OUT_AF1_C");
    private final DigitalSwitch af1SwitchL2 = new DigitalSwitch("OUT_AF1", "OUT_AF1_C");
    private final DigitalSwitch af3SwitchC = new DigitalSwitch("OUT_AF3", "OUT_AF3_C");
    private final DigitalSwitch af3SwitchR1 = new DigitalSwitch("OUT_AF3", "OUT_AF3_C");
    private final DigitalSwitch af3SwitchR4 = new DigitalSwitch("OUT_AF3", "OUT_AF3_C");
    private final DigitalSwitch ap1SwitchC = new DigitalSwitch("OUT_AP1", "OUT_AP1_C");
    private final DigitalSwitch ap1SwitchR = new DigitalSwitch("OUT_AP1", "OUT_AP1_C");
    private final DigitalSwitch ap2Switch = new DigitalSwitch("OUT_AP2", "OUT_AP2_C");
    private final DigitalSwitch ap3SwitchC = new DigitalSwitch("OUT_AP3", "OUT_AP3_C");
    private final DigitalSwitch ap3SwitchR = new DigitalSwitch("OUT_AP3", "OUT_AP3_C");
    private final DigitalSwitch notAp3Switch = new DigitalSwitch("OUT_AP3_C", "OUT_AP3");
    private final DigitalSwitch notAlmSwitch = new DigitalSwitch("presenceLoader_C", "presenceLoader");
    private final DigitalSwitch cfcSwitch = new DigitalSwitch("carouselHoldingFilterSensor0", "carouselHoldingFilterSensor1");
    private final DigitalSwitch cf0Switch1 = new DigitalSwitch("carousel_CF0", "carousel_CF0_C");
    private final DigitalSwitch cf0Switch2 = new DigitalSwitch("carousel_CF0", "carousel_CF0_C");
    private final DigitalSwitch cf1Switch = new DigitalSwitch("carousel_CF1", "carousel_CF1_C");
    private final DigitalSwitch csSwitch1 = new DigitalSwitch("carouselStoppedAtStandby", "carouselStoppedAtStandbyC");
    private final DigitalSwitch csSwitch2 = new DigitalSwitch("carouselStoppedAtStandby", "carouselStoppedAtStandbyC");
    private final DigitalSwitch csSwitch3 = new DigitalSwitch("carouselStoppedAtStandby", "carouselStoppedAtStandbyC");
    private final DigitalSwitch csSwitch4 = new DigitalSwitch("carouselStoppedAtStandby", "carouselStoppedAtStandbyC");
    private final DigitalSwitch lpsSwitch = new DigitalSwitch("loaderConnectedSensor", "loaderConnectedSensorC");
    private final DigitalSwitch lrhSwitch = new DigitalSwitch("loaderHoldingFilterSensor0", "loaderHoldingFilterSensor1");
    private final DigitalSwitch NoLockoutSwitchC = new DigitalSwitch("lockOut_C", "lockOut");
    private final DigitalSwitch NoLockoutSwitchL = new DigitalSwitch("lockOut_C", "lockOut");
    private final DigitalSwitch NoLockoutSwitchR = new DigitalSwitch("lockOut_C", "lockOut");
    private final DigitalSwitch engineeringSwitchC = new DigitalSwitch("engineeringKey", "engineeringKey_C");
    private final DigitalSwitch engineeringSwitchL = new DigitalSwitch("engineeringKey", "engineeringKey_C");
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch("engineeringKey", "engineeringKey_C");
    private final DiamondSwitch ainSwitchC = new DiamondSwitch("OUT_AIN");
    private final DiamondSwitch ainSwitchL = new DiamondSwitch("OUT_AIN");
    private final DiamondSwitch ainSwitchR = new DiamondSwitch("OUT_AIN");
    private final DiamondSwitch aolSwitch = new DiamondSwitch("OUT_AOL");
    private final DiamondSwitch lockoutShuntSwitchC = new DiamondSwitch("lockOutShunt");
    private final DiamondSwitch lockoutShuntSwitchL = new DiamondSwitch("lockOutShunt");
    private final DiamondSwitch lockoutShuntSwitchR = new DiamondSwitch("lockOutShunt");
    private final RectangleSwitch clampsRelayRectangle = new RectangleSwitch("lpmOnlineClampsStatus");
    private final RectangleSwitch latchesRelayRectangle = new RectangleSwitch("lpmLatchesStatus");
    private final RectangleSwitch railsRelayRectangle = new RectangleSwitch();
    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{this.ainSwitchC, this.ainSwitchL, this.ainSwitchR, this.aolSwitch, this.lockoutShuntSwitchC, this.lockoutShuntSwitchL, this.lockoutShuntSwitchR};
    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{this.af0Switch, this.af1SwitchL1, this.af1SwitchL2, this.af3SwitchC, this.af3SwitchR1, this.af3SwitchR4, this.ap1SwitchC, this.ap1SwitchR, this.ap2Switch, this.ap3SwitchC, this.ap3SwitchR, this.notAp3Switch, this.notAlmSwitch, this.cfcSwitch, this.cf0Switch1, this.cf0Switch2, this.cf1Switch, this.csSwitch1, this.csSwitch2, this.csSwitch3, this.csSwitch4, this.lpsSwitch, this.lrhSwitch, this.NoLockoutSwitchC, this.NoLockoutSwitchL, this.NoLockoutSwitchR, this.engineeringSwitchC, this.engineeringSwitchL, this.engineeringSwitchR};

    public PLCAutochangerPanel() {
        this.initComponents();
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("AUTOCHANGER PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        ++gbc.gridy;
        this.add((Component)this.create_explanationsPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_clampsPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_latchesPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_linearRailsPanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><b>Signals displayed on this panel are read on acSensorsGateway (Autochanger PLC)</b></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP1</b>: autochanger at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP3</b>: autochanger at ONLINE position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AOL</b>: ONLINE clamps all opened &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF0</b>: autochanger latches opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF1</b>: filter engaged on autochanger</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF3</b>: filter engaged and locked on autochanger  &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel(""), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add((Component)new JLabel("<HTML><b>CS</b>: carousel stopped at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CFC</b>: filter LOCKED on carousel</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF0</b>: no filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF1</b>: filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LRH</b>: Loader holding filter at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LPS</b>: Loader carrier at STORAGE position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>ALM</b>: Loader docked</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AIN</b>: Inclinaison sensor less than 10\u00b0</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel(""), gbcp);
        return panel;
    }

    private JPanel create_clampsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Online Clamps"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP3", this.ap3SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchC, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("<B>NOT</B><BR>Lock Out Bay L</BR>", this.NoLockoutSwitchC, "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay", this.lockoutShuntSwitchC), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_clamps", this.clampsRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchC, false, true, 100), gbcp);
        return panel;
    }

    private JPanel create_latchesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Latches"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP2", this.ap2Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF1", this.af1SwitchL1, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LRH", this.lrhSwitch, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchL, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(175, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("<B>NOT</B><BR>Lock Out Bay L</BR>", this.NoLockoutSwitchL, "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay", this.lockoutShuntSwitchL), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_latches", this.latchesRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CFC", this.cfcSwitch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP1", this.ap1SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF1", this.af1SwitchL2, false, true), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridwidth = 5;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchL, false, true, 230), gbcp);
        return panel;
    }

    private JPanel create_linearRailsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Linear Rails"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch1, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 2;
        panel.add((Component)Tools.createPanelWithComponent("CF0", this.cf0Switch1, false, true, 100), gbcp);
        gbcp.gridwidth = 1;
        ++gbcp.gridx;
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 10), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchR1, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NOT AP3", this.notAp3Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AOL", this.aolSwitch, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(130, 45), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("LPS", this.lpsSwitch, "<BR>NOT ALM</BR>", this.notAlmSwitch), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(180, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchR, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 5;
        panel.add((Component)new VerticalLine(260, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("<B>NOT</B><BR>Lock Out Bay L</BR>", this.NoLockoutSwitchR, "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay", this.lockoutShuntSwitchR), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_linear_rails", this.railsRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch2, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("CF1", this.cf1Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP1", this.ap1SwitchR, false, true), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch3, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 6;
        gbcp.anchor = 17;
        panel.add((Component)Tools.createPanelWithComponent("AF0", this.af0Switch, false, true, 375), gbcp);
        gbcp.gridwidth = 1;
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch4, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("CF0", this.cf0Switch2, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP3", this.ap3SwitchR, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 8;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchR4, false, true, 500), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridwidth = 13;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchR, false, true, 750), gbcp);
        return panel;
    }

    private void setDefaultValues() {
        for (DigitalSwitch digitalSwitch : this.digitalList) {
            digitalSwitch.setColor(Color.gray);
        }
        for (JComponent jComponent : this.diamondSwitchesGreenGray) {
            ((DiamondSwitch)jComponent).setColor(Color.gray);
        }
        this.clampsRelayRectangle.setColor(Color.gray);
        this.latchesRelayRectangle.setColor(Color.gray);
        this.railsRelayRectangle.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Autochanger Panel";
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DiamondSwitch diamondSwitch : PLCAutochangerPanel.this.diamondSwitchesGreenGray) {
                diamondSwitch.updateColorGreenGray(this.sensorMap);
            }
            for (JComponent jComponent : PLCAutochangerPanel.this.digitalList) {
                ((DigitalSwitch)jComponent).updateColorComplementary(this.sensorMap);
            }
            PLCAutochangerPanel.this.clampsRelayRectangle.updateColorGreenGray(this.sensorMap);
            PLCAutochangerPanel.this.latchesRelayRectangle.updateColorGreenGray(this.sensorMap);
            if (this.sensorMap.containsKey(PLCAutochangerPanel.RELAYRAIL1) && this.sensorMap.containsKey(PLCAutochangerPanel.RELAYRAIL2)) {
                if (((Integer)this.sensorMap.get(PLCAutochangerPanel.RELAYRAIL1)).intValue() != ((Integer)this.sensorMap.get(PLCAutochangerPanel.RELAYRAIL2)).intValue()) {
                    PLCAutochangerPanel.this.railsRelayRectangle.setColor(Color.RED);
                } else if ((Integer)this.sensorMap.get(PLCAutochangerPanel.RELAYRAIL1) == 1) {
                    PLCAutochangerPanel.this.railsRelayRectangle.setColor(Color.GREEN);
                } else {
                    PLCAutochangerPanel.this.railsRelayRectangle.setColor(Color.GRAY);
                }
            }
        }
    }
}

