/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCLoaderPanel
extends JPanel {
    private static final String LABEL1 = "<HTML>On camera<BR>Filter hold</BR><BR>by Loader</BR></HTML>";
    private static final String LABEL2 = "<HTML>On camera<BR>Filter hold</BR><BR>by AC</BR></HTML>";
    private static final String LABEL3 = "<HTML>Engineering<BR>mode</BR></HTML>";
    private static final String LABEL4 = "<HTML>On camera<BR>Without Filter</BR></HTML>";
    public static final String AF0 = "acAF0s";
    public static final String AF0B = "acAF0b";
    public static final String AF3 = "acAF3s";
    public static final String AF3B = "acAF3b";
    public static final String AP2 = "acAP2s";
    public static final String AP2B = "acAP2b";
    public static final String DEFAULT = "loaderDefaultStatus";
    public static final String DOCKED = "loaderOnCameraSensor0";
    public static final String DOCKEDB = "loaderOnCameraSensor1";
    public static final String FILTERPRESENCE = "loaderFilterPresenceSensor0";
    public static final String FILTERPRESENCEB = "loaderFilterPresenceSensor1";
    public static final String GOODPOS = "loaderFilterGoodPositionStatus";
    public static final String KENG = "keyEng";
    public static final String KENGB = "keyEngb";
    public static final String KLOCK = "keyLock";
    public static final String KLOCKB = "keyLockb";
    public static final String LFD = "loader_LFD";
    public static final String LFS = "loader_LFS";
    public static final String RELAYCARRIER = "loaderCarrierRelayStatus";
    public static final String RELAYHOOKS = "loaderCarrierHooksStatus";
    public static final String SAFETYBELT = "loaderChainPresenceSensor";
    private final String loaderDocked = "Loader<BR>Docked";
    private final String notDefault = "NO<BR>Default Status";
    private final String LFSStatus = "LFS Status";
    private final String notLFSStatus = "NO<BR>LFS Status";
    private final String LFDStatus = "LFD Status";
    private final String notLFDStatus = "NO<BR>LFD Status";
    private final String engineering = "Loader<BR>Engineering<BR>Mode";
    private final String safetyBelt = "Safety<BR>Belt<BR>Presence";
    private final String closed = "Hooks<BR>Closed</BR>";
    private final String clamped = "Hooks<BR>Clamped</BR>";
    private final String unclamped = "Hooks<BR>Unclamped</BR>";
    private final String notClosed = "Hooks NOT<BR>Closed</BR>";
    private final String opened = "Hooks<BR>Opened</BR>";
    private final String notOpened = "Hooks NOT<BR>Opened</BR>";
    private final String notUnderClamped = "Hooks NOT<BR>Under Clamped</BR>";
    private final String notOverClamped = "Hooks NOT<BR>Over Clamped</BR>";
    private final String filterPresence = "Filter<BR>Presence</BR>";
    private final String notFilterPresence = "<B>NOT</B> Filter<BR>Presence</BR>";
    private final String filterPosition = "Filter<BR>Position</BR>";
    private final String engaged = "Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>";
    private final String handoff = "Carrier<BR>at HANDOFF</BR>";
    private final String storage = "Carrier<BR>at STORAGE</BR>";
    private final String notHandoff = "Carrier<BR>NOT at HANDOFF</BR>";
    private final String carrierRelay = "Carrier<BR>Relay</BR>";
    private final String hooksRelay = "Hooks<BR>Relay</BR>";
    private static final DigitalSwitch DOCKEDSWITCH_LFC = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch DOCKEDSWITCH_LFS = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch DOCKEDSWITCH_LFU = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch DOCKEDSWITCH_LFX = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch DOCKEDSWITCH_LFY = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch DOCKEDSWITCH_LFZ = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch AP2SWITCH1 = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AP2SWITCH2 = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AP2SWITCH3 = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AP2SWITCH4 = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AF0SWITCH1 = new DigitalSwitch("acAF0s", "acAF0b");
    private static final DigitalSwitch AF0SWITCH2 = new DigitalSwitch("acAF0s", "acAF0b");
    private static final DigitalSwitch AF3SWITCH = new DigitalSwitch("acAF3s", "acAF3b");
    private static final DigitalSwitch NOLOCKOUTSWITCH1 = new DigitalSwitch("keyLockb", "keyLock");
    private static final DigitalSwitch NOLOCKOUTSWITCH2 = new DigitalSwitch("keyLockb", "keyLock");
    private static final DigitalSwitch ENGINEERINGSWITCHC = new DigitalSwitch("keyEng", "keyEngb");
    private static final DigitalSwitch ENGINEERINGSWITCHH = new DigitalSwitch("keyEng", "keyEngb");
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFC = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFD = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFS = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFX = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private static final DigitalSwitch FILTERPRESENCESWITCH_LFY = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private static final DigitalSwitch NOFILTERPRESENCESWITCH_LFD = new DigitalSwitch("loaderFilterPresenceSensor1", "loaderFilterPresenceSensor0");
    private static final DigitalSwitch NOFILTERPRESENCESWITCH_LFZ = new DigitalSwitch("loaderFilterPresenceSensor1", "loaderFilterPresenceSensor0");
    private static final DigitalSwitch ENGAGEDSWITCH_LFC = new DigitalSwitch();
    private static final DigitalSwitch ENGAGEDSWITCH_LFX = new DigitalSwitch();
    private static final DigitalSwitch ENGAGEDSWITCH_LFZ = new DigitalSwitch();
    private static final DigitalSwitch HANDOFFSWITCH_LFX = new DigitalSwitch();
    private static final DigitalSwitch HANDOFFSWITCH_LFY = new DigitalSwitch();
    private static final DigitalSwitch NOHANDOFFSWITCH_LFS = new DigitalSwitch();
    private static final DigitalSwitch NOHANDOFFSWITCH_LFD = new DigitalSwitch();
    private static final DigitalSwitch STORAGESWITCH_LFZ = new DigitalSwitch();
    private DigitalSwitch[] digitalList;
    private DiamondSwitch[] diamondList;
    private final DiamondSwitch hooksClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notUnderClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOpenedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch noDefaultStatusDiamond1 = new DiamondSwitch("loaderDefaultStatus");
    private final DiamondSwitch noDefaultStatusDiamond2 = new DiamondSwitch("loaderDefaultStatus");
    private final DiamondSwitch noLfsStatusDiamond = new DiamondSwitch("loader_LFS");
    private final DiamondSwitch noLfdStatusDiamond = new DiamondSwitch("loader_LFD");
    private final DiamondSwitch lfdStatusDiamond = new DiamondSwitch("loader_LFD");
    private final DiamondSwitch lfsStatusDiamond = new DiamondSwitch("loader_LFS");
    private final DiamondSwitch filterGoodPositionSwitch_lfc = new DiamondSwitch("loaderFilterGoodPositionStatus");
    private final DiamondSwitch filterGoodPositionSwitch_lfs = new DiamondSwitch("loaderFilterGoodPositionStatus");
    private final DiamondSwitch safetyBeltPresenceSwitch1 = new DiamondSwitch("loaderChainPresenceSensor");
    private final DiamondSwitch safetyBeltPresenceSwitch2 = new DiamondSwitch("loaderChainPresenceSensor");
    private final RectangleSwitch carrierRelayRectangle = new RectangleSwitch("loaderCarrierRelayStatus");
    private final RectangleSwitch hooksRelayRectangle = new RectangleSwitch("loaderCarrierHooksStatus");
    private final DigitalSwitch[] complementarySwitches = new DigitalSwitch[]{AF0SWITCH1, AF0SWITCH2, AF3SWITCH, AP2SWITCH1, AP2SWITCH2, AP2SWITCH3, AP2SWITCH4, ENGINEERINGSWITCHC, ENGINEERINGSWITCHH, NOLOCKOUTSWITCH1, NOLOCKOUTSWITCH2};
    private final DigitalSwitch[] redondantSwitches = new DigitalSwitch[]{FILTERPRESENCESWITCH_LFC, FILTERPRESENCESWITCH_LFD, FILTERPRESENCESWITCH_LFS, FILTERPRESENCESWITCH_LFX, FILTERPRESENCESWITCH_LFY, DOCKEDSWITCH_LFC, DOCKEDSWITCH_LFS, DOCKEDSWITCH_LFU, DOCKEDSWITCH_LFX, DOCKEDSWITCH_LFY, DOCKEDSWITCH_LFZ};
    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{this.filterGoodPositionSwitch_lfc, this.filterGoodPositionSwitch_lfs, this.safetyBeltPresenceSwitch1, this.safetyBeltPresenceSwitch2};

    public PLCLoaderPanel() {
        this.initComponents();
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("LOADER PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.create_explanationsPanel(), gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.add((Component)this.create_carrierPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_hooksPanel(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.create_lfsPanel(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.create_lfdPanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><b>Signals displayed on this panel are read on loaderPlutoGateway (Loader PLC)</b></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF0</b>: autochanger latches opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF3</b>: filter engaged and locked on autochanger  &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><BR></BR></HTML>"), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add((Component)new JLabel("<HTML><b>LFU</b>: Hooks opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LFD</b>: Motion prohibition</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LFS</b>: Stuck-up issue</HTML>"), gbcp);
        ++gbcp.gridy;
        return panel;
    }

    private JPanel create_carrierPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Carrier"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        JLabel jlabel1 = new JLabel(LABEL1);
        jlabel1.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel1, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(AP2SWITCH1, AF0SWITCH1, "AF0"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFC, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfc, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", FILTERPRESENCESWITCH_LFC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfc, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("", this.create_lfcSubpanel(), false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(200, 75), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>Default Status", this.noDefaultStatusDiamond1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>LFS Status", this.noLfsStatusDiamond, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(300, 100), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", NOLOCKOUTSWITCH1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>Relay</BR>", this.carrierRelayRectangle, true, false), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel2 = new JLabel(LABEL2);
        jlabel2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel2, gbcp);
        ++gbcp.gridx;
        JPanel ap2Panel = Tools.createPanelWithComponent("AP2", AP2SWITCH3, false, true, 20);
        ap2Panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.add((Component)ap2Panel, gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFU, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfu, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Under Clamped</BR>", this.notUnderClampedStatusSwitch_lfu, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 2;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfu, false, true, 350), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel3, gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 10;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Engineering<BR>Mode", ENGINEERINGSWITCHC, false, true, 1000), gbcp);
        return panel;
    }

    private JPanel create_lfcSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Clamped</BR>", this.hooksClampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", ENGAGEDSWITCH_LFC, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_hooksPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Hooks"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridwidth = 3;
        panel.add((Component)this.create_hooksPanelNonEngineering(), gbcp);
        gbcp.gridx = 3;
        gbcp.gridheight = 2;
        gbcp.gridwidth = 1;
        panel.add((Component)new VerticalLine(400, 150), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", NOLOCKOUTSWITCH2, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch2, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Relay</BR>", this.hooksRelayRectangle, true, false), gbcp);
        gbcp.gridy = 2;
        gbcp.gridx = 0;
        gbcp.gridwidth = 1;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel3, gbcp);
        gbcp.anchor = 10;
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Engineering<BR>Mode", ENGINEERINGSWITCHH, false, true, 800), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>LFD Status", this.noLfdStatusDiamond, false, true, 50), gbcp);
        return panel;
    }

    private JPanel create_hooksPanelNonEngineering() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        JLabel jlabel1_2 = new JLabel(LABEL1);
        jlabel1_2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel1_2, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(AP2SWITCH2, AF0SWITCH2, "AF0"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfxPanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(300, 75), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>Default Status", this.noDefaultStatusDiamond2, true, true), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel2_2 = new JLabel(LABEL2);
        jlabel2_2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel2_2, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(AP2SWITCH4, AF3SWITCH, "AF3"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfyPanel(), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel4 = new JLabel(LABEL4);
        jlabel4.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel4, gbcp);
        gbcp.gridx += 2;
        panel.add((Component)this.create_lfzPanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        return panel;
    }

    private JPanel create_lfxPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFX, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfx, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfxSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfxSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", HANDOFFSWITCH_LFX, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", FILTERPRESENCESWITCH_LFX, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfx, true, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", ENGAGEDSWITCH_LFX, true, true, 100), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        gbcp.gridx += 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public JPanel create_lfyPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFY, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", HANDOFFSWITCH_LFY, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", FILTERPRESENCESWITCH_LFY, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfy, false, true, 80), gbcp);
        return panel;
    }

    public JPanel create_lfzPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfzSubpanel(), gbcp);
        return panel;
    }

    public JPanel create_lfzSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFZ, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", ENGAGEDSWITCH_LFZ, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B> Filter<BR>Presence</BR>", NOFILTERPRESENCESWITCH_LFZ, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridwidth = 4;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at STORAGE</BR>", STORAGESWITCH_LFZ, true, true, 190), gbcp);
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_lfdPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFD"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B> Filter<BR>Presence</BR>", NOFILTERPRESENCESWITCH_LFD, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Opened</BR>", this.notOpenedSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", NOHANDOFFSWITCH_LFD, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LFD Status", this.lfdStatusDiamond, false, false), gbcp);
        return panel;
    }

    private JPanel create_lfsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFS"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", DOCKEDSWITCH_LFS, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfsSubpanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", NOHANDOFFSWITCH_LFS, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Closed</BR>", this.notClosedSwitch_lfs, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LFS Status", this.lfsStatusDiamond, true, false), gbcp);
        return panel;
    }

    private JPanel create_lfsSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfs, true, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", FILTERPRESENCESWITCH_LFS, true, true), gbcp);
        gbcp.gridy = 0;
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private static JPanel create_acStatusPanel(DigitalSwitch ap2s, DigitalSwitch af0s, String afName) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 11;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP2", ap2s, false, true, 20), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(afName, af0s, false, true, 20), gbcp);
        return panel;
    }

    private void setDefaultValues() {
        this.digitalList = new DigitalSwitch[]{DOCKEDSWITCH_LFC, DOCKEDSWITCH_LFS, DOCKEDSWITCH_LFU, DOCKEDSWITCH_LFX, DOCKEDSWITCH_LFY, DOCKEDSWITCH_LFZ, AP2SWITCH1, AP2SWITCH2, AP2SWITCH3, AP2SWITCH4, AF0SWITCH1, AF0SWITCH2, AF3SWITCH, NOLOCKOUTSWITCH1, NOLOCKOUTSWITCH2, ENGINEERINGSWITCHC, ENGINEERINGSWITCHH, FILTERPRESENCESWITCH_LFC, FILTERPRESENCESWITCH_LFD, FILTERPRESENCESWITCH_LFS, FILTERPRESENCESWITCH_LFX, FILTERPRESENCESWITCH_LFY, NOFILTERPRESENCESWITCH_LFZ, NOFILTERPRESENCESWITCH_LFD, ENGAGEDSWITCH_LFC, ENGAGEDSWITCH_LFX, ENGAGEDSWITCH_LFZ, HANDOFFSWITCH_LFX, HANDOFFSWITCH_LFY, NOHANDOFFSWITCH_LFD, NOHANDOFFSWITCH_LFS, STORAGESWITCH_LFZ};
        this.diamondList = new DiamondSwitch[]{this.hooksClampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfy, this.notUnderClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfc, this.notOverClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfx, this.notOverClampedStatusSwitch_lfy, this.notOverClampedStatusSwitch_lfz, this.hooksClosedSwitch_lfc, this.hooksClosedSwitch_lfx, this.notClosedSwitch_lfd, this.notClosedSwitch_lfs, this.notClosedSwitch_lfu, this.openedSwitch_lfu, this.openedSwitch_lfz, this.notOpenedSwitch_lfd, this.noDefaultStatusDiamond1, this.noDefaultStatusDiamond2, this.noLfsStatusDiamond, this.noLfdStatusDiamond, this.lfdStatusDiamond, this.lfsStatusDiamond, this.filterGoodPositionSwitch_lfc, this.filterGoodPositionSwitch_lfs, this.safetyBeltPresenceSwitch1, this.safetyBeltPresenceSwitch2};
        for (DigitalSwitch digitalSwitch : this.digitalList) {
            digitalSwitch.setColor(Color.gray);
        }
        for (JComponent jComponent : this.diamondList) {
            ((DiamondSwitch)jComponent).setColor(Color.gray);
        }
        this.carrierRelayRectangle.setColor(Color.gray);
        this.hooksRelayRectangle.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Loader Panel";
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCLoaderPanel.this.hooksClosedSwitch_lfc.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksClosedSwitch_lfx.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.openedSwitch_lfu.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.openedSwitch_lfz.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.notOpenedSwitch_lfd.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfd.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfs.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfu.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.hooksClampedStatusSwitch_lfc.setColor(this.s.isForceClampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfc.setColor(this.s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfy.setColor(this.s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfc.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfu.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfx.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfy.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfz.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notUnderClampedStatusSwitch_lfu.setColor(this.s.isForceUnderClampedStatus() ? Color.GRAY : Color.GREEN);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            STORAGESWITCH_LFZ.setColor(this.s.isAtStorage() ? Color.GREEN : Color.gray);
            HANDOFFSWITCH_LFX.setColor(this.s.isAtHandoff() ? Color.GREEN : Color.gray);
            HANDOFFSWITCH_LFY.setColor(this.s.isAtHandoff() ? Color.GREEN : Color.gray);
            NOHANDOFFSWITCH_LFS.setColor(this.s.isAtHandoff() ? Color.gray : Color.GREEN);
            NOHANDOFFSWITCH_LFD.setColor(this.s.isAtHandoff() ? Color.gray : Color.GREEN);
            ENGAGEDSWITCH_LFC.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            ENGAGEDSWITCH_LFX.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            ENGAGEDSWITCH_LFZ.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
        }
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            FCSCst.FCSLOG.info((Object)("==> sMap.toString: " + this.sensorMap.toString()));
            for (DigitalSwitch digitalSwitch : PLCLoaderPanel.this.redondantSwitches) {
                digitalSwitch.updateColorRedondantSensor(this.sensorMap);
            }
            for (DigitalSwitch digitalSwitch : PLCLoaderPanel.this.complementarySwitches) {
                digitalSwitch.updateColorComplementary(this.sensorMap);
            }
            for (JComponent jComponent : PLCLoaderPanel.this.diamondSwitchesGreenGray) {
                ((DiamondSwitch)jComponent).updateColorGreenGray(this.sensorMap);
            }
            PLCLoaderPanel.this.carrierRelayRectangle.updateColorGreenGray(this.sensorMap);
            PLCLoaderPanel.this.hooksRelayRectangle.updateColorGreenGray(this.sensorMap);
            PLCLoaderPanel.this.lfdStatusDiamond.updateColorDefaultRedGray(this.sensorMap);
            PLCLoaderPanel.this.lfsStatusDiamond.updateColorDefaultRedGray(this.sensorMap);
            PLCLoaderPanel.this.noDefaultStatusDiamond1.updateColorDefaultRedGreen(this.sensorMap);
            PLCLoaderPanel.this.noDefaultStatusDiamond2.updateColorDefaultRedGreen(this.sensorMap);
            PLCLoaderPanel.this.noLfsStatusDiamond.updateColorDefaultRedGreen(this.sensorMap);
            PLCLoaderPanel.this.noLfdStatusDiamond.updateColorDefaultRedGreen(this.sensorMap);
            NOFILTERPRESENCESWITCH_LFD.updateColorRedondantNoSensor(this.sensorMap);
            NOFILTERPRESENCESWITCH_LFZ.updateColorRedondantNoSensor(this.sensorMap);
        }
    }
}

