
/*
 * DigitalSwitch.java
 *
 * Created on Oct 4, 2012, 2:11:07 AM
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author turri
 */
public class DigitalSwitch extends JComponent {
    private static final long serialVersionUID = -5877393948127174541L;

    private int size = 20;
    private Color color = new Color(0, 153, 0);
    
    private String sensorName;
    private String sensorNameB;

    /**
     * Creates new form DigitalSwitch
     */
    public DigitalSwitch() {
        super.setPreferredSize(new Dimension(size, size));
    }

    public DigitalSwitch(String sensorName, String sensorNameB) {
        super.setPreferredSize(new Dimension(size, size));
        this.sensorName = sensorName;
        this.sensorNameB = sensorNameB;
    }
    
    /**
     * Change the size of the DigitalSwitch
     * @param size
     */
    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        setColor(bg);
    }

    public void setColor(Color c) {
        this.color = c;
        repaint();
    }

    /**
     * updates color of a digital switch
     * Uses when a digital switch represents a sensors.
     * If the sensor is in error, color is set to RED,
     * If sensor is not in error, and its value is 1, color is set to GREEN,
     * if its value is zero it's set to GRAY.
     *
     * @param sensorInError
     * @param sensorValue
     */
    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
                setColor(Color.RED);
        } else {
            setColor(sensorValue ? Color.GREEN : Color.gray);
        }
    }

    /**
     * Update color from 2 values of a complementary sensor.
     *
     * @param sensorValue value of the sensor
     * @param sensorValueb complementary value of the sensors
     */
    public void updateColorComplementarySensor(int sensorValue, int sensorValueb) {
        boolean sensorInError = sensorValue == sensorValueb;
        if (sensorInError) {
            setColor(Color.RED);
        } else {
            setColor(1 == sensorValue ? Color.GREEN : Color.gray);
        }
    }
    
    /**
     * Update switch color from a complementary sensor
     *
     * @param sMap List of {key, value} where key is a sensor name, value is the
     * value of the sensor.
     */
    public void updateColorComplementary(Map<String, Serializable> sMap) {
        if (sMap.containsKey(sensorName) && sMap.containsKey(sensorNameB)) {
            updateColorComplementarySensor((int) sMap.get(sensorName), (int) sMap.get(sensorNameB));
        }
    }
    
    /**
     * Update color from 2 values of a redondant sensor.
     * @param sensorValue
     * @param sensorValueb 
     */
    public void updateColorRedondantSensor(int sensorValue, int sensorValueb) {
        boolean sensorInError = sensorValue != sensorValueb;
        if (sensorInError) {
            setColor(Color.RED);
        } else {
            setColor(1 == sensorValue ? Color.GREEN : Color.gray);
        }
    }

    /**
     * Update color from 2 values of a NO redondant sensor. Used when
     * DigitalSwitch display value when sensor is false. (NO sensor)
     *
     * @param sensorValue
     * @param sensorValueb
     */
    public void updateColorRedondantNoSensor(int sensorValue, int sensorValueb) {
        boolean sensorInError = sensorValue != sensorValueb;
        if (sensorInError) {
            setColor(Color.RED);
        } else {
            setColor(1 == sensorValue ? Color.gray : Color.GREEN);
        }
    }
    
    /**
     * Update switch color from a redondant sensor : fetch values in the map {key, value} given as argument.
     * @param sMap List of {key, value} where key is a sensor name, value is the value of the sensor.
     */
    public void updateColorRedondantSensor(Map<String, Serializable> sMap) {
        if (sMap.containsKey(sensorName) && sMap.containsKey(sensorNameB)) {
            FCSLOG.info("==> Updating redondant sensorname :" + sensorName + " and :" + sensorNameB);
            updateColorRedondantSensor((int) sMap.get(sensorName), (int) sMap.get(sensorNameB));
        }
    }

    /**
     * Update switch color from a redondant sensor : fetch values in the map
     * {key, value} given as argument.
     *
     * @param sMap List of {key, value} where key is a sensor name, value is the
     * value of the sensor.
     */
    public void updateColorRedondantNoSensor(Map<String, Serializable> sMap) {
        if (sMap.containsKey(sensorName) && sMap.containsKey(sensorNameB)) {
            FCSLOG.info("==> Updating redondant sensorname :" + sensorName + " and :" + sensorNameB);
            updateColorRedondantNoSensor((int) sMap.get(sensorName), (int) sMap.get(sensorNameB));
        }
    }


    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        float width = size;
        float height = size;
        float actualWidth = Math.min(width, height);

        double border = 1;

        // Draw the outline
        Shape circle = new Arc2D.Double(border, border, actualWidth - 2 * border,
                actualWidth - 2 * border, (double)0, (double)360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(color);
        g2.fill(circle);
        g2.setColor(Color.black);
        g2.draw(circle);
    }


    public static void main(String[] argv) {

        DigitalSwitch d = new DigitalSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
