
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;

/**
 * A panel to display carousel signals : CFC, CS, CF0, CF1
 *
 * @author virieux
 */
public class CarouselStatusPanel extends JPanel {

    public static final String title = "Carousel Protection Status";
    private static final long serialVersionUID = 1L;

    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch(); // Carousel_CFC
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch(); // Carousel_CS
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch(); // Carousel_CF0
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch(); // Carousel_CF1

    public CarouselStatusPanel() {
        initComponents();
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS
     * bus by the carousel (OUTPUT signals from carousel)
     */
    private class UpdateCarousel implements Runnable {

        private StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel status) {
            this.s = status;
        }

        @Override
        public void run() {
            /* Carousel_CFC (=1 if if filter is clamped on carousel) */
            carousel_CFC_Switch.updateColor(s.isOUT_CFC_InError(), s.isOUT_CFC());

            /* Carousel_CS (=1 if carousel is stopped at standby) */
            carousel_CS_Switch.updateColor(s.isOUT_CS_InError(), s.isOUT_CS());

            /* Carousel_CF0 (=1 if no filter in carousel socket) */
            carousel_CF0_Switch.updateColor(s.isOUT_CF0_InError(), s.isOUT_CF0());

            /* Carousel_CF1 (=1 if filter locked in carousel socket) */
            carousel_CF1_Switch.updateColor(s.isOUT_CF1_InError(), s.isOUT_CF1());
        }
    }

    public void updateCarousel(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new CarouselStatusPanel.UpdateCarousel(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5),
                "Read on httc580"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;
        add(new JLabel("Carousel_CFC (filter clamped)"), gbc);
        gbc.gridy++;
        add(new JLabel("Carousel_CS (socket stop at Standby)"), gbc);
        gbc.gridy++;
        add(new JLabel("Carousel_CF0 (no filter)"), gbc);
        gbc.gridy++;
        add(new JLabel("Carousel_CF1 (filter on socket)"), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        add(carousel_CFC_Switch, gbc); // CFC
        gbc.gridy++;
        add(carousel_CS_Switch, gbc);
        gbc.gridy++;
        add(carousel_CF0_Switch, gbc);
        gbc.gridy++;
        add(carousel_CF1_Switch, gbc);
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    protected void setDefaultValues() {
        // Inclinometers Panel
        carousel_CFC_Switch.setColor(Color.GRAY);
        carousel_CS_Switch.setColor(Color.GRAY);
        carousel_CF0_Switch.setColor(Color.GRAY);
        carousel_CF1_Switch.setColor(Color.GRAY);
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] argv) {
        CarouselStatusPanel d = new CarouselStatusPanel();
        JFrame frame = new JFrame("Carousel Status Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
