
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP2_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CS_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NO_LOCKOUT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_HEIGHT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_STARTINGY;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.createPanelWithComponent;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.create_subPanelWith2Switch;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCCarouselPanel extends JPanel {

    private final static String BRAKES_ACTIVATED = "Brakes<BR>Locked</BR>";
    private final static String ENABLE_UNCLAMP = "enable_unclamp";
    private final static String ENABLE_ROTATION = "enable_rotation";
    private final static String ENABLE_BRAKES = "enable_brakes";
    private final static String ENABLE_SHUTTER = "enable_shutter";
    private final static String POWER_TTC30 = "power_ttc30";
    private final static String ENGINEERING = "<BR>Carousel<BR>Engineering<BR>Mode ON";
    private final static String TP_FORCE_ROTATION_OFF = "Triple Switch:<BR><B>NOT</B><BR>Force Rotation";
    private final static String TP_STOP_ROTATION_OFF = "Triple Switch:<BR><B>NOT</B><BR>Stop Rotation";
    private final static String TP_STOP_ROTATION = "Triple Switch:<BR>Stop Rotation";
    private final static String NO_POWER_SAVE = "<B>NOT</B> Power<BR>Save<BR>";
    private final static String POWER_SAVE = "Power<BR>Save<BR>";
    private final static String SLEEP_ON = "Sleep<BR>On<BR>";
    private final static String SHUTTER_INACTIVE = "Shutter<BR>Inactive<BR>";
    private final static String ENABLE_SHUTTER_INTERLOCK = "Shutter<BR>Interlock OFF<BR>";
    private final static String OK_DI = "okDI";
    private final static String OK_DI_SAFETY = "okDI<BR>Safety<BR>";

    private DigitalSwitch[] digitalList;
    private DiamondSwitch[] diamondList;
    private RectangleSwitch[] relayList;

    private final DigitalSwitch ap1Switch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch cf0Switch = new DigitalSwitch();
    private final DigitalSwitch cf1Switch = new DigitalSwitch();
    private final DigitalSwitch csSwitch = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchU = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch();
    private final DigitalSwitch noLockoutSwitchU = new DigitalSwitch();
    private final DigitalSwitch noLockoutSwitchR = new DigitalSwitch();
    private final DigitalSwitch shutterInactiveSwitch = new DigitalSwitch();
    private final DigitalSwitch noTpForceRotationSwitch = new DigitalSwitch();
    private final DigitalSwitch noTpForceRotationSwitchS = new DigitalSwitch();
    private final DigitalSwitch noTpStopRotationSwitch = new DigitalSwitch();
    private final DigitalSwitch tpStopRotationSwitch = new DigitalSwitch();


    private final DiamondSwitch brakesSwitchU = new DiamondSwitch();
    private final DiamondSwitch brakesSwitchS = new DiamondSwitch();
    private final DiamondSwitch brakesSwitchP = new DiamondSwitch();
    private final DiamondSwitch noPowerSaveSwitchR = new DiamondSwitch();
    private final DiamondSwitch noPowerSaveSwitchT = new DiamondSwitch();
    private final DiamondSwitch sleepSwitch = new DiamondSwitch();
    private final DiamondSwitch powerSaveSwitch = new DiamondSwitch();
    private final DiamondSwitch enableShutterInterlockSwitchR = new DiamondSwitch();
    private final DiamondSwitch okDISwitchU = new DiamondSwitch();
    private final DiamondSwitch okDISwitchR = new DiamondSwitch();
    private final DiamondSwitch okDIsafetySwitchU = new DiamondSwitch();
    private final DiamondSwitch okDIsafetySwitchR = new DiamondSwitch();

    /* Relays*/
    private final RectangleSwitch unclampRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch rotationRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch noRotationRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch brakesRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch shutterRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch ttc30Rectangle = new RectangleSwitch();

    /**
     * A Runnable to initialize this Panel from status data published on the
     * STATUS bus by the carousel (OUTPUT signals from carousel)
     */
    private class UpdateCarousel implements Runnable {

        private StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel status) {
            this.s = status;
        }

        @Override
        public void run() {
            /* Carousel_CS (=1 if carousel is stopped at standby) */
            csSwitch.updateColor(s.isOUT_CS_InError(), s.isOUT_CS());

            /* Carousel_CF0 (=1 if no filter in carousel socket) */
            cf0Switch.updateColor(s.isOUT_CF0_InError(), s.isOUT_CF0());

            /* Carousel_CF1 (=1 if filter locked in carousel socket) */
            cf1Switch.updateColor(s.isOUT_CF1_InError(), s.isOUT_CF1());

            ap1Switch.updateColor(s.isAp1_InError(), s.isAp1());
            ap2Switch.updateColor(s.isAp2_InError(), s.isAp2());
            ap3Switch.updateColor(s.isAp3_InError(), s.isAp3());
            af3Switch.updateColor(s.isAf3_InError(), s.isAf3());

            noTpForceRotationSwitch.updateColor(s.isTp_InError(), !s.isTpStopUnclamp());
            noTpForceRotationSwitchS.updateColor(s.isTp_InError(), !s.isTpStopUnclamp());
            noTpStopRotationSwitch.updateColor(s.isTp_InError(), !s.isTpStopRotation());
            tpStopRotationSwitch.updateColor(s.isTp_InError(), s.isTpStopRotation());
            noLockoutSwitchU.updateColor(s.isCaLockout_InError(), !s.isCaLockout());
            noLockoutSwitchR.updateColor(s.isCaLockout_InError(), !s.isCaLockout());
            engineeringSwitchU.updateColor(s.isCaEng_InError(), s.isCaEng());
            engineeringSwitchR.updateColor(s.isCaEng_InError(), s.isCaEng());
            brakesSwitchU.setColor(s.isBrakesActivated() ? Color.GREEN : Color.gray);
            brakesSwitchS.setColor(s.isBrakesActivated() ? Color.GREEN : Color.gray);
            brakesSwitchP.setColor(s.isBrakesActivated() ? Color.GREEN : Color.gray);
            okDISwitchU.setColor(s.isOkDI() ? Color.GREEN : Color.gray);
            okDISwitchR.setColor(s.isOkDI() ? Color.GREEN : Color.gray);
            okDIsafetySwitchU.setColor(s.isOkDIsafety() ? Color.GREEN : Color.gray);
            okDIsafetySwitchR.setColor(s.isOkDIsafety() ? Color.GREEN : Color.gray);
            /* Power Save = Sleep = 1 pour OFF (no Power Save)*/
            noPowerSaveSwitchR.setColor(s.isPowerSave() ? Color.gray : Color.GREEN);
            noPowerSaveSwitchT.setColor(s.isPowerSave() ? Color.gray : Color.GREEN);
            sleepSwitch.setColor(s.isPowerSave() ? Color.GREEN : Color.gray);
            ttc30Rectangle.setColor(s.isSleep() ? Color.GREEN : Color.gray);
            powerSaveSwitch.setColor(s.isPowerSave() ? Color.GREEN : Color.gray);
            shutterInactiveSwitch.setColor(s.isShutterInactive() ? Color.GREEN : Color.gray);
            brakesRelayRectangle.setColor(s.isEnableBrakes() ? Color.GREEN : Color.gray);
            rotationRelayRectangle.setColor(s.isEnableRotation() ? Color.GREEN : Color.gray);
            noRotationRelayRectangle.setColor(s.isEnableRotation() ? Color.gray : Color.GREEN);
            unclampRelayRectangle.setColor(s.isEnableUnclamp() ? Color.GREEN : Color.gray);
            shutterRelayRectangle.setColor(s.isEnableShutter() ? Color.GREEN : Color.gray);
            enableShutterInterlockSwitchR.setColor(s.isEnableShutterInterlock() ? Color.gray : Color.GREEN);
            
        }
    }

    public PLCCarouselPanel() {
        initComponents();
    }

    public void updateCarousel(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new UpdateCarousel(s));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         * *******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("CAROUSEL PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy++;
        add(create_explanationsPanel(), gbc);
        gbc.gridy++;
        gbc.gridy++;
        add(create_unclampPanel(), gbc);
        gbc.gridy++;
        add(create_rotationPanel(), gbc);
        gbc.gridy++;
        add(create_shutterPanel(), gbc);
        gbc.gridy++;
        add(create_ttc30Panel(), gbc);
        gbc.gridy++;
        add(create_powerSavePanel(), gbc);
        /* set default values for whole panel*/
        setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.WEST;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridwidth = 3;
        panel.add(new JLabel("<HTML><b>Signals displayed on this panel are read on hyttc580 (Carousel PLC)</b></HTML>"), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridy++;
        panel.add(new JLabel(AP1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP2_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><BR></BR></HTML>"), gbcp);

        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add(new JLabel(CS_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(CF0_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(CF1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><B> okDI</B>: AP1, AP2, AP3, AF3, CS, CF0, CF1, Lockout Bay L and TripleSwitch are valid</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><B> okDISafety</B>: Lockout Bay L and TripleSwitch are valid</HTML>"), gbcp);

        gbcp.gridy = 1;
        gbcp.gridx = 4;
        panel.add(new JLabel("<HTML><B> Force Rotation</B>: Only rotation is allowed</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><B> Stop Rotation</B>: Rotation is forbidden</HTML>"), gbcp);

        return panel;
    }

    public JPanel create_unclampPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable unclamp"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        /* line 1*/
        panel.add(createPanelWithComponent(BRAKES_ACTIVATED, brakesSwitchU, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("CS", csSwitch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_unclampSubPanel(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(OK_DI, okDISwitchU, true, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(160, 45), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(OK_DI_SAFETY, okDIsafetySwitchU, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(TP_FORCE_ROTATION_OFF, noTpForceRotationSwitch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(NO_LOCKOUT, noLockoutSwitchU, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(ENABLE_UNCLAMP, unclampRelayRectangle, false, false), gbcp);

        /* line 2*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridwidth = 5;
        panel.add(createPanelWithComponent(ENGINEERING, engineeringSwitchU, false, true, 400), gbcp);
        gbcp.gridwidth = 1;
        return panel;
    }

    public JPanel create_unclampSubPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent("CF1", cf1Switch, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP1", ap1Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3Switch, false, true), gbcp);
        gbcp.gridx++;

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        gbcp.gridwidth = 3;
        panel.add(createPanelWithComponent("<BR>CF0</BR>", cf0Switch, true, true, 100), gbcp);
        gbcp.gridwidth = 1;

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        return panel;
    }
    
    public JPanel create_rotationPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable rotation and brakes"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(create_ap2ap3Subpanel(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(NO_POWER_SAVE, noPowerSaveSwitchR, true, true), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(ENABLE_SHUTTER_INTERLOCK, enableShutterInterlockSwitchR, SHUTTER_INACTIVE, shutterInactiveSwitch), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(OK_DI, okDISwitchR, true, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(150, 45), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(OK_DI_SAFETY, okDIsafetySwitchR, true, true), gbcp);
        gbcp.gridx++;        
        panel.add(createPanelWithComponent(TP_STOP_ROTATION_OFF, noTpStopRotationSwitch, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(NO_LOCKOUT, noLockoutSwitchR, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_rotationRelaySubpanel(), gbcp);

        /* line 2 */
        gbcp.gridy++;
        gbcp.gridx = 0;
        gbcp.gridheight = 1;
        gbcp.gridwidth = 5;
        panel.add(createPanelWithComponent(ENGINEERING, engineeringSwitchR, false, true, 600), gbcp);

        return panel;
    }

    public JPanel create_ap2ap3Subpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        /* line 1*/
        panel.add(createPanelWithComponent("AP2", ap2Switch, false, true), gbcp);
        /* line 2*/
        gbcp.gridy++;
        panel.add(createPanelWithComponent("<BR>AP3</BR>", ap3Switch, false, true), gbcp);
        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }

    public JPanel create_rotationRelaySubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(100, SP_V_LINE_STARTINGY), gbcp);
        /* line 1*/
        gbcp.gridheight = 1;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(ENABLE_BRAKES, brakesRelayRectangle, true, false), gbcp);
        /* line 2*/
        gbcp.gridy++;
        panel.add(createPanelWithComponent("<BR>" + ENABLE_ROTATION + "</BR>", rotationRelayRectangle, true, false), gbcp);
        return panel;
    }
    
    public JPanel create_shutterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable shutter"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        /* line 1*/
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(TP_STOP_ROTATION, tpStopRotationSwitch, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(100, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(ENABLE_SHUTTER, shutterRelayRectangle, true, false), gbcp);

        /* line 2*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(BRAKES_ACTIVATED, brakesSwitchS, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(TP_FORCE_ROTATION_OFF, noTpForceRotationSwitchS, false, true), gbcp);
        return panel;
    }
    
    public JPanel create_ttc30Panel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Power ttc30"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(NO_POWER_SAVE, noPowerSaveSwitchT, false, true), gbcp);  
        gbcp.gridx++;
        panel.add(createPanelWithComponent(POWER_TTC30, ttc30Rectangle, false, false), gbcp);  
        return panel;
    }

    public JPanel create_powerSavePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Power Save"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(BRAKES_ACTIVATED, brakesSwitchP, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(SLEEP_ON, sleepSwitch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(POWER_SAVE, powerSaveSwitch, false, false), gbcp);
        gbcp.gridx++;
        return panel;
    }

    public void setDefaultValues() {
        digitalList = new DigitalSwitch[]{
            csSwitch, cf0Switch, cf1Switch, ap1Switch, ap2Switch, ap3Switch, af3Switch,
            engineeringSwitchU, engineeringSwitchR,
            noTpForceRotationSwitch, noTpForceRotationSwitchS, noLockoutSwitchU, noLockoutSwitchR, shutterInactiveSwitch,
            noTpStopRotationSwitch, tpStopRotationSwitch,};
        diamondList = new DiamondSwitch[]{
            brakesSwitchU, brakesSwitchS, brakesSwitchP, noPowerSaveSwitchR, noPowerSaveSwitchT,
            sleepSwitch, enableShutterInterlockSwitchR,
            okDISwitchU, okDISwitchR, okDIsafetySwitchU, okDIsafetySwitchR,
        };
        relayList = new RectangleSwitch[]{unclampRelayRectangle, rotationRelayRectangle,
            brakesRelayRectangle, shutterRelayRectangle, ttc30Rectangle};
        for (DigitalSwitch c : digitalList) {
            c.setColor(Color.gray);
        }
        for (DiamondSwitch c : diamondList) {
            c.setColor(Color.gray);
        }
        for (RectangleSwitch c : relayList) {
            c.setColor(Color.gray);
        }
    }
    



    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Carousel Panel";
    }

}
