/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCCarouselPanel
extends JPanel {
    private static final String BRAKES_ACTIVATED = "Brakes<BR>Locked</BR>";
    private static final String ENABLE_UNCLAMP = "enable_unclamp";
    private static final String ENABLE_ROTATION = "enable_rotation";
    private static final String ENABLE_BRAKES = "enable_brakes";
    private static final String ENABLE_SHUTTER = "enable_shutter";
    private static final String POWER_TTC30 = "power_ttc30";
    private static final String ENGINEERING = "<BR>Carousel<BR>Engineering<BR>Mode ON";
    private static final String TP_FORCE_ROTATION_OFF = "Triple Switch:<BR><B>NOT</B><BR>Force Rotation";
    private static final String TP_STOP_ROTATION_OFF = "Triple Switch:<BR><B>NOT</B><BR>Stop Rotation";
    private static final String TP_STOP_ROTATION = "Triple Switch:<BR>Stop Rotation";
    private static final String NO_POWER_SAVE = "<B>NOT</B> Power<BR>Save<BR>";
    private static final String POWER_SAVE = "Power<BR>Save<BR>";
    private static final String SLEEP_ON = "Sleep<BR>On<BR>";
    private static final String SHUTTER_INACTIVE = "Shutter<BR>Inactive<BR>";
    private static final String ENABLE_SHUTTER_INTERLOCK = "Shutter<BR>Interlock OFF<BR>";
    private static final String OK_DI = "okDI";
    private static final String OK_DI_SAFETY = "okDI<BR>Safety<BR>";
    private DigitalSwitch[] digitalList;
    private DiamondSwitch[] diamondList;
    private RectangleSwitch[] relayList;
    private final DigitalSwitch ap1Switch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch cf0Switch = new DigitalSwitch();
    private final DigitalSwitch cf1Switch = new DigitalSwitch();
    private final DigitalSwitch csSwitch = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchU = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch();
    private final DigitalSwitch noLockoutSwitchU = new DigitalSwitch();
    private final DigitalSwitch noLockoutSwitchR = new DigitalSwitch();
    private final DigitalSwitch shutterInactiveSwitch = new DigitalSwitch();
    private final DigitalSwitch noTpForceRotationSwitch = new DigitalSwitch();
    private final DigitalSwitch noTpForceRotationSwitchS = new DigitalSwitch();
    private final DigitalSwitch noTpStopRotationSwitch = new DigitalSwitch();
    private final DigitalSwitch tpStopRotationSwitch = new DigitalSwitch();
    private final DiamondSwitch brakesSwitchU = new DiamondSwitch();
    private final DiamondSwitch brakesSwitchS = new DiamondSwitch();
    private final DiamondSwitch brakesSwitchP = new DiamondSwitch();
    private final DiamondSwitch noPowerSaveSwitchR = new DiamondSwitch();
    private final DiamondSwitch noPowerSaveSwitchT = new DiamondSwitch();
    private final DiamondSwitch sleepSwitch = new DiamondSwitch();
    private final DiamondSwitch powerSaveSwitch = new DiamondSwitch();
    private final DiamondSwitch enableShutterInterlockSwitchR = new DiamondSwitch();
    private final DiamondSwitch okDISwitchU = new DiamondSwitch();
    private final DiamondSwitch okDISwitchR = new DiamondSwitch();
    private final DiamondSwitch okDIsafetySwitchU = new DiamondSwitch();
    private final DiamondSwitch okDIsafetySwitchR = new DiamondSwitch();
    private final RectangleSwitch unclampRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch rotationRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch noRotationRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch brakesRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch shutterRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch ttc30Rectangle = new RectangleSwitch();

    public PLCCarouselPanel() {
        this.initComponents();
    }

    public void updateCarousel(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new UpdateCarousel(s));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("CAROUSEL PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        ++gbc.gridy;
        this.add((Component)this.create_explanationsPanel(), gbc);
        ++gbc.gridy;
        ++gbc.gridy;
        this.add((Component)this.create_unclampPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_rotationPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_shutterPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_ttc30Panel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_powerSavePanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridwidth = 3;
        panel.add((Component)new JLabel("<HTML><b>Signals displayed on this panel are read on hyttc580 (Carousel PLC)</b></HTML>"), gbcp);
        gbcp.gridwidth = 1;
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP1</b>: autochanger at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP3</b>: autochanger at ONLINE position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF3</b>: filter engaged and locked on autochanger  &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><BR></BR></HTML>"), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add((Component)new JLabel("<HTML><b>CS</b>: carousel stopped at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF0</b>: no filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF1</b>: filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><B> okDI</B>: AP1, AP2, AP3, AF3, CS, CF0, CF1, Lockout Bay L and TripleSwitch are valid</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><B> okDISafety</B>: Lockout Bay L and TripleSwitch are valid</HTML>"), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 4;
        panel.add((Component)new JLabel("<HTML><B> Force Rotation</B>: Only rotation is allowed</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><B> Stop Rotation</B>: Rotation is forbidden</HTML>"), gbcp);
        return panel;
    }

    public JPanel create_unclampPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable unclamp"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent(BRAKES_ACTIVATED, this.brakesSwitchU, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_unclampSubPanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(OK_DI, this.okDISwitchU, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(160, 45), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(OK_DI_SAFETY, this.okDIsafetySwitchU, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(TP_FORCE_ROTATION_OFF, this.noTpForceRotationSwitch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", this.noLockoutSwitchU, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(ENABLE_UNCLAMP, this.unclampRelayRectangle, false, false), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridwidth = 5;
        panel.add((Component)Tools.createPanelWithComponent(ENGINEERING, this.engineeringSwitchU, false, true, 400), gbcp);
        gbcp.gridwidth = 1;
        return panel;
    }

    public JPanel create_unclampSubPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("CF1", this.cf1Switch, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP1", this.ap1Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3Switch, false, true), gbcp);
        ++gbcp.gridx;
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridwidth = 3;
        panel.add((Component)Tools.createPanelWithComponent("<BR>CF0</BR>", this.cf0Switch, true, true, 100), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public JPanel create_rotationPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable rotation and brakes"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)this.create_ap2ap3Subpanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(NO_POWER_SAVE, this.noPowerSaveSwitchR, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch(ENABLE_SHUTTER_INTERLOCK, this.enableShutterInterlockSwitchR, SHUTTER_INACTIVE, this.shutterInactiveSwitch), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(OK_DI, this.okDISwitchR, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(150, 45), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(OK_DI_SAFETY, this.okDIsafetySwitchR, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(TP_STOP_ROTATION_OFF, this.noTpStopRotationSwitch, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", this.noLockoutSwitchR, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_rotationRelaySubpanel(), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 0;
        gbcp.gridheight = 1;
        gbcp.gridwidth = 5;
        panel.add((Component)Tools.createPanelWithComponent(ENGINEERING, this.engineeringSwitchR, false, true, 600), gbcp);
        return panel;
    }

    public JPanel create_ap2ap3Subpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP2", this.ap2Switch, false, true), gbcp);
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("<BR>AP3</BR>", this.ap3Switch, false, true), gbcp);
        gbcp.gridy = 0;
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public JPanel create_rotationRelaySubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(100, 22), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent(ENABLE_BRAKES, this.brakesRelayRectangle, true, false), gbcp);
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("<BR>enable_rotation</BR>", this.rotationRelayRectangle, true, false), gbcp);
        return panel;
    }

    public JPanel create_shutterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable shutter"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent(TP_STOP_ROTATION, this.tpStopRotationSwitch, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(100, 22), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(ENABLE_SHUTTER, this.shutterRelayRectangle, true, false), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent(BRAKES_ACTIVATED, this.brakesSwitchS, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(TP_FORCE_ROTATION_OFF, this.noTpForceRotationSwitchS, false, true), gbcp);
        return panel;
    }

    public JPanel create_ttc30Panel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Power ttc30"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent(NO_POWER_SAVE, this.noPowerSaveSwitchT, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(POWER_TTC30, this.ttc30Rectangle, false, false), gbcp);
        return panel;
    }

    public JPanel create_powerSavePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Power Save"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent(BRAKES_ACTIVATED, this.brakesSwitchP, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(SLEEP_ON, this.sleepSwitch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(POWER_SAVE, this.powerSaveSwitch, false, false), gbcp);
        ++gbcp.gridx;
        return panel;
    }

    public void setDefaultValues() {
        this.digitalList = new DigitalSwitch[]{this.csSwitch, this.cf0Switch, this.cf1Switch, this.ap1Switch, this.ap2Switch, this.ap3Switch, this.af3Switch, this.engineeringSwitchU, this.engineeringSwitchR, this.noTpForceRotationSwitch, this.noTpForceRotationSwitchS, this.noLockoutSwitchU, this.noLockoutSwitchR, this.shutterInactiveSwitch, this.noTpStopRotationSwitch, this.tpStopRotationSwitch};
        this.diamondList = new DiamondSwitch[]{this.brakesSwitchU, this.brakesSwitchS, this.brakesSwitchP, this.noPowerSaveSwitchR, this.noPowerSaveSwitchT, this.sleepSwitch, this.enableShutterInterlockSwitchR, this.okDISwitchU, this.okDISwitchR, this.okDIsafetySwitchU, this.okDIsafetySwitchR};
        this.relayList = new RectangleSwitch[]{this.unclampRelayRectangle, this.rotationRelayRectangle, this.brakesRelayRectangle, this.shutterRelayRectangle, this.ttc30Rectangle};
        for (DigitalSwitch digitalSwitch : this.digitalList) {
            digitalSwitch.setColor(Color.gray);
        }
        for (JComponent jComponent : this.diamondList) {
            ((DiamondSwitch)jComponent).setColor(Color.gray);
        }
        for (JComponent jComponent : this.relayList) {
            ((RectangleSwitch)jComponent).setColor(Color.gray);
        }
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Carousel Panel";
    }

    private class UpdateCarousel
    implements Runnable {
        private StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCCarouselPanel.this.csSwitch.updateColor(this.s.isOUT_CS_InError(), this.s.isOUT_CS());
            PLCCarouselPanel.this.cf0Switch.updateColor(this.s.isOUT_CF0_InError(), this.s.isOUT_CF0());
            PLCCarouselPanel.this.cf1Switch.updateColor(this.s.isOUT_CF1_InError(), this.s.isOUT_CF1());
            PLCCarouselPanel.this.ap1Switch.updateColor(this.s.isAp1_InError(), this.s.isAp1());
            PLCCarouselPanel.this.ap2Switch.updateColor(this.s.isAp2_InError(), this.s.isAp2());
            PLCCarouselPanel.this.ap3Switch.updateColor(this.s.isAp3_InError(), this.s.isAp3());
            PLCCarouselPanel.this.af3Switch.updateColor(this.s.isAf3_InError(), this.s.isAf3());
            PLCCarouselPanel.this.noTpForceRotationSwitch.updateColor(this.s.isTp_InError(), !this.s.isTpStopUnclamp());
            PLCCarouselPanel.this.noTpForceRotationSwitchS.updateColor(this.s.isTp_InError(), !this.s.isTpStopUnclamp());
            PLCCarouselPanel.this.noTpStopRotationSwitch.updateColor(this.s.isTp_InError(), !this.s.isTpStopRotation());
            PLCCarouselPanel.this.tpStopRotationSwitch.updateColor(this.s.isTp_InError(), this.s.isTpStopRotation());
            PLCCarouselPanel.this.noLockoutSwitchU.updateColor(this.s.isCaLockout_InError(), !this.s.isCaLockout());
            PLCCarouselPanel.this.noLockoutSwitchR.updateColor(this.s.isCaLockout_InError(), !this.s.isCaLockout());
            PLCCarouselPanel.this.engineeringSwitchU.updateColor(this.s.isCaEng_InError(), this.s.isCaEng());
            PLCCarouselPanel.this.engineeringSwitchR.updateColor(this.s.isCaEng_InError(), this.s.isCaEng());
            PLCCarouselPanel.this.brakesSwitchU.setColor(this.s.isBrakesActivated() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.brakesSwitchS.setColor(this.s.isBrakesActivated() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.brakesSwitchP.setColor(this.s.isBrakesActivated() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.okDISwitchU.setColor(this.s.isOkDI() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.okDISwitchR.setColor(this.s.isOkDI() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.okDIsafetySwitchU.setColor(this.s.isOkDIsafety() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.okDIsafetySwitchR.setColor(this.s.isOkDIsafety() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.noPowerSaveSwitchR.setColor(this.s.isPowerSave() ? Color.gray : Color.GREEN);
            PLCCarouselPanel.this.noPowerSaveSwitchT.setColor(this.s.isPowerSave() ? Color.gray : Color.GREEN);
            PLCCarouselPanel.this.sleepSwitch.setColor(this.s.isPowerSave() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.ttc30Rectangle.setColor(this.s.isSleep() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.powerSaveSwitch.setColor(this.s.isPowerSave() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.shutterInactiveSwitch.setColor(this.s.isShutterInactive() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.brakesRelayRectangle.setColor(this.s.isEnableBrakes() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.rotationRelayRectangle.setColor(this.s.isEnableRotation() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.noRotationRelayRectangle.setColor(this.s.isEnableRotation() ? Color.gray : Color.GREEN);
            PLCCarouselPanel.this.unclampRelayRectangle.setColor(this.s.isEnableUnclamp() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.shutterRelayRectangle.setColor(this.s.isEnableShutter() ? Color.GREEN : Color.gray);
            PLCCarouselPanel.this.enableShutterInterlockSwitchR.setColor(this.s.isEnableShutterInterlock() ? Color.gray : Color.GREEN);
        }
    }
}

