/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

public class CarouselStatusPanel
extends JPanel {
    public static final String title = "Carousel Protection Status";
    private static final long serialVersionUID = 1L;
    public static final String CFC = "caCFC";
    public static final String CFCB = "caCFCb";
    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch("caCFC", "caCFCb");
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch("caCS", "caCSb");
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch("caCF0", "caCF0b");
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch("caCF1", "caCF1b");
    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{this.carousel_CFC_Switch, this.carousel_CS_Switch, this.carousel_CF0_Switch, this.carousel_CF1_Switch};

    public CarouselStatusPanel() {
        this.initComponents();
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        JPanel statusPane = new JPanel();
        statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Carousel"), 2), "Read on httc580"));
        statusPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        statusPane.add((Component)new JLabel("CFC (filter clamped)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("CS (stopped at standby)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("CF0 (no filter)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("CF1 (filter on socket)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("carousel")), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("carousel")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        statusPane.add((Component)this.carousel_CFC_Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.carousel_CS_Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.carousel_CF0_Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.carousel_CF1_Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        JPanel carouselStatusPane = new JPanel();
        carouselStatusPane.setLayout(new BoxLayout(carouselStatusPane, 0));
        carouselStatusPane.add(new VerticalTextComponent("Carousel"));
        carouselStatusPane.add(statusPane);
        this.setLayout(new CardLayout());
        this.add(carouselStatusPane);
        this.add(Tools.getPanelPlaceHolder("carousel_pane"));
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        for (DigitalSwitch ds : this.digitalList) {
            ds.setColor(Color.GRAY);
        }
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] argv) {
        CarouselStatusPanel d = new CarouselStatusPanel();
        JFrame frame = new JFrame("Carousel Status Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds : CarouselStatusPanel.this.digitalList) {
                ds.updateColorComplementary(this.sensorMap);
            }
        }
    }
}

