package org.lsst.ccs.subsystems.fcs.ui.commons;

import javax.swing.JComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class VerticalTextComponent extends JComponent {
    private static final Color col_loader = new Color(0x07393C); // Midnight green (see https://coolors.co/)
    private static final Color col_carousel = new Color(0x593959); // English violet
    private static final Color col_autochanger = new Color(0x7D98A1); // Cadet gray
    private final String text;

    public VerticalTextComponent(String text) {
        this.text = text;
        setFont(new Font("Arial", Font.BOLD, 12));
        setForeground(getSubsystemColor(text));
    }

    public static Color getSubsystemColor(String subsystem) {
        switch (subsystem.toLowerCase()) {
            case "carousel":
                return col_carousel;
            case "autochanger":
                return col_autochanger;
            case "loader":
                return col_loader;
            default:
                return Color.BLACK;
        }
    }

    private Dimension calculatePreferredSize() {
        FontMetrics fm = getFontMetrics(getFont());
        int width = fm.getHeight() + 5; // Use the font height as width
        int height = fm.stringWidth(text); // Use the text width as height
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return calculatePreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(getFont());
        g.setColor(getForeground());
        int x = getWidth() / 2 + 5;
        int y = getHeight() - 5;
        Graphics2D g2d = (Graphics2D) g;
        g2d.rotate(-Math.PI / 2, x, y);
        g2d.drawString(text, x, y);
    }
}
