package org.lsst.ccs.subsystems.fcs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CARRIER_CONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CA_ROTATIONCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.HOOKS_CONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.HYTTC580Panel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.getShortComponentName;

/**
 * A Panel to gather all the FCS panels.
 * This takes care of the update
 * @author virieux
 */
public class FcsGatherPanel extends GatherPanel {
    private static final long serialVersionUID = 2279646593279606470L;

    private FcsGUI subs;
    private FcsGeneralViewPanel generalViewPanel;
    private ControllersViewPanel controllersViewPanel;
    private CarouselGatherPanel carouselGatherPanel;
    private AutochangerGatherPanel autochangerGatherPanel;
    private LoaderGatherPanel loaderGatherPanel;

    /**
     * Build a new FcsGatherPanel with a tcpProxy name.
     * To test GUI.
     * @param tcpProxyName
     */
    public FcsGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
    }

    /**
     * Build a new FcsGatherPanel with a subsystem and a tcpProxy name.
     * @param subs
     */
    public FcsGatherPanel(FcsGUI subs) {
        super(CHANGER_TCPPROXY_NAME);
        this.subs = subs;
        this.generalViewPanel = new FcsGeneralViewPanel();
        this.generalViewPanel.setSubs(subs);
        this.controllersViewPanel = new ControllersViewPanel(subs);
        this.carouselGatherPanel = new CarouselGatherPanel((InterfaceCarouselGUI)subs,CHANGER_TCPPROXY_NAME);
        this.autochangerGatherPanel = new AutochangerGatherPanel((InterfaceAutochangerGUI) subs,CHANGER_TCPPROXY_NAME);
        this.loaderGatherPanel = new LoaderGatherPanel((InterfaceLoaderGUI) subs,LOADER_TCPPROXY_NAME);
    }

    public FcsGeneralViewPanel getGeneralViewPanel() {
        return generalViewPanel;
    }

    public ControllersViewPanel getControllersViewPanel() {
        return controllersViewPanel;
    }

    public CarouselGatherPanel getCarouselGatherPanel() {
        return carouselGatherPanel;
    }

    public AutochangerGatherPanel getAutochangerGatherPanel() {
        return autochangerGatherPanel;
    }

    public LoaderGatherPanel getLoaderGatherPanel() {
        return loaderGatherPanel;
    }


    /**
     * Return clampXminusController panel
     * @return
     */
    public EPOSControllerPanel getClampXminusControllerPanel() {
        return carouselGatherPanel.getClampXminusControllerPanel();
    }

    /**
     * Return clampXplusController panel
     * @return
     */
    public EPOSControllerPanel  getClampXplusControllerPanel() {
        return carouselGatherPanel.getClampXplusControllerPanel();
    }

    /**
     * Return the carousel controller panel.
     * @return
     */
    public EPOSControllerPanel  getCarouselControllerPanel() {
        return carouselGatherPanel.getCarouselControllerPanel();
    }

    /**
     * return the carousel HyTTC-580 panel
     * @return
     */
    public HYTTC580Panel getHyTTCPanel() {
        return carouselGatherPanel.getHyTTCPanel();
    }

    /**
     * return the CAN-CBX-4I814 panel
     * @return
     */
    public CanOpenDevicePanel getCancbxAI814Panel() {
        return carouselGatherPanel.getCancbxAI814Panel();
    }

    /**
     * return the CAN-CBX-PT100 Panel
     * @return
     */
    public CanOpenDevicePanel getCancbxPT100Panel() {
        return carouselGatherPanel.getCancbxPT100Panel();
    }

    public PlutoGatewayPanel  getPlutoGatewayPanel() {
        return autochangerGatherPanel.getPlutoGatewayPanel();
    }

    public CanOpenDevicePanel getOnlineStrainGaugePanel() {
        return autochangerGatherPanel.getOnlineStrainGaugePanel();
    }

    public EPOSControllerPanel  getLatchXminusControllerPanel() {
        return autochangerGatherPanel.getLatchXminusControllerPanel();
    }

    public EPOSControllerPanel  getLatchXplusControllerPanel() {
        return autochangerGatherPanel.getLatchXplusControllerPanel();

    }

    public EPOSControllerPanel  getAcTruckXminusControllerPanel() {
        return autochangerGatherPanel.getAcTruckXminusControllerPanel();
    }
    public EPOSControllerPanel  getAcTruckXplusControllerPanel() {
        return autochangerGatherPanel.getAcTruckXplusControllerPanel();
    }

    public EPOSControllerPanel  getOnlineClampXminusControllerPanel() {
        return autochangerGatherPanel.getOnlineClampXminusControllerPanel();
    }

    public EPOSControllerPanel  getOnlineClampXplusControllerPanel() {
        return autochangerGatherPanel.getOnlineClampXplusControllerPanel();
    }

    public EPOSControllerPanel  getOnlineClampYminusControllerPanel() {
        return autochangerGatherPanel.getOnlineClampYminusControllerPanel();
    }


    @Override
    public void updateFromStatusData(KeyValueData data) {

        if (CHANGER_TCPPROXY_NAME.equals(data.getKey())) {
            updateCanOpenHardwarePanel((int)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            updateCanOpenHardwarePanel(getShortComponentName(data.getKey()), (StatusDataPublishedByHardware) data.getValue());
            if (CA_ROTATIONCONTROLLER_NAME.equals(data.getKey())) {
                generalViewPanel.updateController((StatusDataPublishedByEPOSController) data.getValue());
            } else if (CARRIER_CONTROLLER_NAME.equals(getShortComponentName(data.getKey()))) {
                generalViewPanel.updateCarrierController((StatusDataPublishedByEPOSController) data.getValue());
            } else if (HOOKS_CONTROLLER_NAME.equals(getShortComponentName(data.getKey()))) {
                generalViewPanel.updateClampController((StatusDataPublishedByEPOSController) data.getValue());
            }
            controllersViewPanel.updateFromStatusData(data);

        } else if (data.getValue() instanceof StatusDataPublishedByPlutoGateway) {
            updateCanOpenHardwarePanel(getShortComponentName(data.getKey()), (StatusDataPublishedByHardware) data.getValue());

        } else if (data.getValue() instanceof StatusDataPublishedByHardware) {
            updateCanOpenHardwarePanel(getShortComponentName(data.getKey()), (StatusDataPublishedByHardware) data.getValue());
        }
        carouselGatherPanel.updateFromStatusData(data);
        autochangerGatherPanel.updateFromStatusData(data);
        loaderGatherPanel.updateFromStatusData(data);
        generalViewPanel.updateFromStatusData(data);
    }


    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        carouselGatherPanel.updateFromConfigurationInfo(configInfo);
        autochangerGatherPanel.updateFromConfigurationInfo(configInfo);
        loaderGatherPanel.updateFromConfigurationInfo(configInfo);
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo,
            List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        carouselGatherPanel.initializeGUIWithConfigInfo(configInfo,hardwareNames);
        autochangerGatherPanel.initializeGUIWithConfigInfo(configInfo,hardwareNames);
    }

    @Override
    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo,
            List<String> hardwareNames) {
        loaderGatherPanel.initializeGUIWithConfigInfo(configInfo,hardwareNames);
    }

    @Override
    public void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithSensorsList: " + sensorsList.toString());
        autochangerGatherPanel.initializeGuiWithAutochangerSensorsList(configInfo, sensorsList);
    }

    @Override
    public void initializeGuiWithLoaderSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithLoaderSensorsList: " + sensorsList.toString());
        loaderGatherPanel.initializeGuiWithLoaderSensorsList(configInfo, sensorsList);
    }

    /**
     *
     * @param controllersMap
     */
    @Override
    public void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        autochangerGatherPanel.initializeGUIWithControllersMap(controllersMap);
    }

    /**
     * This method is to retrieve the configuration information for the filters from the ConfigurationInfo
     * and the list of filter names.
     * @param configInfo
     * @param filterNamesList
     * @throws java.lang.InterruptedException
     * @throws java.lang.reflect.InvocationTargetException
     */
    @Override
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList)
            throws InterruptedException, InvocationTargetException {
        carouselGatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }


    /**
     * Reset Panel with initial text, color, reset hardware table and filter
     * table.
     */
    @Override
    public void resetPanel() {
        super.resetPanel();
        carouselGatherPanel.resetPanel();
        autochangerGatherPanel.resetPanel();
        loaderGatherPanel.resetPanel();
    }


}
